/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Hashtable;

public class TransactionState
implements Externalizable,
Serializable {
    static final long serialVersionUID = 8746365555417644726L;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    public static final int COMMITTED = 6;
    public static final int ROLLEDBACK = 7;
    public static final int TIMED_OUT = 8;
    public static final int LAST = 8;
    public static final int NULL = -1;
    private static final String[] names = new String[]{"CREATED", "STARTED", "FAILED", "INCOMPLETE", "COMPLETE", "PREPARED", "COMMITED", "ROLLEDBACK", "TIMED_OUT"};
    private JMQXid xid = null;
    private long createTime = 0L;
    private long lifetime = 0L;
    private long expireTime = 0L;
    private long lastAccessTime = 0L;
    AutoRollbackType type = AutoRollbackType.ALL;
    boolean sessionLess = false;
    private transient String creator = null;
    private int state = 0;
    private String user = null;
    private String clientID = null;
    private String connectionString = null;
    private boolean onephasePrepare = false;
    private transient ConnectionUID connectionUID = null;
    private transient boolean detached = false;
    private transient long detachedTime = 0L;
    private transient int failToState = -1;
    private transient int failFromState = -1;
    private static final JMQXid EMPTY_JMQXID = new JMQXid();

    public TransactionState() {
    }

    public TransactionState(AutoRollbackType autoRollbackType, long l, boolean bl) {
        this.state = 0;
        this.type = autoRollbackType == null ? AutoRollbackType.ALL : autoRollbackType;
        this.createTime = System.currentTimeMillis();
        this.lifetime = l;
        this.expireTime = this.createTime + l;
        this.lastAccessTime = this.createTime;
        this.sessionLess = bl;
    }

    public TransactionState(TransactionState transactionState) {
        this.xid = new JMQXid(transactionState.xid);
        this.state = transactionState.state;
        this.user = transactionState.user;
        this.clientID = transactionState.clientID;
        this.createTime = transactionState.createTime;
        this.lifetime = transactionState.lifetime;
        this.expireTime = transactionState.expireTime;
        this.lastAccessTime = transactionState.lastAccessTime;
        this.connectionString = transactionState.connectionString;
        this.sessionLess = transactionState.sessionLess;
        this.type = transactionState.type == null ? (transactionState.xid == null ? AutoRollbackType.ALL : AutoRollbackType.NOT_PREPARED) : transactionState.type;
        this.connectionUID = transactionState.connectionUID;
        this.detached = transactionState.detached;
        this.detachedTime = transactionState.detachedTime;
        this.onephasePrepare = transactionState.onephasePrepare;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("xid", this.xid == null ? "none" : this.xid.toString());
        hashtable.put("state", names[this.state]);
        hashtable.put("user", this.user == null ? "none" : this.user);
        hashtable.put("connectionString", this.connectionString == null ? "none" : this.connectionString);
        hashtable.put("clientID", this.clientID == null ? "none" : this.clientID);
        hashtable.put("type", this.getType().toString());
        hashtable.put("createTime", String.valueOf(this.createTime));
        hashtable.put("lifetime", new Long(this.lifetime).toString());
        hashtable.put("expireTime", new Long(this.expireTime).toString());
        hashtable.put("lastAccessTime", new Long(this.lastAccessTime).toString());
        hashtable.put("sessionLess", Boolean.valueOf(this.sessionLess).toString());
        hashtable.put("detached", String.valueOf(this.detached));
        hashtable.put("detachedTime", String.valueOf(this.detachedTime));
        if (this.state >= 5) {
            hashtable.put("onephasePrepare", this.onephasePrepare);
        }
        return hashtable;
    }

    public AutoRollbackType getType() {
        return this.type;
    }

    public long getCreationTime() {
        return this.createTime;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public long getExpirationTime() {
        return this.expireTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean isSessionLess() {
        return this.sessionLess;
    }

    public void setState(int n) throws BrokerException {
        if (n < 0 || n > 8) {
            throw new BrokerException("Illegal state " + n + ". Should be between " + 0 + " and " + 8 + " inclusive.");
        }
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    public void setXid(JMQXid jMQXid) {
        this.xid = jMQXid;
    }

    public JMQXid getXid() {
        return this.xid;
    }

    public boolean isXA() {
        return this.xid != null && !this.xid.isNullXid();
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setClientID(String string) {
        this.clientID = string;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setConnectionString(String string) {
        this.connectionString = string;
    }

    public String getConnectionString() {
        return this.connectionString == null ? "none" : this.connectionString;
    }

    public void setConnectionUID(ConnectionUID connectionUID) {
        this.connectionUID = connectionUID;
    }

    public ConnectionUID getConnectionUID() {
        return this.connectionUID;
    }

    public void detachedFromConnection() {
        this.detached = true;
        this.detachedTime = System.currentTimeMillis();
    }

    public boolean isDetachedFromConnection() {
        return this.detached;
    }

    public long getDetachedTime() {
        return this.detachedTime;
    }

    public void setOnephasePrepare(boolean bl) {
        this.onephasePrepare = bl;
    }

    public void setFailToState(int n) {
        this.failToState = n;
    }

    public void setFailFromState(int n) {
        this.failFromState = n;
    }

    public boolean getOnephasePrepare() {
        return this.onephasePrepare;
    }

    public int nextState(int n, Integer n2) throws BrokerException {
        switch (n) {
            case 44: {
                if (!(TransactionState.isFlagSet(0, n2) ? this.state == 0 || this.state == 4 || this.state == 1 : (TransactionState.isFlagSet(0x200000, n2) ? this.state == 1 || this.state == 4 : TransactionState.isFlagSet(0x8000000, n2) && (this.state == 3 || this.state == 1)))) break;
                return 1;
            }
            case 58: {
                if (TransactionState.isFlagSet(0x2000000, n2)) {
                    if (this.state != 1 && this.state != 3) break;
                    return 3;
                }
                if (TransactionState.isFlagSet(0x20000000, n2)) {
                    if (this.state != 1 && this.state != 3 && this.state != 2) break;
                    return 2;
                }
                if (!TransactionState.isFlagSet(0x4000000, n2) && !TransactionState.isFlagSet(0x40000000, n2) || this.state != 1 && this.state != 3 && this.state != 4) break;
                return 4;
            }
            case 56: {
                if (this.state != 4 && this.state != 5) break;
                return 5;
            }
            case 46: {
                if (!(TransactionState.isFlagSet(0x40000000, n2) ? this.state == 4 || this.state == 6 : this.state == 5 || this.state == 6)) break;
                return 6;
            }
            case 48: {
                if (this.state == 4 || this.state == 3) {
                    return 7;
                }
                if (this.state == 5) {
                    return 7;
                }
                if (this.state != 2 && this.state != 7) break;
                return 7;
            }
        }
        if (this.state == 2 && this.failToState != -1) {
            Object[] objectArray = new Object[]{PacketType.getString(n), TransactionState.xaFlagToString(n2), this.xid == null ? "null" : this.xid.toString(), TransactionState.toString(this.failToState), TransactionState.toString(this.failFromState)};
            throw new BrokerException(Globals.getBrokerResources().getString("B4291", objectArray));
        }
        if (this.state == 2) {
            Object[] objectArray = new Object[]{PacketType.getString(n), TransactionState.xaFlagToString(n2), this.xid == null ? "null" : this.xid.toString(), TransactionState.toString(this.failFromState)};
            int n3 = 500;
            if (this.failFromState == 1 && n == 58) {
                n3 = 304;
                throw new BrokerException(Globals.getBrokerResources().getString("B4307", objectArray), n3);
            }
            throw new BrokerException(Globals.getBrokerResources().getString("B4292", objectArray), n3);
        }
        Object[] objectArray = new Object[]{PacketType.getString(n), TransactionState.xaFlagToString(n2), TransactionState.toString(this.state)};
        throw new BrokerException(Globals.getBrokerResources().getString("B4132", objectArray));
    }

    public static int remoteTransactionNextState(TransactionState transactionState, int n) throws BrokerException {
        int n2 = transactionState.getState();
        switch (n) {
            case 6: {
                if (n2 != 5 && n2 != 6) break;
                return 6;
            }
            case 7: {
                if (n2 != 5 && n2 != 7) break;
                return 7;
            }
        }
        throw new BrokerException("Transaction state " + TransactionState.toString(n2) + " can not transit to state " + TransactionState.toString(n));
    }

    public static boolean isFlagSet(int n, Integer n2) {
        if (n2 == null) {
            return n == 0;
        }
        if (n == 0 || n2 == 0) {
            return n == n2;
        }
        return (n2 & n) == n;
    }

    public static String toString(int n) {
        if (n < 0 || n > 7) {
            return "UNKNOWN(" + n + ")";
        }
        return names[n] + "(" + n + ")";
    }

    public static String xaFlagToString(Integer n) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        if (n == null) {
            return "null";
        }
        stringBuffer.append("0x" + Integer.toHexString(n) + ":");
        if (TransactionState.isFlagSet(0, n)) {
            stringBuffer.append("TMNOFLAGS");
            return stringBuffer.toString();
        }
        if (TransactionState.isFlagSet(0x800000, n)) {
            stringBuffer.append("TMENDRSCAN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x20000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMFAIL");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x200000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMJOIN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x40000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMONEPHASE");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x8000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMRESUME");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x1000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSTARTSCAN");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x4000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUCCESS");
            bl = true;
        }
        if (TransactionState.isFlagSet(0x2000000, n)) {
            if (bl) {
                stringBuffer.append("|");
            }
            stringBuffer.append("TMSUSPEND");
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("???");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.xid == null) {
            return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state) + (this.onephasePrepare ? "[onephase=true]" : "");
        }
        return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state) + ":xid=" + this.xid.toString() + (this.onephasePrepare ? "[onephase=true]" : "");
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.connectionUID = null;
        this.creator = null;
        this.detached = false;
        this.detachedTime = 0L;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.xid = JMQXid.read(objectInput);
        if (this.xid.isNullXid()) {
            this.xid = null;
        }
        this.state = objectInput.readInt();
        this.user = (String)objectInput.readObject();
        this.clientID = (String)objectInput.readObject();
        this.connectionString = (String)objectInput.readObject();
        this.connectionUID = null;
        this.onephasePrepare = false;
        try {
            if (objectInput.available() > 0) {
                this.sessionLess = objectInput.readBoolean();
                this.type = AutoRollbackType.getType(objectInput.readInt());
                this.createTime = objectInput.readLong();
                this.lifetime = objectInput.readLong();
                this.lastAccessTime = objectInput.readLong();
                this.expireTime = this.createTime + this.lifetime;
            }
            if (objectInput.available() > 0) {
                this.onephasePrepare = objectInput.readBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.detached = false;
        this.detachedTime = 0L;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.xid == null) {
            EMPTY_JMQXID.write(objectOutput);
        } else {
            this.xid.write(objectOutput);
        }
        objectOutput.writeInt(this.state);
        objectOutput.writeObject(this.user);
        objectOutput.writeObject(this.clientID);
        objectOutput.writeObject(this.connectionString);
        objectOutput.writeBoolean(this.sessionLess);
        objectOutput.writeInt(this.type.intValue());
        objectOutput.writeLong(this.createTime);
        objectOutput.writeLong(this.lifetime);
        objectOutput.writeLong(this.lastAccessTime);
        objectOutput.writeBoolean(this.onephasePrepare);
    }
}

