/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.admin.MessageType;
import java.util.Hashtable;

public class ChangeClusterMasterBrokerHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ChangeClusterMasterBrokerHandler.getDEBUG();

    public ChangeClusterMasterBrokerHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        int n = 200;
        String string = null;
        if (DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": " + hashtable);
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = (String)hashtable.get("JMQClusterOldMasterBroker");
        String string3 = (String)hashtable.get("JMQClusterNewMasterBroker");
        Object v = hashtable.get("JMQJMSRAManagedBroker");
        if (v != null && Boolean.valueOf(v.toString()).booleanValue()) {
            bl2 = true;
        }
        if ((v = hashtable.get("JMQJMSRANotificationOnly")) != null && Boolean.valueOf(v.toString()).booleanValue() && bl2 && Globals.isJMSRAManagedBroker()) {
            bl = true;
        }
        this.logger.log(8, Globals.getBrokerResources().getKString("B1382", MessageType.getString(96) + "[" + "JMQClusterNewMasterBroker" + "=" + string3 + ", " + "JMQClusterOldMasterBroker" + "=" + string2 + "]" + (bl2 ? "JMSRA" : "") + (bl ? "(JMQJMSRANotificationOnly)" : "")));
        if (Globals.getHAEnabled()) {
            n = 412;
            string = this.rb.getKString("B3262", MessageType.getString(96));
            this.logger.log(32, string);
            this.sendReply(n, string, iMQConnection, packet);
            return true;
        }
        if (Globals.useSharedConfigRecord()) {
            n = 412;
            string = this.rb.getKString("B3271", MessageType.getString(96));
            this.logger.log(32, string);
            this.sendReply(n, string, iMQConnection, packet);
            return true;
        }
        try {
            if (!Globals.dynamicChangeMasterBrokerEnabled()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4356"), 405);
            }
            if (string3 == null) {
                throw new IllegalArgumentException("null JMQClusterNewMasterBroker");
            }
            if (!bl2 && Globals.isJMSRAManagedBroker()) {
                throw new IllegalAccessException(Globals.getBrokerResources().getKString("B4354"));
            }
            ClusterManager clusterManager = Globals.getClusterManager();
            BrokerMQAddress brokerMQAddress = (BrokerMQAddress)clusterManager.getMQAddress();
            BrokerMQAddress brokerMQAddress2 = clusterManager.getMasterBroker() == null ? null : (BrokerMQAddress)clusterManager.getMasterBroker().getBrokerURL();
            BrokerMQAddress brokerMQAddress3 = BrokerMQAddress.createAddress(string3);
            BrokerMQAddress brokerMQAddress4 = null;
            if (string2 != null) {
                brokerMQAddress4 = BrokerMQAddress.createAddress(string2);
            }
            if (bl) {
                if (brokerMQAddress2 == null) {
                    string = "IllegalStateException for notification " + MessageType.getString(96) + ": No master broker";
                    this.logger.log(32, string);
                    this.sendReply(500, string, iMQConnection, packet);
                    Broker.getBroker().exit(1, string, BrokerEvent.Type.ERROR);
                    throw new IllegalStateException(string);
                }
                if (brokerMQAddress3.equals(brokerMQAddress) && !brokerMQAddress2.equals(brokerMQAddress)) {
                    string = "IllegalStateException for notification " + MessageType.getString(96) + ": This broker, which has master broker " + brokerMQAddress2 + ", is not the master broker as expected";
                    this.logger.log(32, string);
                    this.sendReply(500, string, iMQConnection, packet);
                    Broker.getBroker().exit(1, string, BrokerEvent.Type.ERROR);
                    return true;
                }
                if (brokerMQAddress4 != null && brokerMQAddress4.equals(brokerMQAddress) && !brokerMQAddress2.equals(brokerMQAddress3)) {
                    string = "IllegalStateException for notification " + MessageType.getString(96) + ": This broker, which is the old master broker " + brokerMQAddress4 + ", does not have " + brokerMQAddress3 + " as the master broker as expected";
                    this.logger.log(32, string);
                    this.sendReply(500, string, iMQConnection, packet);
                    Broker.getBroker().exit(1, string, BrokerEvent.Type.ERROR);
                    return true;
                }
                this.sendReply(200, null, iMQConnection, packet);
                return true;
            }
            if (brokerMQAddress2 == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4333"), 412);
            }
            if (brokerMQAddress3.equals(brokerMQAddress2)) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1379", brokerMQAddress3));
                this.sendReply(200, null, iMQConnection, packet);
                return true;
            }
            if (brokerMQAddress4 == null) {
                brokerMQAddress4 = brokerMQAddress2;
            }
            if (!brokerMQAddress4.equals(brokerMQAddress2)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4337", brokerMQAddress4.toString(), brokerMQAddress2), 412);
            }
            if (!brokerMQAddress.equals(brokerMQAddress2)) {
                if (!Globals.isJMSRAManagedBroker()) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4339", brokerMQAddress2.toString()), 405);
                }
                this.sendReply(200, null, iMQConnection, packet);
                return true;
            }
            Globals.getClusterBroadcast().changeMasterBroker(brokerMQAddress3, brokerMQAddress4);
            this.sendReply(200, null, iMQConnection, packet);
            return true;
        }
        catch (Exception exception) {
            n = 500;
            string = exception.getMessage();
            if (exception instanceof BrokerException) {
                n = ((BrokerException)exception).getStatusCode();
                string = string + "[" + Status.getString(n) + "]";
            }
            this.logger.logStack(32, string, exception);
            this.sendReply(n, string, iMQConnection, packet);
            return true;
        }
    }

    private void sendReply(int n, String string, IMQConnection iMQConnection, Packet packet) {
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        ChangeClusterMasterBrokerHandler.setProperties(packet2, 97, n, string);
        this.parent.sendReply(iMQConnection, packet, packet2);
    }
}

