/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.catalog.types.UDTAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class CreateAliasNode
extends DDLStatementNode {
    public static final int PARAMETER_ARRAY = 0;
    public static final int TABLE_NAME = 1;
    public static final int DYNAMIC_RESULT_SET_COUNT = 2;
    public static final int LANGUAGE = 3;
    public static final int EXTERNAL_NAME = 4;
    public static final int PARAMETER_STYLE = 5;
    public static final int SQL_CONTROL = 6;
    public static final int DETERMINISTIC = 7;
    public static final int NULL_ON_NULL_INPUT = 8;
    public static final int RETURN_TYPE = 9;
    public static final int ROUTINE_SECURITY_DEFINER = 10;
    public static final int ROUTINE_ELEMENT_COUNT = 11;
    private String javaClassName;
    private String methodName;
    private char aliasType;
    private boolean delimitedIdentifier;
    private AliasInfo aliasInfo;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        TableName tableName = (TableName)object;
        this.aliasType = ((Character)object5).charValue();
        this.initAndCheck(tableName);
        switch (this.aliasType) {
            case 'A': {
                this.javaClassName = (String)object2;
                this.aliasInfo = new UDTAliasInfo();
                this.implicitCreateSchema = true;
                break;
            }
            case 'F': 
            case 'P': {
                Integer n;
                int n2;
                this.javaClassName = (String)object2;
                this.methodName = (String)object3;
                this.delimitedIdentifier = (Boolean)object6;
                Object[] objectArray = (Object[])object4;
                Object[] objectArray2 = (Object[])objectArray[0];
                int n3 = ((Vector)objectArray2[0]).size();
                if (this.methodName.indexOf(40) != -1) {
                    this.getDataDictionary().checkVersion(130, "EXTERNAL NAME 'class.method(<signature>)'");
                }
                Object[] objectArray3 = null;
                Object[] objectArray4 = null;
                int[] nArray = null;
                if (n3 > 90) {
                    throw StandardException.newException("54023", (Object)String.valueOf(90), object, (Object)String.valueOf(n3));
                }
                if (n3 != 0) {
                    objectArray3 = new String[n3];
                    ((Vector)objectArray2[0]).copyInto(objectArray3);
                    objectArray4 = new TypeDescriptor[n3];
                    ((Vector)objectArray2[1]).copyInto(objectArray4);
                    nArray = new int[n3];
                    for (int i = 0; i < n3; ++i) {
                        nArray[i] = n2 = ((Integer)((Vector)objectArray2[2]).get(i)).intValue();
                        if (objectArray4[i].isUserDefinedType() || !TypeId.getBuiltInTypeId(objectArray4[i].getJDBCTypeId()).isXMLTypeId()) continue;
                        throw StandardException.newException("42962", objectArray3[i]);
                    }
                    if (n3 > 1) {
                        Object[] objectArray5 = new String[n3];
                        System.arraycopy(objectArray3, 0, objectArray5, 0, n3);
                        Arrays.sort(objectArray5);
                        for (n2 = 1; n2 < objectArray5.length; ++n2) {
                            if (((String)objectArray5[n2]).equals("") || !((String)objectArray5[n2]).equals(objectArray5[n2 - 1])) continue;
                            throw StandardException.newException("42734", objectArray5[n2], (Object)this.getFullName());
                        }
                    }
                }
                n2 = (n = (Integer)objectArray[2]) == null ? 0 : n;
                Short s = (Short)objectArray[6];
                short s2 = s != null ? s : (this.aliasType == 'P' ? (short)0 : 1);
                Boolean bl = (Boolean)objectArray[7];
                boolean bl2 = bl == null ? false : bl;
                Boolean bl3 = (Boolean)objectArray[10];
                boolean bl4 = bl3 == null ? false : bl3;
                Boolean bl5 = (Boolean)objectArray[8];
                boolean bl6 = bl5 == null ? true : bl5;
                TypeDescriptor typeDescriptor = (TypeDescriptor)objectArray[9];
                if (typeDescriptor != null) {
                    DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptor);
                    dataTypeDescriptor = this.bindUserType(dataTypeDescriptor);
                    typeDescriptor = dataTypeDescriptor.getCatalogType();
                }
                this.aliasInfo = new RoutineAliasInfo(this.methodName, n3, (String[])objectArray3, (TypeDescriptor[])objectArray4, nArray, n2, (Short)objectArray[5], s2, bl2, bl4, bl6, typeDescriptor);
                this.implicitCreateSchema = true;
                break;
            }
            case 'S': {
                this.implicitCreateSchema = true;
                TableName tableName2 = (TableName)object2;
                String string = tableName2.getSchemaName() != null ? tableName2.getSchemaName() : this.getSchemaDescriptor().getSchemaName();
                this.aliasInfo = new SynonymAliasInfo(string, tableName2.getTableName());
                break;
            }
        }
    }

    public String statementToString() {
        switch (this.aliasType) {
            case 'A': {
                return "CREATE TYPE";
            }
            case 'P': {
                return "CREATE PROCEDURE";
            }
            case 'S': {
                return "CREATE SYNONYM";
            }
        }
        return "CREATE FUNCTION";
    }

    private boolean anyStringTypeDescriptor() {
        TypeId typeId;
        RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)this.aliasInfo;
        TypeDescriptor typeDescriptor = routineAliasInfo.getReturnType();
        if (typeDescriptor != null && (typeId = TypeId.getBuiltInTypeId(typeDescriptor.getTypeName())) != null && typeId.isStringTypeId()) {
            return true;
        }
        if (routineAliasInfo.getParameterCount() != 0) {
            int n = routineAliasInfo.getParameterCount();
            TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
            for (int i = 0; i < n; ++i) {
                typeId = TypeId.getBuiltInTypeId(typeDescriptorArray[i].getTypeName());
                if (typeId == null || !typeId.isStringTypeId()) continue;
                return true;
            }
        }
        return false;
    }

    public void bindStatement() throws StandardException {
        if (this.aliasType == 'F' || this.aliasType == 'P') {
            ((RoutineAliasInfo)this.aliasInfo).setCollationTypeForAllStringTypes(this.getSchemaDescriptor().getCollationType());
            this.bindParameterTypes((RoutineAliasInfo)this.aliasInfo);
        }
        if (this.aliasType == 'A') {
            TypeId[] typeIdArray = TypeId.getAllBuiltinTypeIds();
            int n = typeIdArray.length;
            boolean bl = this.javaClassName.startsWith("org.apache.derby.");
            if (!bl) {
                for (int i = 0; i < n; ++i) {
                    TypeId typeId = typeIdArray[i];
                    String string = typeId.getCorrespondingJavaTypeName();
                    if (!string.equals(this.javaClassName)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                throw StandardException.newException("42Z10", this.javaClassName);
            }
            return;
        }
        if (this.aliasType != 'S') {
            return;
        }
        if (this.isSessionSchema(this.getSchemaDescriptor().getSchemaName())) {
            throw StandardException.newException("XCL51.S");
        }
        String string = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
        String string2 = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
        if (this.getObjectName().equals(string, string2)) {
            throw StandardException.newException("42916", (Object)this.getFullName(), (Object)(string + "." + string2));
        }
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string, false);
        if (schemaDescriptor != null && this.isSessionSchema(schemaDescriptor)) {
            throw StandardException.newException("XCL51.S");
        }
    }

    private void bindParameterTypes(RoutineAliasInfo routineAliasInfo) throws StandardException {
        TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
        if (typeDescriptorArray == null) {
            return;
        }
        int n = typeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            TypeDescriptor typeDescriptor = typeDescriptorArray[i];
            if (!typeDescriptor.isUserDefinedType()) continue;
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptor);
            dataTypeDescriptor = this.bindUserType(dataTypeDescriptor);
            typeDescriptorArray[i] = dataTypeDescriptor.getCatalogType();
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String string = this.getSchemaDescriptor().getSchemaName();
        return this.getGenericConstantActionFactory().getCreateAliasConstantAction(this.getRelativeName(), string, this.javaClassName, this.aliasInfo, this.aliasType);
    }
}

