/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JArray;
import com.sun.codemodel.internal.JArrayCompRef;
import com.sun.codemodel.internal.JAssignment;
import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JAtom;
import com.sun.codemodel.internal.JCast;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JExpressionImpl;
import com.sun.codemodel.internal.JFieldRef;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JNarrowedClass;
import com.sun.codemodel.internal.JStringLiteral;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;

public abstract class JExpr {
    private static final JExpression __this = new JAtom("this");
    private static final JExpression __super = new JAtom("super");
    private static final JExpression __null = new JAtom("null");
    public static final JExpression TRUE = new JAtom("true");
    public static final JExpression FALSE = new JAtom("false");
    static final String charEscape = "\b\t\n\f\r\"'\\";
    static final String charMacro = "btnfr\"'\\";

    private JExpr() {
    }

    public static JExpression assign(JAssignmentTarget jAssignmentTarget, JExpression jExpression) {
        return new JAssignment(jAssignmentTarget, jExpression);
    }

    public static JExpression assignPlus(JAssignmentTarget jAssignmentTarget, JExpression jExpression) {
        return new JAssignment(jAssignmentTarget, jExpression, "+");
    }

    public static JInvocation _new(JClass jClass) {
        return new JInvocation(jClass);
    }

    public static JInvocation _new(JType jType) {
        return new JInvocation(jType);
    }

    public static JInvocation invoke(String string) {
        return new JInvocation((JExpression)null, string);
    }

    public static JInvocation invoke(JMethod jMethod) {
        return new JInvocation((JExpression)null, jMethod);
    }

    public static JInvocation invoke(JExpression jExpression, JMethod jMethod) {
        return new JInvocation(jExpression, jMethod);
    }

    public static JInvocation invoke(JExpression jExpression, String string) {
        return new JInvocation(jExpression, string);
    }

    public static JFieldRef ref(String string) {
        return new JFieldRef((JExpression)null, string);
    }

    public static JFieldRef ref(JExpression jExpression, JVar jVar) {
        return new JFieldRef(jExpression, jVar);
    }

    public static JFieldRef ref(JExpression jExpression, String string) {
        return new JFieldRef(jExpression, string);
    }

    public static JFieldRef refthis(String string) {
        return new JFieldRef(null, string, true);
    }

    public static JExpression dotclass(final JClass jClass) {
        return new JExpressionImpl(){

            public void generate(JFormatter jFormatter) {
                JClass jClass2 = jClass instanceof JNarrowedClass ? ((JNarrowedClass)jClass).basis : jClass;
                jFormatter.g(jClass2).p(".class");
            }
        };
    }

    public static JArrayCompRef component(JExpression jExpression, JExpression jExpression2) {
        return new JArrayCompRef(jExpression, jExpression2);
    }

    public static JCast cast(JType jType, JExpression jExpression) {
        return new JCast(jType, jExpression);
    }

    public static JArray newArray(JType jType) {
        return JExpr.newArray(jType, null);
    }

    public static JArray newArray(JType jType, JExpression jExpression) {
        return new JArray(jType.erasure(), jExpression);
    }

    public static JArray newArray(JType jType, int n) {
        return JExpr.newArray(jType, JExpr.lit(n));
    }

    public static JExpression _this() {
        return __this;
    }

    public static JExpression _super() {
        return __super;
    }

    public static JExpression _null() {
        return __null;
    }

    public static JExpression lit(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static JExpression lit(int n) {
        return new JAtom(Integer.toString(n));
    }

    public static JExpression lit(long l) {
        return new JAtom(Long.toString(l) + "L");
    }

    public static JExpression lit(float f) {
        return new JAtom(Float.toString(f) + "F");
    }

    public static JExpression lit(double d) {
        return new JAtom(Double.toString(d) + "D");
    }

    public static String quotify(char c, String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append(c);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            int n2 = charEscape.indexOf(c2);
            if (n2 >= 0) {
                if (c == '\"' && c2 == '\'' || c == '\'' && c2 == '\"') {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(charMacro.charAt(n2));
                continue;
            }
            if (c2 < ' ' || '~' < c2) {
                stringBuilder.append("\\u");
                String string2 = Integer.toHexString(c2 & 0xFFFF);
                for (int j = string2.length(); j < 4; ++j) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    public static JExpression lit(char c) {
        return new JAtom(JExpr.quotify('\'', "" + c));
    }

    public static JExpression lit(String string) {
        return new JStringLiteral(string);
    }

    public static JExpression direct(final String string) {
        return new JExpressionImpl(){

            public void generate(JFormatter jFormatter) {
                jFormatter.p('(').p(string).p(')');
            }
        };
    }
}

