/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.internal.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelWorldClassLoader
extends ClassLoader {
    private final String prefix;

    public ParallelWorldClassLoader(ClassLoader classLoader, String string) {
        super(classLoader);
        this.prefix = string;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + this.prefix.length() + 6);
        stringBuffer.append(this.prefix).append(string.replace('.', '/')).append(".class");
        InputStream inputStream = this.getParent().getResourceAsStream(stringBuffer.toString());
        if (inputStream == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            String string2;
            Package package_;
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1 && (package_ = this.getPackage(string2 = string.substring(0, n2))) == null) {
                this.definePackage(string2, null, null, null, null, null, null, null);
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string, iOException);
        }
    }

    @Override
    protected URL findResource(String string) {
        return this.getParent().getResource(this.prefix + string);
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        return this.getParent().getResources(this.prefix + string);
    }

    public static URL toJarUrl(URL uRL) throws ClassNotFoundException, MalformedURLException {
        String string = uRL.toExternalForm();
        if (!string.startsWith("jar:")) {
            throw new ClassNotFoundException("Loaded outside a jar " + string);
        }
        string = string.substring(4);
        string = string.substring(0, string.lastIndexOf(33));
        return new URL(string);
    }
}

