/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.declaration;

import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.TypeMirror;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.declaration.Constants;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationProxyMaker {
    private final AptEnv env;
    private final Attribute.Compound attrs;
    private final Class<? extends Annotation> annoType;

    private AnnotationProxyMaker(AptEnv aptEnv, Attribute.Compound compound, Class<? extends Annotation> clazz) {
        this.env = aptEnv;
        this.attrs = compound;
        this.annoType = clazz;
    }

    public static <A extends Annotation> A generateAnnotation(AptEnv aptEnv, Attribute.Compound compound, Class<A> clazz) {
        AnnotationProxyMaker annotationProxyMaker = new AnnotationProxyMaker(aptEnv, compound, clazz);
        return (A)((Annotation)clazz.cast(annotationProxyMaker.generateAnnotation()));
    }

    private Annotation generateAnnotation() {
        return AnnotationParser.annotationForMap(this.annoType, this.getAllReflectedValues());
    }

    private Map<String, Object> getAllReflectedValues() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<Symbol.MethodSymbol, Attribute> entry : this.getAllValues().entrySet()) {
            Symbol.MethodSymbol methodSymbol = entry.getKey();
            Object object = this.generateValue(methodSymbol, entry.getValue());
            if (object == null) continue;
            linkedHashMap.put(methodSymbol.name.toString(), object);
        }
        return linkedHashMap;
    }

    private Map<Symbol.MethodSymbol, Attribute> getAllValues() {
        LinkedHashMap<Symbol.MethodSymbol, Attribute> linkedHashMap = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.attrs.type.tsym;
        Object object = classSymbol.members().elems;
        while (object != null) {
            if (((Scope.Entry)object).sym.kind == 16) {
                Symbol.MethodSymbol object2 = (Symbol.MethodSymbol)((Scope.Entry)object).sym;
                Attribute attribute = object2.defaultValue;
                if (attribute != null) {
                    linkedHashMap.put(object2, attribute);
                }
            }
            object = ((Scope.Entry)object).sibling;
        }
        for (Pair pair : this.attrs.values) {
            linkedHashMap.put((Symbol.MethodSymbol)pair.fst, (Attribute)pair.snd);
        }
        return linkedHashMap;
    }

    private Object generateValue(Symbol.MethodSymbol methodSymbol, Attribute attribute) {
        ValueVisitor valueVisitor = new ValueVisitor(methodSymbol);
        return valueVisitor.getValue(attribute);
    }

    private static class MirroredTypeExceptionProxy
    extends ExceptionProxy {
        private MirroredTypeException ex;

        MirroredTypeExceptionProxy(TypeMirror typeMirror) {
            this.ex = new MirroredTypeException(typeMirror);
        }

        public String toString() {
            return this.ex.getQualifiedName();
        }

        public int hashCode() {
            TypeMirror typeMirror = this.ex.getTypeMirror();
            return typeMirror != null ? typeMirror.hashCode() : this.ex.getQualifiedName().hashCode();
        }

        public boolean equals(Object object) {
            TypeMirror typeMirror = this.ex.getTypeMirror();
            return typeMirror != null && object instanceof MirroredTypeExceptionProxy && ((Object)typeMirror).equals(((MirroredTypeExceptionProxy)object).ex.getTypeMirror());
        }

        protected RuntimeException generateException() {
            return (RuntimeException)this.ex.fillInStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MirroredTypesExceptionProxy
    extends ExceptionProxy {
        private MirroredTypesException ex;

        MirroredTypesExceptionProxy(Collection<TypeMirror> collection) {
            this.ex = new MirroredTypesException(collection);
        }

        public String toString() {
            return this.ex.getQualifiedNames().toString();
        }

        public int hashCode() {
            Collection<TypeMirror> collection = this.ex.getTypeMirrors();
            return collection != null ? ((Object)collection).hashCode() : ((Object)this.ex.getQualifiedNames()).hashCode();
        }

        public boolean equals(Object object) {
            Collection<TypeMirror> collection = this.ex.getTypeMirrors();
            return collection != null && object instanceof MirroredTypesExceptionProxy && ((Object)collection).equals(((MirroredTypesExceptionProxy)object).ex.getTypeMirrors());
        }

        @Override
        protected RuntimeException generateException() {
            return (RuntimeException)this.ex.fillInStackTrace();
        }
    }

    private class ValueVisitor
    implements Attribute.Visitor {
        private Symbol.MethodSymbol meth;
        private Class<?> runtimeType;
        private Object value;

        ValueVisitor(Symbol.MethodSymbol methodSymbol) {
            this.meth = methodSymbol;
        }

        Object getValue(Attribute attribute) {
            Method method;
            try {
                method = AnnotationProxyMaker.this.annoType.getMethod(this.meth.name.toString(), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            this.runtimeType = method.getReturnType();
            attribute.accept(this);
            if (!(this.value instanceof ExceptionProxy) && !AnnotationType.invocationHandlerReturnType(this.runtimeType).isInstance(this.value)) {
                this.typeMismatch(method, attribute);
            }
            return this.value;
        }

        public void visitConstant(Attribute.Constant constant) {
            this.value = Constants.decodeConstant(constant.value, constant.type);
        }

        public void visitClass(Attribute.Class clazz) {
            this.value = new MirroredTypeExceptionProxy(((AnnotationProxyMaker)AnnotationProxyMaker.this).env.typeMaker.getType(clazz.type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitArray(Attribute.Array array) {
            Type type = ((AnnotationProxyMaker)AnnotationProxyMaker.this).env.jctypes.elemtype(array.type);
            if (type.tsym == ((AnnotationProxyMaker)AnnotationProxyMaker.this).env.symtab.classType.tsym) {
                ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
                for (int i = 0; i < array.values.length; ++i) {
                    Type type2 = ((Attribute.Class)array.values[i]).type;
                    arrayList.add(((AnnotationProxyMaker)AnnotationProxyMaker.this).env.typeMaker.getType(type2));
                }
                this.value = new MirroredTypesExceptionProxy(arrayList);
            } else {
                int n = array.values.length;
                Class<?> clazz = this.runtimeType;
                this.runtimeType = this.runtimeType.getComponentType();
                try {
                    Object object = Array.newInstance(this.runtimeType, n);
                    for (int i = 0; i < n; ++i) {
                        array.values[i].accept(this);
                        if (this.value == null || this.value instanceof ExceptionProxy) {
                            return;
                        }
                        try {
                            Array.set(object, i, this.value);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.value = null;
                            this.runtimeType = clazz;
                            return;
                        }
                    }
                    this.value = object;
                }
                finally {
                    this.runtimeType = clazz;
                }
            }
        }

        public void visitEnum(Attribute.Enum enum_) {
            if (this.runtimeType.isEnum()) {
                String string = enum_.value.toString();
                try {
                    this.value = Enum.valueOf(this.runtimeType, string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.value = new EnumConstantNotPresentExceptionProxy(this.runtimeType, string);
                }
            } else {
                this.value = null;
            }
        }

        public void visitCompound(Attribute.Compound compound) {
            try {
                Class<Annotation> clazz = this.runtimeType.asSubclass(Annotation.class);
                this.value = AnnotationProxyMaker.generateAnnotation(AnnotationProxyMaker.this.env, compound, clazz);
            }
            catch (ClassCastException classCastException) {
                this.value = null;
            }
        }

        public void visitError(Attribute.Error error) {
            this.value = null;
        }

        private void typeMismatch(final Method method, final Attribute attribute) {
            this.value = new ExceptionProxy(){

                public String toString() {
                    return "<error>";
                }

                protected RuntimeException generateException() {
                    return new AnnotationTypeMismatchException(method, attribute.type.toString());
                }
            };
        }
    }
}

