/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.attach;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import ibm.tools.attach.J9AttachProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualMachine {
    protected AttachProvider provider;
    private static List<com.ibm.tools.attach.spi.AttachProvider> providers = com.ibm.tools.attach.spi.AttachProvider.providers();
    private static com.ibm.tools.attach.spi.AttachProvider ibm_provider = providers.get(0);
    protected static com.ibm.tools.attach.VirtualMachine ibm_vm;
    protected String id;
    private volatile int hash;

    protected VirtualMachine(AttachProvider attachProvider, String string) {
        if (attachProvider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.provider = attachProvider;
        ibm_provider = ((J9AttachProvider)attachProvider).getIBMProvider();
        this.id = string;
    }

    public VirtualMachine() {
    }

    public static List<VirtualMachineDescriptor> list() {
        ArrayList<VirtualMachineDescriptor> arrayList = new ArrayList<VirtualMachineDescriptor>();
        List list = ibm_provider.providers();
        for (com.ibm.tools.attach.spi.AttachProvider attachProvider : list) {
            VirtualMachineDescriptor virtualMachineDescriptor = new VirtualMachineDescriptor(new J9AttachProvider(attachProvider), attachProvider.name());
            arrayList.addAll(virtualMachineDescriptor.provider().listVirtualMachines());
        }
        return arrayList;
    }

    public static VirtualMachine attach(String string) throws AttachNotSupportedException, IOException {
        if (string == null) {
            throw new NullPointerException("id cannot be null");
        }
        List list = ibm_provider.providers();
        if (list.size() == 0) {
            System.out.println(" no providers installed");
            throw new AttachNotSupportedException("no providers installed");
        }
        Object var2_2 = null;
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            com.ibm.tools.attach.spi.AttachProvider attachProvider = (com.ibm.tools.attach.spi.AttachProvider)iterator.next();
            return new J9AttachProvider(attachProvider).attachVirtualMachine(string);
        }
        return null;
    }

    public static VirtualMachine attach(VirtualMachineDescriptor virtualMachineDescriptor) throws AttachNotSupportedException, IOException {
        try {
            ibm_vm = ibm_provider.attachVirtualMachine(virtualMachineDescriptor.id());
        }
        catch (com.ibm.tools.attach.AttachNotSupportedException attachNotSupportedException) {
            attachNotSupportedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return virtualMachineDescriptor.provider().attachVirtualMachine(virtualMachineDescriptor);
    }

    public abstract void detach() throws IOException;

    public final AttachProvider provider() {
        return this.provider;
    }

    public final String id() {
        return this.id;
    }

    public abstract void loadAgentLibrary(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentLibrary(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentLibrary(string, null);
    }

    public abstract void loadAgentPath(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentPath(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentPath(string, null);
    }

    public abstract void loadAgent(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgent(String string) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgent(string, null);
    }

    public abstract Properties getSystemProperties() throws IOException;

    public abstract Properties getAgentProperties() throws IOException;

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.provider.hashCode() * 127 + this.id.hashCode();
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine virtualMachine = (VirtualMachine)object;
        if (virtualMachine.provider() != this.provider()) {
            return false;
        }
        return virtualMachine.id().equals(this.id());
    }

    public String toString() {
        return this.provider.toString() + ": " + this.id;
    }
}

