/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.apt;

import com.sun.tools.internal.jxc.apt.Messages;
import com.sun.tools.internal.xjc.BadCommandLineException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Options {
    public String classpath = System.getenv("CLASSPATH");
    public File targetDir = null;
    public File episodeFile = null;
    public final List<String> arguments = new ArrayList<String>();

    public void parseArguments(String[] stringArray) throws BadCommandLineException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '-') {
                int n = this.parseArgument(stringArray, i);
                if (n == 0) {
                    throw new BadCommandLineException(Messages.UNRECOGNIZED_PARAMETER.format(stringArray[i]));
                }
                i += n;
                continue;
            }
            this.arguments.add(stringArray[i]);
        }
    }

    private int parseArgument(String[] stringArray, int n) throws BadCommandLineException {
        if (stringArray[n].equals("-d")) {
            if (n == stringArray.length - 1) {
                throw new BadCommandLineException(Messages.OPERAND_MISSING.format(stringArray[n]));
            }
            this.targetDir = new File(stringArray[++n]);
            if (!this.targetDir.exists()) {
                throw new BadCommandLineException(Messages.NON_EXISTENT_FILE.format(this.targetDir));
            }
            return 1;
        }
        if (stringArray[n].equals("-episode")) {
            if (n == stringArray.length - 1) {
                throw new BadCommandLineException(Messages.OPERAND_MISSING.format(stringArray[n]));
            }
            this.episodeFile = new File(stringArray[++n]);
            return 1;
        }
        if (stringArray[n].equals("-cp") || stringArray[n].equals("-classpath")) {
            if (n == stringArray.length - 1) {
                throw new BadCommandLineException(Messages.OPERAND_MISSING.format(stringArray[n]));
            }
            this.classpath = stringArray[++n];
            return 1;
        }
        return 0;
    }
}

