/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.model.nav;

import com.sun.istack.internal.tools.APTTypeVisitor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.Declarations;
import com.sun.mirror.util.SourcePosition;
import com.sun.mirror.util.TypeVisitor;
import com.sun.mirror.util.Types;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.bind.v2.runtime.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTNavigator
implements Navigator<TypeMirror, TypeDeclaration, FieldDeclaration, MethodDeclaration> {
    private final AnnotationProcessorEnvironment env;
    private final PrimitiveType primitiveByte;
    private static final Map<Class, PrimitiveType.Kind> primitives = new HashMap<Class, PrimitiveType.Kind>();
    private static final TypeMirror DUMMY;
    private final APTTypeVisitor<TypeMirror, TypeDeclaration> baseClassFinder = new APTTypeVisitor<TypeMirror, TypeDeclaration>(){

        @Override
        public TypeMirror onClassType(ClassType classType, TypeDeclaration typeDeclaration) {
            TypeMirror typeMirror = this.onDeclaredType(classType, typeDeclaration);
            if (typeMirror != null) {
                return typeMirror;
            }
            if (classType.getSuperclass() != null && (typeMirror = this.onClassType(classType.getSuperclass(), typeDeclaration)) != null) {
                return typeMirror;
            }
            return null;
        }

        @Override
        protected TypeMirror onPrimitiveType(PrimitiveType primitiveType, TypeDeclaration typeDeclaration) {
            return primitiveType;
        }

        @Override
        protected TypeMirror onVoidType(VoidType voidType, TypeDeclaration typeDeclaration) {
            return voidType;
        }

        @Override
        public TypeMirror onInterfaceType(InterfaceType interfaceType, TypeDeclaration typeDeclaration) {
            return this.onDeclaredType(interfaceType, typeDeclaration);
        }

        private TypeMirror onDeclaredType(DeclaredType declaredType, TypeDeclaration typeDeclaration) {
            if (declaredType.getDeclaration().equals(typeDeclaration)) {
                return declaredType;
            }
            for (InterfaceType interfaceType : declaredType.getSuperinterfaces()) {
                TypeMirror typeMirror = this.onInterfaceType(interfaceType, typeDeclaration);
                if (typeMirror == null) continue;
                return typeMirror;
            }
            return null;
        }

        @Override
        public TypeMirror onTypeVariable(TypeVariable typeVariable, TypeDeclaration typeDeclaration) {
            for (ReferenceType referenceType : typeVariable.getDeclaration().getBounds()) {
                TypeMirror typeMirror = (TypeMirror)this.apply(referenceType, typeDeclaration);
                if (typeMirror == null) continue;
                return typeMirror;
            }
            return null;
        }

        @Override
        public TypeMirror onArrayType(ArrayType arrayType, TypeDeclaration typeDeclaration) {
            return null;
        }

        @Override
        public TypeMirror onWildcard(WildcardType wildcardType, TypeDeclaration typeDeclaration) {
            for (ReferenceType referenceType : wildcardType.getLowerBounds()) {
                TypeMirror typeMirror = (TypeMirror)this.apply(referenceType, typeDeclaration);
                if (typeMirror == null) continue;
                return typeMirror;
            }
            return null;
        }
    };
    private static final Comparator<Declaration> SOURCE_POS_COMPARATOR;

    public APTNavigator(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this.env = annotationProcessorEnvironment;
        this.primitiveByte = annotationProcessorEnvironment.getTypeUtils().getPrimitiveType(PrimitiveType.Kind.BYTE);
    }

    public TypeDeclaration getSuperClass(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof ClassDeclaration) {
            ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
            ClassType classType = classDeclaration.getSuperclass();
            if (classType != null) {
                return classType.getDeclaration();
            }
            return null;
        }
        return this.env.getTypeDeclaration(Object.class.getName());
    }

    public TypeMirror getBaseClass(TypeMirror typeMirror, TypeDeclaration typeDeclaration) {
        return this.baseClassFinder.apply(typeMirror, typeDeclaration);
    }

    public String getClassName(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getQualifiedName();
    }

    public String getTypeName(TypeMirror typeMirror) {
        return ((Object)typeMirror).toString();
    }

    public String getClassShortName(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getSimpleName();
    }

    public Collection<FieldDeclaration> getDeclaredFields(TypeDeclaration typeDeclaration) {
        ArrayList<FieldDeclaration> arrayList = new ArrayList<FieldDeclaration>(typeDeclaration.getFields());
        return this.sort(arrayList);
    }

    public FieldDeclaration getDeclaredField(TypeDeclaration typeDeclaration, String string) {
        for (FieldDeclaration fieldDeclaration : typeDeclaration.getFields()) {
            if (!fieldDeclaration.getSimpleName().equals(string)) continue;
            return fieldDeclaration;
        }
        return null;
    }

    public Collection<MethodDeclaration> getDeclaredMethods(TypeDeclaration typeDeclaration) {
        ArrayList<? extends MethodDeclaration> arrayList = new ArrayList<MethodDeclaration>(typeDeclaration.getMethods());
        return this.sort(arrayList);
    }

    private <A extends Declaration> List<A> sort(List<A> list) {
        if (list.isEmpty()) {
            return list;
        }
        SourcePosition sourcePosition = ((Declaration)list.get(0)).getPosition();
        if (sourcePosition != null) {
            Collections.sort(list, SOURCE_POS_COMPARATOR);
        } else {
            Collections.reverse(list);
        }
        return list;
    }

    public ClassDeclaration getDeclaringClassForField(FieldDeclaration fieldDeclaration) {
        return (ClassDeclaration)fieldDeclaration.getDeclaringType();
    }

    public ClassDeclaration getDeclaringClassForMethod(MethodDeclaration methodDeclaration) {
        return (ClassDeclaration)methodDeclaration.getDeclaringType();
    }

    public TypeMirror getFieldType(FieldDeclaration fieldDeclaration) {
        return fieldDeclaration.getType();
    }

    public String getFieldName(FieldDeclaration fieldDeclaration) {
        return fieldDeclaration.getSimpleName();
    }

    public String getMethodName(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getSimpleName();
    }

    public TypeMirror getReturnType(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getReturnType();
    }

    public TypeMirror[] getMethodParameters(MethodDeclaration methodDeclaration) {
        Collection<ParameterDeclaration> collection = methodDeclaration.getParameters();
        TypeMirror[] typeMirrorArray = new TypeMirror[collection.size()];
        int n = 0;
        for (ParameterDeclaration parameterDeclaration : collection) {
            typeMirrorArray[n++] = parameterDeclaration.getType();
        }
        return typeMirrorArray;
    }

    public boolean isStaticMethod(MethodDeclaration methodDeclaration) {
        return this.hasModifier(methodDeclaration, Modifier.STATIC);
    }

    private boolean hasModifier(Declaration declaration, Modifier modifier) {
        return declaration.getModifiers().contains((Object)modifier);
    }

    public boolean isSubClassOf(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (typeMirror2 == DUMMY) {
            return false;
        }
        return this.env.getTypeUtils().isSubtype(typeMirror, typeMirror2);
    }

    private String getSourceClassName(Class clazz) {
        Class<?> clazz2 = clazz.getDeclaringClass();
        if (clazz2 == null) {
            return clazz.getName();
        }
        String string = clazz.getName().substring(clazz2.getName().length() + 1);
        return this.getSourceClassName(clazz2) + '.' + string;
    }

    public TypeMirror ref(Class clazz) {
        if (clazz.isArray()) {
            return this.env.getTypeUtils().getArrayType(this.ref(clazz.getComponentType()));
        }
        if (clazz.isPrimitive()) {
            return this.getPrimitive(clazz);
        }
        TypeDeclaration typeDeclaration = this.env.getTypeDeclaration(this.getSourceClassName(clazz));
        if (typeDeclaration == null) {
            return DUMMY;
        }
        return this.env.getTypeUtils().getDeclaredType(typeDeclaration, new TypeMirror[0]);
    }

    public TypeMirror use(TypeDeclaration typeDeclaration) {
        assert (typeDeclaration != null);
        return this.env.getTypeUtils().getDeclaredType(typeDeclaration, new TypeMirror[0]);
    }

    public TypeDeclaration asDecl(TypeMirror typeMirror) {
        typeMirror = this.env.getTypeUtils().getErasure(typeMirror);
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return declaredType.getDeclaration();
        }
        return null;
    }

    public TypeDeclaration asDecl(Class clazz) {
        return this.env.getTypeDeclaration(this.getSourceClassName(clazz));
    }

    public <T> TypeMirror erasure(TypeMirror typeMirror) {
        DeclaredType declaredType;
        Types types = this.env.getTypeUtils();
        typeMirror = types.getErasure(typeMirror);
        if (typeMirror instanceof DeclaredType && !(declaredType = (DeclaredType)typeMirror).getActualTypeArguments().isEmpty()) {
            return types.getDeclaredType(declaredType.getDeclaration(), new TypeMirror[0]);
        }
        return typeMirror;
    }

    public boolean isAbstract(TypeDeclaration typeDeclaration) {
        return this.hasModifier(typeDeclaration, Modifier.ABSTRACT);
    }

    public boolean isFinal(TypeDeclaration typeDeclaration) {
        return this.hasModifier(typeDeclaration, Modifier.FINAL);
    }

    public FieldDeclaration[] getEnumConstants(TypeDeclaration typeDeclaration) {
        EnumDeclaration enumDeclaration = (EnumDeclaration)typeDeclaration;
        Collection<EnumConstantDeclaration> collection = enumDeclaration.getEnumConstants();
        return collection.toArray(new EnumConstantDeclaration[collection.size()]);
    }

    public TypeMirror getVoidType() {
        return this.env.getTypeUtils().getVoidType();
    }

    public String getPackageName(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getPackage().getQualifiedName();
    }

    public TypeDeclaration findClass(String string, TypeDeclaration typeDeclaration) {
        return this.env.getTypeDeclaration(string);
    }

    public boolean isBridgeMethod(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getModifiers().contains((Object)Modifier.VOLATILE);
    }

    public boolean isOverriding(MethodDeclaration methodDeclaration, TypeDeclaration typeDeclaration) {
        ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
        Declarations declarations = this.env.getDeclarationUtils();
        while (true) {
            for (MethodDeclaration methodDeclaration2 : classDeclaration.getMethods()) {
                if (!declarations.overrides(methodDeclaration, methodDeclaration2)) continue;
                return true;
            }
            if (classDeclaration.getSuperclass() == null) {
                return false;
            }
            classDeclaration = classDeclaration.getSuperclass().getDeclaration();
        }
    }

    public boolean isInterface(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof InterfaceDeclaration;
    }

    public boolean isTransient(FieldDeclaration fieldDeclaration) {
        return fieldDeclaration.getModifiers().contains((Object)Modifier.TRANSIENT);
    }

    public boolean isInnerClass(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getDeclaringType() != null && !typeDeclaration.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isArray(TypeMirror typeMirror) {
        return typeMirror instanceof ArrayType;
    }

    public boolean isArrayButNotByteArray(TypeMirror typeMirror) {
        if (!this.isArray(typeMirror)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)typeMirror;
        TypeMirror typeMirror2 = arrayType.getComponentType();
        return !((Object)typeMirror2).equals(this.primitiveByte);
    }

    public TypeMirror getComponentType(TypeMirror typeMirror) {
        if (typeMirror instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return arrayType.getComponentType();
        }
        throw new IllegalArgumentException();
    }

    public TypeMirror getTypeArgument(TypeMirror typeMirror, int n) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeMirror[] typeMirrorArray = declaredType.getActualTypeArguments().toArray(new TypeMirror[0]);
            return typeMirrorArray[n];
        }
        throw new IllegalArgumentException();
    }

    public boolean isParameterizedType(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return !declaredType.getActualTypeArguments().isEmpty();
        }
        return false;
    }

    public boolean isPrimitive(TypeMirror typeMirror) {
        return typeMirror instanceof PrimitiveType;
    }

    public TypeMirror getPrimitive(Class clazz) {
        assert (clazz.isPrimitive());
        if (clazz == Void.TYPE) {
            return this.getVoidType();
        }
        return this.env.getTypeUtils().getPrimitiveType(primitives.get(clazz));
    }

    public Location getClassLocation(TypeDeclaration typeDeclaration) {
        return this.getLocation(typeDeclaration.getQualifiedName(), typeDeclaration.getPosition());
    }

    public Location getFieldLocation(FieldDeclaration fieldDeclaration) {
        return this.getLocation(fieldDeclaration);
    }

    public Location getMethodLocation(MethodDeclaration methodDeclaration) {
        return this.getLocation(methodDeclaration);
    }

    public boolean hasDefaultConstructor(TypeDeclaration typeDeclaration) {
        if (!(typeDeclaration instanceof ClassDeclaration)) {
            return false;
        }
        ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
        for (ConstructorDeclaration constructorDeclaration : classDeclaration.getConstructors()) {
            if (!constructorDeclaration.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isStaticField(FieldDeclaration fieldDeclaration) {
        return this.hasModifier(fieldDeclaration, Modifier.STATIC);
    }

    public boolean isPublicMethod(MethodDeclaration methodDeclaration) {
        return this.hasModifier(methodDeclaration, Modifier.PUBLIC);
    }

    public boolean isPublicField(FieldDeclaration fieldDeclaration) {
        return this.hasModifier(fieldDeclaration, Modifier.PUBLIC);
    }

    public boolean isEnum(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof EnumDeclaration;
    }

    private Location getLocation(MemberDeclaration memberDeclaration) {
        return this.getLocation(memberDeclaration.getDeclaringType().getQualifiedName() + '.' + memberDeclaration.getSimpleName(), memberDeclaration.getPosition());
    }

    private Location getLocation(final String string, final SourcePosition sourcePosition) {
        return new Location(){

            public String toString() {
                if (sourcePosition == null) {
                    return string + " (Unknown Source)";
                }
                return string + '(' + sourcePosition.file().getName() + ':' + sourcePosition.line() + ')';
            }
        };
    }

    static {
        primitives.put(Integer.TYPE, PrimitiveType.Kind.INT);
        primitives.put(Byte.TYPE, PrimitiveType.Kind.BYTE);
        primitives.put(Float.TYPE, PrimitiveType.Kind.FLOAT);
        primitives.put(Boolean.TYPE, PrimitiveType.Kind.BOOLEAN);
        primitives.put(Short.TYPE, PrimitiveType.Kind.SHORT);
        primitives.put(Long.TYPE, PrimitiveType.Kind.LONG);
        primitives.put(Double.TYPE, PrimitiveType.Kind.DOUBLE);
        primitives.put(Character.TYPE, PrimitiveType.Kind.CHAR);
        DUMMY = new TypeMirror(){

            public void accept(TypeVisitor typeVisitor) {
                throw new IllegalStateException();
            }
        };
        SOURCE_POS_COMPARATOR = new Comparator<Declaration>(){

            @Override
            public int compare(Declaration declaration, Declaration declaration2) {
                if (declaration == declaration2) {
                    return 0;
                }
                SourcePosition sourcePosition = declaration.getPosition();
                SourcePosition sourcePosition2 = declaration2.getPosition();
                if (sourcePosition == null) {
                    return sourcePosition2 == null ? 0 : 1;
                }
                if (sourcePosition2 == null) {
                    return -1;
                }
                int n = sourcePosition.file().compareTo(sourcePosition2.file());
                if (n == 0) {
                    long l = (long)sourcePosition.line() - (long)sourcePosition2.line();
                    if (l == 0L) {
                        l = Long.signum((long)sourcePosition.column() - (long)sourcePosition2.column());
                        if (l != 0L) {
                            return (int)l;
                        }
                        return Long.signum((long)System.identityHashCode(declaration) - (long)System.identityHashCode(declaration2));
                    }
                    return l < 0L ? -1 : 1;
                }
                return n;
            }
        };
    }
}

