/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JFieldRef;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.tools.internal.ws.processor.generator.GeneratorBase;
import com.sun.tools.internal.ws.processor.generator.GeneratorException;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebFault;

public class CustomExceptionGenerator
extends GeneratorBase {
    private Map<String, JClass> faults = new HashMap<String, JClass>();

    public static void generate(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        CustomExceptionGenerator customExceptionGenerator = new CustomExceptionGenerator(model, wsimportOptions, errorReceiver);
        customExceptionGenerator.doGeneration();
    }

    private CustomExceptionGenerator(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        super(model, wsimportOptions, errorReceiver);
    }

    public GeneratorBase getGenerator(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        return new CustomExceptionGenerator(model, wsimportOptions, errorReceiver);
    }

    public void visit(Fault fault) throws Exception {
        if (this.isRegistered(fault)) {
            return;
        }
        this.registerFault(fault);
    }

    private boolean isRegistered(Fault fault) {
        if (this.faults.keySet().contains(fault.getJavaException().getName())) {
            fault.setExceptionClass(this.faults.get(fault.getJavaException().getName()));
            return true;
        }
        return false;
    }

    private void registerFault(Fault fault) {
        try {
            this.write(fault);
            this.faults.put(fault.getJavaException().getName(), fault.getExceptionClass());
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            throw new GeneratorException("generator.nestedGeneratorError", jClassAlreadyExistsException);
        }
    }

    private void write(Fault fault) throws JClassAlreadyExistsException {
        String string = Names.customExceptionClassName(fault);
        JDefinedClass jDefinedClass = this.cm._class(string, ClassType.CLASS);
        jDefinedClass._extends(Exception.class);
        JAnnotationUse jAnnotationUse = jDefinedClass.annotate(WebFault.class);
        jAnnotationUse.param("name", fault.getBlock().getName().getLocalPart());
        jAnnotationUse.param("targetNamespace", fault.getBlock().getName().getNamespaceURI());
        JType jType = fault.getBlock().getType().getJavaType().getType().getType();
        JFieldVar jFieldVar = jDefinedClass.field(4, jType, "faultInfo");
        fault.getBlock().getType().getJavaType().getType().annotate(jFieldVar);
        jFieldVar.javadoc().add("Java type that goes as soapenv:Fault detail element.");
        JFieldRef jFieldRef = JExpr.ref(JExpr._this(), jFieldVar);
        JMethod jMethod = jDefinedClass.constructor(1);
        JVar jVar = jMethod.param(String.class, "message");
        JVar jVar2 = jMethod.param(jType, "faultInfo");
        jMethod.javadoc().addParam(jVar);
        jMethod.javadoc().addParam(jVar2);
        JBlock jBlock = jMethod.body();
        jBlock.invoke("super").arg(jVar);
        jBlock.assign(jFieldRef, jVar2);
        JMethod jMethod2 = jDefinedClass.constructor(1);
        jVar = jMethod2.param(String.class, "message");
        jVar2 = jMethod2.param(jType, "faultInfo");
        JVar jVar3 = jMethod2.param(Throwable.class, "cause");
        jMethod2.javadoc().addParam(jVar);
        jMethod2.javadoc().addParam(jVar2);
        jMethod2.javadoc().addParam(jVar3);
        JBlock jBlock2 = jMethod2.body();
        jBlock2.invoke("super").arg(jVar).arg(jVar3);
        jBlock2.assign(jFieldRef, jVar2);
        JMethod jMethod3 = jDefinedClass.method(1, jType, "getFaultInfo");
        jMethod3.javadoc().addReturn().add("returns fault bean: " + jType.fullName());
        JBlock jBlock3 = jMethod3.body();
        jBlock3._return(jFieldVar);
        fault.setExceptionClass(jDefinedClass);
    }
}

