/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.tools.internal.ws.ToolVersion;
import com.sun.tools.internal.ws.processor.generator.GeneratorConstants;
import com.sun.tools.internal.ws.processor.generator.GeneratorException;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.ModelVisitor;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Parameter;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Request;
import com.sun.tools.internal.ws.processor.model.Response;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.util.DirectoryUtil;
import com.sun.tools.internal.ws.processor.util.IndentingWriter;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorBase
implements GeneratorConstants,
ModelVisitor {
    private File destDir;
    private String targetVersion;
    protected boolean donotOverride;
    protected JCodeModel cm;
    protected final Model model;
    protected final String wsdlLocation;
    protected final ErrorReceiver receiver;
    protected final WsimportOptions options;

    protected GeneratorBase(Model model, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        this.model = model;
        this.options = wsimportOptions;
        this.destDir = wsimportOptions.destDir;
        this.receiver = errorReceiver;
        this.wsdlLocation = wsimportOptions.wsdlLocation;
        this.targetVersion = wsimportOptions.target.getVersion();
        this.cm = wsimportOptions.getCodeModel();
    }

    protected void doGeneration() {
        try {
            this.model.accept(this);
        }
        catch (Exception exception) {
            this.receiver.error(exception);
        }
    }

    @Override
    public void visit(Model model) throws Exception {
        for (Service service : model.getServices()) {
            service.accept(this);
        }
    }

    @Override
    public void visit(Service service) throws Exception {
        for (Port port : service.getPorts()) {
            port.accept(this);
        }
    }

    @Override
    public void visit(Port port) throws Exception {
        for (Operation operation : port.getOperations()) {
            operation.accept(this);
        }
    }

    @Override
    public void visit(Operation operation) throws Exception {
        Iterator<Fault> iterator;
        operation.getRequest().accept(this);
        if (operation.getResponse() != null) {
            operation.getResponse().accept(this);
        }
        if ((iterator = operation.getFaultsSet().iterator()) != null) {
            while (iterator.hasNext()) {
                Fault fault = iterator.next();
                fault.accept(this);
            }
        }
    }

    @Override
    public void visit(Parameter parameter) throws Exception {
    }

    @Override
    public void visit(Block block) throws Exception {
    }

    @Override
    public void visit(Response response) throws Exception {
    }

    @Override
    public void visit(Request request) throws Exception {
    }

    @Override
    public void visit(Fault fault) throws Exception {
    }

    public List<String> getJAXWSClassComment() {
        return GeneratorBase.getJAXWSClassComment(this.targetVersion);
    }

    public static List<String> getJAXWSClassComment(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("This class was generated by the JAX-WS RI.\n");
        arrayList.add(ToolVersion.VERSION.BUILD_VERSION + "\n");
        arrayList.add("Generated source version: " + string);
        return arrayList;
    }

    protected JDefinedClass getClass(String string, ClassType classType) throws JClassAlreadyExistsException {
        JDefinedClass jDefinedClass;
        block2: {
            try {
                jDefinedClass = this.cm._class(string, classType);
            }
            catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
                jDefinedClass = this.cm._getClass(string);
                if (jDefinedClass != null) break block2;
                throw jClassAlreadyExistsException;
            }
        }
        return jDefinedClass;
    }

    protected void log(String string) {
        if (this.options.verbose) {
            System.out.println("[" + Names.stripQualifier(this.getClass().getName()) + ": " + string + "]");
        }
    }

    protected void writeHandlerConfig(String string, JDefinedClass jDefinedClass, WsimportOptions wsimportOptions) {
        Element element = wsimportOptions.getHandlerChainConfiguration();
        if (element == null) {
            return;
        }
        JAnnotationUse jAnnotationUse = jDefinedClass.annotate(this.cm.ref(HandlerChain.class));
        NodeList nodeList = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chain");
        if (nodeList.getLength() > 0) {
            String string2 = this.getHandlerConfigFileName(string);
            jAnnotationUse.param("file", string2);
            this.generateHandlerChainFile(element, string);
        }
    }

    private String getHandlerConfigFileName(String string) {
        String string2 = Names.stripQualifier(string);
        return string2 + "_handler.xml";
    }

    private void generateHandlerChainFile(Element element, String string) {
        String string2 = this.getHandlerConfigFileName(string);
        File file = DirectoryUtil.getOutputDirectoryFor(string, this.destDir);
        File file2 = new File(file, string2);
        this.options.addGeneratedFile(file2);
        try {
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            Transformer transformer = XmlUtil.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(element), new StreamResult(indentingWriter));
            indentingWriter.close();
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", exception);
        }
    }
}

