/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.model;

import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.ModelException;
import com.sun.tools.internal.ws.processor.model.ModelObject;
import com.sun.tools.internal.ws.processor.model.ModelVisitor;
import com.sun.tools.internal.ws.processor.model.Request;
import com.sun.tools.internal.ws.processor.model.Response;
import com.sun.tools.internal.ws.processor.model.java.JavaMethod;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPStyle;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPUse;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation
extends ModelObject {
    private String customizedName;
    private boolean _isWrapped = true;
    private QName _name;
    private String _uniqueName;
    private Request _request;
    private Response _response;
    private JavaMethod _javaMethod;
    private String _soapAction;
    private SOAPStyle _style = SOAPStyle.DOCUMENT;
    private SOAPUse _use = SOAPUse.LITERAL;
    private Set<String> _faultNames;
    private Set<Fault> _faults;
    private com.sun.tools.internal.ws.wsdl.document.Operation wsdlOperation;

    public Operation(Entity entity) {
        super(entity);
    }

    public Operation(Operation operation, Entity entity) {
        this(operation._name, entity);
        this._style = operation._style;
        this._use = operation._use;
        this.customizedName = operation.customizedName;
    }

    public Operation(QName qName, Entity entity) {
        super(entity);
        this._name = qName;
        this._uniqueName = qName.getLocalPart();
        this._faultNames = new HashSet<String>();
        this._faults = new HashSet<Fault>();
    }

    public QName getName() {
        return this._name;
    }

    public void setName(QName qName) {
        this._name = qName;
    }

    public String getUniqueName() {
        return this._uniqueName;
    }

    public void setUniqueName(String string) {
        this._uniqueName = string;
    }

    public Request getRequest() {
        return this._request;
    }

    public void setRequest(Request request) {
        this._request = request;
    }

    public Response getResponse() {
        return this._response;
    }

    public void setResponse(Response response) {
        this._response = response;
    }

    public boolean isOverloaded() {
        return !this._name.getLocalPart().equals(this._uniqueName);
    }

    public void addFault(Fault fault) {
        if (this._faultNames.contains(fault.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._faultNames.add(fault.getName());
        this._faults.add(fault);
    }

    public Iterator<Fault> getFaults() {
        return this._faults.iterator();
    }

    public Set<Fault> getFaultsSet() {
        return this._faults;
    }

    public void setFaultsSet(Set<Fault> set) {
        this._faults = set;
        this.initializeFaultNames();
    }

    private void initializeFaultNames() {
        this._faultNames = new HashSet<String>();
        if (this._faults != null) {
            for (Fault fault : this._faults) {
                if (fault.getName() != null && this._faultNames.contains(fault.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this._faultNames.add(fault.getName());
            }
        }
    }

    public Iterator<Fault> getAllFaults() {
        Set<Fault> set = this.getAllFaultsSet();
        return set.iterator();
    }

    public Set<Fault> getAllFaultsSet() {
        HashSet<Fault> hashSet = new HashSet<Fault>();
        hashSet.addAll(this._faults);
        Iterator<Fault> iterator = this._faults.iterator();
        while (iterator.hasNext()) {
            Set set = iterator.next().getAllFaultsSet();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public int getFaultCount() {
        return this._faults.size();
    }

    public Set<Block> getAllFaultBlocks() {
        HashSet<Block> hashSet = new HashSet<Block>();
        for (Fault fault : this._faults) {
            hashSet.add(fault.getBlock());
        }
        return hashSet;
    }

    public JavaMethod getJavaMethod() {
        return this._javaMethod;
    }

    public void setJavaMethod(JavaMethod javaMethod) {
        this._javaMethod = javaMethod;
    }

    public String getSOAPAction() {
        return this._soapAction;
    }

    public void setSOAPAction(String string) {
        this._soapAction = string;
    }

    public SOAPStyle getStyle() {
        return this._style;
    }

    public void setStyle(SOAPStyle sOAPStyle) {
        this._style = sOAPStyle;
    }

    public SOAPUse getUse() {
        return this._use;
    }

    public void setUse(SOAPUse sOAPUse) {
        this._use = sOAPUse;
    }

    public boolean isWrapped() {
        return this._isWrapped;
    }

    public void setWrapped(boolean bl) {
        this._isWrapped = bl;
    }

    @Override
    public void accept(ModelVisitor modelVisitor) throws Exception {
        modelVisitor.visit(this);
    }

    public void setCustomizedName(String string) {
        this.customizedName = string;
    }

    public String getCustomizedName() {
        return this.customizedName;
    }

    public String getJavaMethodName() {
        if (this._javaMethod != null) {
            return this._javaMethod.getName();
        }
        if (this.customizedName != null) {
            return this.customizedName;
        }
        return JAXBRIContext.mangleNameToVariableName((String)this._name.getLocalPart());
    }

    public com.sun.tools.internal.ws.wsdl.document.Operation getWSDLPortTypeOperation() {
        return this.wsdlOperation;
    }

    public void setWSDLPortTypeOperation(com.sun.tools.internal.ws.wsdl.document.Operation operation) {
        this.wsdlOperation = operation;
    }
}

