/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.model;

import com.sun.tools.internal.ws.processor.model.ModelException;
import com.sun.tools.internal.ws.processor.model.ModelObject;
import com.sun.tools.internal.ws.processor.model.ModelVisitor;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.java.JavaInterface;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends ModelObject {
    private QName name;
    private List<Port> ports = new ArrayList<Port>();
    private Map<QName, Port> portsByName = new HashMap<QName, Port>();
    private JavaInterface javaInterface;

    public Service(Entity entity) {
        super(entity);
    }

    public Service(QName qName, JavaInterface javaInterface, Entity entity) {
        super(entity);
        this.name = qName;
        this.javaInterface = javaInterface;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public void addPort(Port port) {
        if (this.portsByName.containsKey(port.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this.ports.add(port);
        this.portsByName.put(port.getName(), port);
    }

    public Port getPortByName(QName qName) {
        if (this.portsByName.size() != this.ports.size()) {
            this.initializePortsByName();
        }
        return this.portsByName.get(qName);
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Port> list) {
        this.ports = list;
    }

    private void initializePortsByName() {
        this.portsByName = new HashMap<QName, Port>();
        if (this.ports != null) {
            for (Port port : this.ports) {
                if (port.getName() != null && this.portsByName.containsKey(port.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this.portsByName.put(port.getName(), port);
            }
        }
    }

    public JavaInterface getJavaIntf() {
        return this.getJavaInterface();
    }

    public JavaInterface getJavaInterface() {
        return this.javaInterface;
    }

    public void setJavaInterface(JavaInterface javaInterface) {
        this.javaInterface = javaInterface;
    }

    @Override
    public void accept(ModelVisitor modelVisitor) throws Exception {
        modelVisitor.visit(this);
    }
}

