/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeMoniker;
import java.util.ArrayList;
import java.util.Collection;

public class TypeMonikerFactory {
    public static TypeMoniker getTypeMoniker(TypeMirror typeMirror) {
        if (typeMirror instanceof PrimitiveType) {
            return new PrimitiveTypeMoniker((PrimitiveType)typeMirror);
        }
        if (typeMirror instanceof ArrayType) {
            return new ArrayTypeMoniker((ArrayType)typeMirror);
        }
        if (typeMirror instanceof DeclaredType) {
            return new DeclaredTypeMoniker((DeclaredType)typeMirror);
        }
        return TypeMonikerFactory.getTypeMoniker(((Object)typeMirror).toString());
    }

    public static TypeMoniker getTypeMoniker(String string) {
        return new StringMoniker(string);
    }

    static class ArrayTypeMoniker
    implements TypeMoniker {
        private TypeMoniker arrayType;

        public ArrayTypeMoniker(ArrayType arrayType) {
            this.arrayType = TypeMonikerFactory.getTypeMoniker(arrayType.getComponentType());
        }

        public TypeMirror create(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
            return annotationProcessorEnvironment.getTypeUtils().getArrayType(this.arrayType.create(annotationProcessorEnvironment));
        }
    }

    static class DeclaredTypeMoniker
    implements TypeMoniker {
        private String typeDeclName;
        private Collection<TypeMoniker> typeArgs = new ArrayList<TypeMoniker>();

        public DeclaredTypeMoniker(DeclaredType declaredType) {
            this.typeDeclName = declaredType.getDeclaration().getQualifiedName();
            for (TypeMirror typeMirror : declaredType.getActualTypeArguments()) {
                this.typeArgs.add(TypeMonikerFactory.getTypeMoniker(typeMirror));
            }
        }

        public TypeMirror create(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
            TypeDeclaration typeDeclaration = annotationProcessorEnvironment.getTypeDeclaration(this.typeDeclName);
            TypeMirror[] typeMirrorArray = new TypeMirror[this.typeArgs.size()];
            int n = 0;
            for (TypeMoniker typeMoniker : this.typeArgs) {
                typeMirrorArray[n++] = typeMoniker.create(annotationProcessorEnvironment);
            }
            return annotationProcessorEnvironment.getTypeUtils().getDeclaredType(typeDeclaration, typeMirrorArray);
        }
    }

    static class PrimitiveTypeMoniker
    implements TypeMoniker {
        private PrimitiveType.Kind kind;

        public PrimitiveTypeMoniker(PrimitiveType primitiveType) {
            this.kind = primitiveType.getKind();
        }

        public TypeMirror create(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
            return annotationProcessorEnvironment.getTypeUtils().getPrimitiveType(this.kind);
        }
    }

    static class StringMoniker
    implements TypeMoniker {
        private String typeName;

        public StringMoniker(String string) {
            this.typeName = string;
        }

        public TypeMirror create(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
            return annotationProcessorEnvironment.getTypeUtils().getDeclaredType(annotationProcessorEnvironment.getTypeDeclaration(this.typeName), new TypeMirror[0]);
        }
    }
}

