/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.internal.ws.ToolVersion;
import com.sun.tools.internal.ws.processor.generator.GeneratorUtil;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.modeler.ModelerException;
import com.sun.tools.internal.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.internal.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceVisitor;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceWrapperGenerator;
import com.sun.tools.internal.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.internal.ws.resources.WebserviceapMessages;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.internal.ws.wscompile.WsgenOptions;
import com.sun.tools.internal.ws.wscompile.WsimportListener;
import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.Localizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.xml.sax.SAXParseException;

public class WebServiceAP
implements AnnotationProcessor,
ModelBuilder,
WebServiceConstants {
    protected AnnotationProcessorEnvironment apEnv;
    private File sourceDir;
    private TypeDeclaration remoteDecl;
    private TypeDeclaration remoteExceptionDecl;
    private TypeDeclaration exceptionDecl;
    private TypeDeclaration defHolderDecl;
    private Service service;
    private Port port;
    protected AnnotationProcessorContext context;
    private Set<TypeDeclaration> processedTypeDecls = new HashSet<TypeDeclaration>();
    protected Messager messager;
    private boolean doNotOverWrite = false;
    private WsgenOptions options;
    private ErrorReceiver receiver;
    private PrintStream out;
    private boolean isAPTInvocation = false;
    private static final Localizer localizer = new Localizer();

    public void run() {
    }

    protected boolean parseArguments(String[] stringArray) {
        return true;
    }

    public WebServiceAP(WsgenOptions wsgenOptions, AnnotationProcessorContext annotationProcessorContext, ErrorReceiver errorReceiver, PrintStream printStream) {
        this.options = wsgenOptions;
        this.sourceDir = wsgenOptions != null ? wsgenOptions.sourceDir : null;
        this.doNotOverWrite = wsgenOptions != null && wsgenOptions.doNotOverWrite;
        this.receiver = errorReceiver;
        this.out = printStream;
        this.context = annotationProcessorContext;
    }

    public void init(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this.apEnv = annotationProcessorEnvironment;
        this.remoteDecl = this.apEnv.getTypeDeclaration(REMOTE_CLASSNAME);
        this.remoteExceptionDecl = this.apEnv.getTypeDeclaration(REMOTE_EXCEPTION_CLASSNAME);
        this.exceptionDecl = this.apEnv.getTypeDeclaration(EXCEPTION_CLASSNAME);
        this.defHolderDecl = this.apEnv.getTypeDeclaration(HOLDER_CLASSNAME);
        if (this.options == null) {
            String string;
            this.options = new WsgenOptions();
            this.out = new PrintStream(new ByteArrayOutputStream());
            class Listener
            extends WsimportListener {
                ConsoleErrorReporter cer;

                Listener() {
                    this.cer = new ConsoleErrorReporter(WebServiceAP.this.out);
                }

                public void generatedFile(String string) {
                    this.message(string);
                }

                public void message(String string) {
                    WebServiceAP.this.out.println(string);
                }

                public void error(SAXParseException sAXParseException) {
                    this.cer.error(sAXParseException);
                }

                public void fatalError(SAXParseException sAXParseException) {
                    this.cer.fatalError(sAXParseException);
                }

                public void warning(SAXParseException sAXParseException) {
                    this.cer.warning(sAXParseException);
                }

                public void info(SAXParseException sAXParseException) {
                    this.cer.info(sAXParseException);
                }
            }
            final Listener listener = new Listener();
            this.receiver = new ErrorReceiverFilter(new Listener()){
                {
                    super(errorListener);
                }

                public void info(SAXParseException sAXParseException) {
                    if (((WebServiceAP)WebServiceAP.this).options.verbose) {
                        super.info(sAXParseException);
                    }
                }

                public void warning(SAXParseException sAXParseException) {
                    if (!((WebServiceAP)WebServiceAP.this).options.quiet) {
                        super.warning(sAXParseException);
                    }
                }

                public void pollAbort() throws AbortException {
                    if (listener.isCanceled()) {
                        throw new AbortException();
                    }
                }
            };
            Map<String, String> map = annotationProcessorEnvironment.getOptions();
            String string2 = map.get("-d");
            if (string2 == null) {
                string2 = ".";
            }
            this.sourceDir = map.get("-s") != null ? new File(map.get("-s")) : new File(string2);
            String string3 = map.get("-classpath");
            this.options.classpath = string = string2 + File.pathSeparator + string3 + File.pathSeparator + System.getProperty("java.class.path");
            boolean bl = false;
            for (String string4 : map.keySet()) {
                if (!string4.equals("-verbose")) continue;
                bl = true;
            }
            this.options.verbose = bl;
            this.messager = annotationProcessorEnvironment.getMessager();
            this.isAPTInvocation = true;
        }
        this.options.filer = annotationProcessorEnvironment.getFiler();
    }

    public AnnotationProcessorEnvironment getAPEnv() {
        return this.apEnv;
    }

    public WsgenOptions getOptions() {
        return this.options;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void onError(String string) {
        if (this.messager != null) {
            this.messager.printError(string);
            throw new AbortException();
        }
        throw new ModelerException(string, new Object[0]);
    }

    public void onError(SourcePosition sourcePosition, Localizable localizable) throws ModelerException {
        if (this.messager == null) {
            throw new ModelerException(localizable);
        }
        this.messager.printError(sourcePosition, localizer.localize(localizable));
    }

    public void onWarning(String string) {
        if (this.messager != null) {
            this.messager.printWarning(string);
        } else {
            this.report(string);
        }
    }

    public void onInfo(String string) {
        if (this.messager != null) {
            this.messager.printNotice(string);
        } else {
            this.report(string);
        }
    }

    protected void report(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? this.out : new PrintStream(this.out, true);
        printStream.println(string);
        printStream.flush();
    }

    public void process() {
        if (this.context.getRound() == 1) {
            this.buildModel();
        }
        this.context.incrementRound();
    }

    public boolean checkAndSetProcessed(TypeDeclaration typeDeclaration) {
        if (!this.processedTypeDecls.contains(typeDeclaration)) {
            this.processedTypeDecls.add(typeDeclaration);
            return false;
        }
        return true;
    }

    public void clearProcessed() {
        this.processedTypeDecls.clear();
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setPort(Port port) {
        this.port = port;
        this.service.addPort(port);
    }

    public void addOperation(Operation operation) {
        this.port.addOperation(operation);
    }

    public void setWrapperGenerated(boolean bl) {
    }

    public TypeDeclaration getTypeDeclaration(String string) {
        return this.apEnv.getTypeDeclaration(string);
    }

    public String getSourceVersion() {
        return ToolVersion.VERSION.MAJOR_VERSION;
    }

    private void buildModel() {
        WebServiceVisitor webServiceVisitor = this.createWrapperGenerator();
        boolean bl = false;
        for (TypeDeclaration typeDeclaration : this.apEnv.getTypeDeclarations()) {
            if (!(typeDeclaration instanceof ClassDeclaration)) continue;
            WebServiceProvider webServiceProvider = typeDeclaration.getAnnotation(WebServiceProvider.class);
            WebService webService = typeDeclaration.getAnnotation(WebService.class);
            if (webServiceProvider != null) {
                if (webService != null) {
                    this.onError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_AND_WEBSERVICEPROVIDER(typeDeclaration.getQualifiedName()));
                }
                bl = true;
            }
            if (!this.shouldProcessWebService(webService)) continue;
            typeDeclaration.accept(webServiceVisitor);
            bl = true;
        }
        if (!bl) {
            if (this.isAPTInvocation) {
                this.onWarning(WebserviceapMessages.WEBSERVICEAP_NO_WEBSERVICE_ENDPOINT_FOUND());
            } else {
                this.onError(WebserviceapMessages.WEBSERVICEAP_NO_WEBSERVICE_ENDPOINT_FOUND());
            }
        }
    }

    protected WebServiceVisitor createWrapperGenerator() {
        return new WebServiceWrapperGenerator(this, this.context);
    }

    protected boolean shouldProcessWebService(WebService webService) {
        return webService != null;
    }

    public boolean isException(TypeDeclaration typeDeclaration) {
        return WebServiceAP.isSubtype(typeDeclaration, this.exceptionDecl);
    }

    public boolean isRemoteException(TypeDeclaration typeDeclaration) {
        return WebServiceAP.isSubtype(typeDeclaration, this.remoteExceptionDecl);
    }

    public boolean isRemote(TypeDeclaration typeDeclaration) {
        return WebServiceAP.isSubtype(typeDeclaration, this.remoteDecl);
    }

    public static boolean isSubtype(TypeDeclaration typeDeclaration, TypeDeclaration typeDeclaration2) {
        Object object;
        if (typeDeclaration.equals(typeDeclaration2)) {
            return true;
        }
        ClassDeclaration classDeclaration = null;
        if (typeDeclaration instanceof ClassDeclaration && (object = ((ClassDeclaration)typeDeclaration).getSuperclass()) != null && (classDeclaration = object.getDeclaration()).equals(typeDeclaration2)) {
            return true;
        }
        object = null;
        for (InterfaceType interfaceType : typeDeclaration.getSuperinterfaces()) {
            object = interfaceType.getDeclaration();
            if (!object.equals(typeDeclaration2)) continue;
            return true;
        }
        if (object != null && WebServiceAP.isSubtype((TypeDeclaration)object, typeDeclaration2)) {
            return true;
        }
        return classDeclaration != null && WebServiceAP.isSubtype(classDeclaration, typeDeclaration2);
    }

    public static String getMethodSig(MethodDeclaration methodDeclaration) {
        StringBuffer stringBuffer = new StringBuffer(methodDeclaration.getSimpleName() + "(");
        Iterator<TypeParameterDeclaration> iterator = methodDeclaration.getFormalTypeParameters().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            TypeParameterDeclaration typeParameterDeclaration = iterator.next();
            stringBuffer.append(typeParameterDeclaration.getSimpleName());
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getOperationName(String string) {
        return string;
    }

    public String getResponseName(String string) {
        return Names.getResponseName(string);
    }

    public TypeMirror getHolderValueType(TypeMirror typeMirror) {
        return TypeModeler.getHolderValueType(typeMirror, this.defHolderDecl);
    }

    public boolean canOverWriteClass(String string) {
        return !this.doNotOverWrite || !GeneratorUtil.classExists(this.options, string);
    }

    public void log(String string) {
        if (this.options != null && this.options.verbose) {
            String string2 = "[" + string + "]";
            if (this.messager != null) {
                this.messager.printNotice(string2);
            } else {
                System.out.println(string2);
            }
        }
    }

    public String getXMLName(String string) {
        return string;
    }
}

