/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.istack.internal.tools.ParallelWorldClassLoader;
import com.sun.tools.internal.ws.resources.JavacompilerMessages;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

class JavaCompilerHelper {
    private static final Class[] compileMethodSignature = new Class[]{String[].class, PrintWriter.class};

    JavaCompilerHelper() {
    }

    static File getJarFile(Class clazz) {
        URL uRL = null;
        try {
            uRL = ParallelWorldClassLoader.toJarUrl(clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class"));
            return new File(uRL.toURI());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error(malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(uRL.getPath());
        }
    }

    static boolean compile(String[] stringArray, OutputStream outputStream, ErrorReceiver errorReceiver) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("com.sun.tools.javac.Main");
            try {
                Method method = clazz.getMethod("compile", compileMethodSignature);
                Object object = method.invoke(null, stringArray, new PrintWriter(outputStream));
                return object instanceof Integer && (Integer)object == 0;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                errorReceiver.error(JavacompilerMessages.JAVACOMPILER_NOSUCHMETHOD_ERROR("getMethod(\"compile\", Class[])"), noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                errorReceiver.error(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                errorReceiver.error(invocationTargetException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            errorReceiver.error(JavacompilerMessages.JAVACOMPILER_CLASSPATH_ERROR("com.sun.tools.javac.Main"), classNotFoundException);
        }
        catch (SecurityException securityException) {
            errorReceiver.error(securityException);
        }
        return false;
    }
}

