/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.mirror.apt.Filer;
import com.sun.tools.internal.ws.api.WsgenExtension;
import com.sun.tools.internal.ws.api.WsgenProtocol;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.wscompile.BadCommandLineException;
import com.sun.tools.internal.ws.wscompile.Options;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.namespace.QName;

public class WsgenOptions
extends Options {
    public QName serviceName;
    public QName portName;
    public File nonclassDestDir;
    public boolean genWsdl;
    public String protocol = "soap1.1";
    public Set<String> protocols = new LinkedHashSet<String>();
    public Map<String, String> nonstdProtocols = new LinkedHashMap<String, String>();
    public File wsgenReport;
    public boolean doNotOverWrite;
    public Filer filer;
    public boolean protocolSet = false;
    private static final String SERVICENAME_OPTION = "-servicename";
    private static final String PORTNAME_OPTION = "-portname";
    private static final String HTTP = "http";
    private static final String SOAP11 = "soap1.1";
    public static final String X_SOAP12 = "Xsoap1.2";
    List<String> endpoints = new ArrayList<String>();
    public Class endpoint;
    private boolean isImplClass;
    private boolean noWebServiceEndpoint;

    public WsgenOptions() {
        this.protocols.add(SOAP11);
        this.protocols.add(X_SOAP12);
        this.nonstdProtocols.put(X_SOAP12, "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/");
        ServiceFinder serviceFinder = ServiceFinder.find(WsgenExtension.class);
        for (WsgenExtension wsgenExtension : serviceFinder) {
            Class<?> clazz = wsgenExtension.getClass();
            WsgenProtocol wsgenProtocol = clazz.getAnnotation(WsgenProtocol.class);
            this.protocols.add(wsgenProtocol.token());
            this.nonstdProtocols.put(wsgenProtocol.token(), wsgenProtocol.lexical());
        }
    }

    protected int parseArguments(String[] stringArray, int n) throws BadCommandLineException {
        int n2 = super.parseArguments(stringArray, n);
        if (stringArray[n].equals(SERVICENAME_OPTION)) {
            this.serviceName = QName.valueOf(this.requireArgument(SERVICENAME_OPTION, stringArray, ++n));
            if (this.serviceName.getNamespaceURI() == null || this.serviceName.getNamespaceURI().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_SERVICENAME_MISSING_NAMESPACE(stringArray[n]));
            }
            if (this.serviceName.getLocalPart() == null || this.serviceName.getLocalPart().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_SERVICENAME_MISSING_LOCALNAME(stringArray[n]));
            }
            return 2;
        }
        if (stringArray[n].equals(PORTNAME_OPTION)) {
            this.portName = QName.valueOf(this.requireArgument(PORTNAME_OPTION, stringArray, ++n));
            if (this.portName.getNamespaceURI() == null || this.portName.getNamespaceURI().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_PORTNAME_MISSING_NAMESPACE(stringArray[n]));
            }
            if (this.portName.getLocalPart() == null || this.portName.getLocalPart().length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_PORTNAME_MISSING_LOCALNAME(stringArray[n]));
            }
            return 2;
        }
        if (stringArray[n].equals("-r")) {
            this.nonclassDestDir = new File(this.requireArgument("-r", stringArray, ++n));
            if (!this.nonclassDestDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.nonclassDestDir.getPath()));
            }
            return 2;
        }
        if (stringArray[n].equals("-classpath") || stringArray[n].equals("-cp")) {
            this.classpath = this.requireArgument("-classpath", stringArray, ++n) + File.pathSeparator + System.getProperty("java.class.path");
            return 2;
        }
        if (stringArray[n].startsWith("-wsdl")) {
            this.genWsdl = true;
            String string = stringArray[n].substring(5);
            int n3 = string.indexOf(58);
            if (n3 == 0) {
                n3 = (string = string.substring(1)).indexOf(47);
                this.protocol = n3 == -1 ? string : string.substring(0, n3);
                this.protocolSet = true;
            }
            return 1;
        }
        if (stringArray[n].equals("-XwsgenReport")) {
            this.wsgenReport = new File(this.requireArgument("-XwsgenReport", stringArray, ++n));
            return 2;
        }
        if (stringArray[n].equals("-Xdonotoverwrite")) {
            this.doNotOverWrite = true;
            return 1;
        }
        return n2;
    }

    protected void addFile(String string) {
        this.endpoints.add(string);
    }

    public void validate() throws BadCommandLineException {
        if (this.nonclassDestDir == null) {
            this.nonclassDestDir = this.destDir;
        }
        if (!this.protocols.contains(this.protocol)) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_INVALID_PROTOCOL(this.protocol, this.protocols));
        }
        if (this.endpoints.isEmpty()) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_MISSING_FILE());
        }
        if (this.protocol == null || this.protocol.equalsIgnoreCase(X_SOAP12) && !this.isExtensionMode()) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_SOAP_12_WITHOUT_EXTENSION());
        }
        if (this.nonstdProtocols.containsKey(this.protocol) && !this.isExtensionMode()) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_PROTOCOL_WITHOUT_EXTENSION(this.protocol));
        }
        this.validateEndpointClass();
        this.validateArguments();
    }

    private void validateEndpointClass() throws BadCommandLineException {
        Class clazz = null;
        for (String string : this.endpoints) {
            clazz = this.getClass(string);
            if (clazz == null || clazz.isEnum() || clazz.isInterface() || clazz.isPrimitive()) continue;
            this.isImplClass = true;
            WebService webService = clazz.getAnnotation(WebService.class);
            if (webService == null) continue;
        }
        if (clazz == null) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_NOT_FOUND(this.endpoints.get(0)));
        }
        if (!this.isImplClass) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_MUST_BE_IMPLEMENTATION_CLASS(clazz.getName()));
        }
        if (this.noWebServiceEndpoint) {
            throw new BadCommandLineException(WscompileMessages.WSGEN_NO_WEBSERVICES_CLASS(clazz.getName()));
        }
        this.endpoint = clazz;
        this.validateBinding();
    }

    private void validateBinding() throws BadCommandLineException {
        if (this.genWsdl) {
            BindingID bindingID = BindingID.parse((Class)this.endpoint);
            if (!(!bindingID.equals((Object)BindingID.SOAP12_HTTP) && !bindingID.equals((Object)BindingID.SOAP12_HTTP_MTOM) || this.protocol.equals(X_SOAP12) && this.isExtensionMode())) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CANNOT_GEN_WSDL_FOR_SOAP_12_BINDING(bindingID.toString(), this.endpoint.getName()));
            }
            if (bindingID.equals((Object)BindingID.XML_HTTP)) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CANNOT_GEN_WSDL_FOR_NON_SOAP_BINDING(bindingID.toString(), this.endpoint.getName()));
            }
        }
    }

    private void validateArguments() throws BadCommandLineException {
        if (!this.genWsdl) {
            if (this.serviceName != null) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_WSDL_ARG_NO_GENWSDL(SERVICENAME_OPTION));
            }
            if (this.portName != null) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_WSDL_ARG_NO_GENWSDL(PORTNAME_OPTION));
            }
        }
    }

    BindingID getBindingID(String string) {
        if (string.equals(SOAP11)) {
            return BindingID.SOAP11_HTTP;
        }
        if (string.equals(X_SOAP12)) {
            return BindingID.SOAP12_HTTP;
        }
        String string2 = this.nonstdProtocols.get(string);
        return string2 != null ? BindingID.parse((String)string2) : null;
    }

    private Class getClass(String string) {
        try {
            return this.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

