/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.codemodel.internal.JCodeModel;
import com.sun.tools.internal.ws.resources.ConfigurationMessages;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.util.ForkEntityResolver;
import com.sun.tools.internal.ws.wscompile.BadCommandLineException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.Options;
import com.sun.tools.internal.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import com.sun.tools.internal.xjc.api.SchemaCompiler;
import com.sun.tools.internal.xjc.api.SpecVersion;
import com.sun.tools.internal.xjc.api.XJC;
import com.sun.tools.internal.xjc.reader.Util;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsimportOptions
extends Options {
    public String wsdlLocation;
    public EntityResolver entityResolver = null;
    public String defaultPackage = null;
    public boolean additionalHeaders;
    public boolean disableSSLHostnameVerification;
    private SchemaCompiler schemaCompiler = XJC.createSchemaCompiler();
    public File authFile;
    private JCodeModel codeModel;
    public List<String> cmdlineJars = new ArrayList<String>();
    public boolean noAddressingBbinding;
    private final List<InputSource> wsdls = new ArrayList<InputSource>();
    private final List<InputSource> schemas = new ArrayList<InputSource>();
    private final List<InputSource> bindingFiles = new ArrayList<InputSource>();
    private final List<InputSource> jaxwsCustomBindings = new ArrayList<InputSource>();
    private final List<InputSource> jaxbCustomBindings = new ArrayList<InputSource>();
    private final List<Element> handlerConfigs = new ArrayList<Element>();

    public JCodeModel getCodeModel() {
        if (this.codeModel == null) {
            this.codeModel = new JCodeModel();
        }
        return this.codeModel;
    }

    public SchemaCompiler getSchemaCompiler() {
        this.schemaCompiler.setTargetVersion(SpecVersion.parse(this.target.getVersion()));
        this.schemaCompiler.setEntityResolver(this.entityResolver);
        return this.schemaCompiler;
    }

    public void setCodeModel(JCodeModel jCodeModel) {
        this.codeModel = jCodeModel;
    }

    @Override
    public final void parseArguments(String[] stringArray) throws BadCommandLineException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (stringArray[i].charAt(0) == '-') {
                int n = this.parseArguments(stringArray, i);
                if (n == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(stringArray[i]));
                }
                i += n - 1;
                continue;
            }
            if (stringArray[i].endsWith(".jar")) {
                try {
                    this.cmdlineJars.add(stringArray[i]);
                    this.schemaCompiler.getOptions().scanEpisodeFile(new File(stringArray[i]));
                    continue;
                }
                catch (com.sun.tools.internal.xjc.BadCommandLineException badCommandLineException) {
                    throw new BadCommandLineException(badCommandLineException.getMessage(), badCommandLineException);
                }
            }
            this.addFile(stringArray[i]);
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
    }

    @Override
    public int parseArguments(String[] stringArray, int n) throws BadCommandLineException {
        int n2 = super.parseArguments(stringArray, n);
        if (n2 > 0) {
            return n2;
        }
        if (stringArray[n].equals("-b")) {
            this.addBindings(this.requireArgument("-b", stringArray, ++n));
            return 2;
        }
        if (stringArray[n].equals("-wsdllocation")) {
            this.wsdlLocation = this.requireArgument("-wsdllocation", stringArray, ++n);
            return 2;
        }
        if (stringArray[n].equals("-XadditionalHeaders")) {
            this.additionalHeaders = true;
            return 1;
        }
        if (stringArray[n].equals("-XdisableSSLHostnameVerification")) {
            this.disableSSLHostnameVerification = true;
            return 1;
        }
        if (stringArray[n].equals("-p")) {
            this.defaultPackage = this.requireArgument("-p", stringArray, ++n);
            return 2;
        }
        if (stringArray[n].equals("-catalog")) {
            String string = this.requireArgument("-catalog", stringArray, ++n);
            try {
                if (this.entityResolver == null) {
                    if (string != null && string.length() > 0) {
                        this.entityResolver = XmlUtil.createEntityResolver((URL)JAXWSUtils.getFileOrURL((String)JAXWSUtils.absolutize((String)Util.escapeSpace(string))));
                    }
                } else if (string != null && string.length() > 0) {
                    EntityResolver entityResolver = XmlUtil.createEntityResolver((URL)JAXWSUtils.getFileOrURL((String)JAXWSUtils.absolutize((String)Util.escapeSpace(string))));
                    this.entityResolver = new ForkEntityResolver(entityResolver, this.entityResolver);
                }
            }
            catch (IOException iOException) {
                throw new BadCommandLineException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(string, iOException.getMessage()));
            }
            return 2;
        }
        if (stringArray[n].startsWith("-httpproxy:")) {
            String string = stringArray[n].substring(11);
            if (string.length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(stringArray[n]));
            }
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                System.setProperty("proxySet", "true");
                System.setProperty("proxyHost", string);
                System.setProperty("proxyPort", "8080");
            } else {
                System.setProperty("proxySet", "true");
                System.setProperty("proxyHost", string.substring(0, n3));
                System.setProperty("proxyPort", string.substring(n3 + 1));
            }
            return 1;
        }
        if (stringArray[n].equals("-Xno-addressing-databinding")) {
            this.noAddressingBbinding = true;
            return 1;
        }
        if (stringArray[n].startsWith("-B")) {
            String[] stringArray2 = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
            stringArray2[0] = stringArray2[0].substring(2);
            com.sun.tools.internal.xjc.Options options = this.schemaCompiler.getOptions();
            try {
                int n4 = options.parseArgument(stringArray2, 0);
                if (n4 == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSIMPORT_NO_SUCH_JAXB_OPTION(stringArray2[0]));
                }
                return n4;
            }
            catch (com.sun.tools.internal.xjc.BadCommandLineException badCommandLineException) {
                throw new BadCommandLineException(badCommandLineException.getMessage(), badCommandLineException);
            }
        }
        if (stringArray[n].equals("-Xauthfile")) {
            String string = this.requireArgument("-Xauthfile", stringArray, ++n);
            this.authFile = new File(string);
            return 2;
        }
        return 0;
    }

    public void validate() throws BadCommandLineException {
        if (this.wsdls.isEmpty()) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_MISSING_FILE());
        }
        if (this.wsdlLocation == null) {
            this.wsdlLocation = this.wsdls.get(0).getSystemId();
        }
    }

    @Override
    protected void addFile(String string) throws BadCommandLineException {
        this.addFile(string, this.wsdls, "*.wsdl");
    }

    public Element getHandlerChainConfiguration() {
        if (this.handlerConfigs.size() > 0) {
            return this.handlerConfigs.get(0);
        }
        return null;
    }

    public void addHandlerChainConfiguration(Element element) {
        this.handlerConfigs.add(element);
    }

    public InputSource[] getWSDLs() {
        return this.wsdls.toArray(new InputSource[this.wsdls.size()]);
    }

    public InputSource[] getSchemas() {
        return this.schemas.toArray(new InputSource[this.schemas.size()]);
    }

    public InputSource[] getWSDLBindings() {
        return this.jaxwsCustomBindings.toArray(new InputSource[this.jaxwsCustomBindings.size()]);
    }

    public InputSource[] getSchemaBindings() {
        return this.jaxbCustomBindings.toArray(new InputSource[this.jaxbCustomBindings.size()]);
    }

    public void addWSDL(File file) {
        this.addWSDL(this.fileToInputSource(file));
    }

    public void addWSDL(InputSource inputSource) {
        this.wsdls.add(this.absolutize(inputSource));
    }

    public void addSchema(File file) {
        this.addSchema(this.fileToInputSource(file));
    }

    public void addSchema(InputSource inputSource) {
        this.schemas.add(inputSource);
    }

    private InputSource fileToInputSource(File file) {
        try {
            String string = file.toURL().toExternalForm();
            return new InputSource(Util.escapeSpace(string));
        }
        catch (MalformedURLException malformedURLException) {
            return new InputSource(file.getPath());
        }
    }

    public void addGrammarRecursive(File file) {
        this.addRecursive(file, ".wsdl", this.wsdls);
        this.addRecursive(file, ".xsd", this.schemas);
    }

    public void addWSDLBindFile(InputSource inputSource) {
        this.jaxwsCustomBindings.add(this.absolutize(inputSource));
    }

    public void addSchemmaBindFile(InputSource inputSource) {
        this.jaxbCustomBindings.add(this.absolutize(inputSource));
    }

    private void addRecursive(File file, String string, List<InputSource> list) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.addRecursive(file2, string, list);
                continue;
            }
            if (!file2.getPath().endsWith(string)) continue;
            list.add(this.absolutize(this.fileToInputSource(file2)));
        }
    }

    private InputSource absolutize(InputSource inputSource) {
        try {
            URL uRL = new File(".").getCanonicalFile().toURL();
            inputSource.setSystemId(new URL(uRL, inputSource.getSystemId()).toExternalForm());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputSource;
    }

    public void addBindings(String string) throws BadCommandLineException {
        this.addFile(string, this.bindingFiles, null);
    }

    private void addFile(String string, List<InputSource> list, String string2) throws BadCommandLineException {
        Object object;
        try {
            object = Util.getFileOrURL(string);
        }
        catch (IOException iOException) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_NOT_A_FILE_NOR_URL(string));
        }
        if (object instanceof URL) {
            list.add(this.absolutize(new InputSource(Util.escapeSpace(((URL)object).toExternalForm()))));
        } else {
            File file = (File)object;
            if (file.isDirectory()) {
                this.addRecursive(file, string2, list);
            } else {
                list.add(this.absolutize(this.fileToInputSource(file)));
            }
        }
    }

    public final void parseBindings(ErrorReceiver errorReceiver) {
        for (InputSource inputSource : this.bindingFiles) {
            XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create((InputSource)inputSource, (boolean)true);
            XMLStreamReaderUtil.nextElementContent((XMLStreamReader)xMLStreamReader);
            if (xMLStreamReader.getName().equals(JAXWSBindingsConstants.JAXWS_BINDINGS)) {
                this.jaxwsCustomBindings.add(inputSource);
                continue;
            }
            if (xMLStreamReader.getName().equals(JAXWSBindingsConstants.JAXB_BINDINGS) || xMLStreamReader.getName().equals(new QName("http://www.w3.org/2001/XMLSchema", "schema"))) {
                this.jaxbCustomBindings.add(inputSource);
                continue;
            }
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setSystemId(xMLStreamReader.getLocation().getSystemId());
            locatorImpl.setPublicId(xMLStreamReader.getLocation().getPublicId());
            locatorImpl.setLineNumber(xMLStreamReader.getLocation().getLineNumber());
            locatorImpl.setColumnNumber(xMLStreamReader.getLocation().getColumnNumber());
            errorReceiver.warning(locatorImpl, ConfigurationMessages.CONFIGURATION_NOT_BINDING_FILE(inputSource.getSystemId()));
        }
    }
}

