/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wscompile;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.writer.ProgressCodeWriter;
import com.sun.codemodel.internal.writer.PrologCodeWriter;
import com.sun.istack.internal.tools.ParallelWorldClassLoader;
import com.sun.tools.internal.ws.ToolVersion;
import com.sun.tools.internal.ws.api.TJavaGeneratorExtension;
import com.sun.tools.internal.ws.processor.generator.CustomExceptionGenerator;
import com.sun.tools.internal.ws.processor.generator.SeiGenerator;
import com.sun.tools.internal.ws.processor.generator.ServiceGenerator;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.internal.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.resources.WsdlMessages;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.BadCommandLineException;
import com.sun.tools.internal.ws.wscompile.DefaultAuthenticator;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.internal.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.internal.ws.wscompile.Options;
import com.sun.tools.internal.ws.wscompile.WSCodeWriter;
import com.sun.tools.internal.ws.wscompile.WsimportListener;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.xjc.util.NullStream;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.EndpointReference;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public class WsimportTool {
    private static final String WSIMPORT = "wsimport";
    private final PrintStream out;
    private final Container container;
    private final WsimportOptions options = new WsimportOptions();

    public WsimportTool(OutputStream outputStream) {
        this(outputStream, null);
    }

    public WsimportTool(OutputStream outputStream, Container container) {
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean run(String[] stringArray) {
        class Listener
        extends WsimportListener {
            ConsoleErrorReporter cer;

            Listener() {
                this.cer = new ConsoleErrorReporter(WsimportTool.this.out == null ? new PrintStream(new NullStream()) : WsimportTool.this.out);
            }

            public void generatedFile(String string) {
                this.message(string);
            }

            public void message(String string) {
                WsimportTool.this.out.println(string);
            }

            public void error(SAXParseException sAXParseException) {
                this.cer.error(sAXParseException);
            }

            public void fatalError(SAXParseException sAXParseException) {
                this.cer.fatalError(sAXParseException);
            }

            public void warning(SAXParseException sAXParseException) {
                this.cer.warning(sAXParseException);
            }

            public void debug(SAXParseException sAXParseException) {
                this.cer.debug(sAXParseException);
            }

            public void info(SAXParseException sAXParseException) {
                this.cer.info(sAXParseException);
            }

            public void enableDebugging() {
                this.cer.enableDebugging();
            }
        }
        final Listener listener = new Listener();
        ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(listener){
            {
                super(errorListener);
            }

            public void info(SAXParseException sAXParseException) {
                if (((WsimportTool)WsimportTool.this).options.verbose) {
                    super.info(sAXParseException);
                }
            }

            public void warning(SAXParseException sAXParseException) {
                if (!((WsimportTool)WsimportTool.this).options.quiet) {
                    super.warning(sAXParseException);
                }
            }

            public void pollAbort() throws AbortException {
                if (listener.isCanceled()) {
                    throw new AbortException();
                }
            }

            public void debug(SAXParseException sAXParseException) {
                if (((WsimportTool)WsimportTool.this).options.debugMode) {
                    listener.debug(sAXParseException);
                }
            }
        };
        for (String object : stringArray) {
            if (!object.equals("-version")) continue;
            listener.message(ToolVersion.VERSION.BUILD_VERSION);
            return true;
        }
        try {
            Model model;
            block21: {
                this.options.parseArguments(stringArray);
                this.options.validate();
                if (this.options.debugMode) {
                    listener.enableDebugging();
                }
                this.options.parseBindings(errorReceiverFilter);
                if (!this.options.quiet) {
                    listener.message(WscompileMessages.WSIMPORT_PARSING_WSDL());
                }
                Authenticator.setDefault(new DefaultAuthenticator(errorReceiverFilter, this.options.authFile));
                WSDLModeler wSDLModeler = new WSDLModeler(this.options, errorReceiverFilter);
                model = wSDLModeler.buildModel();
                if (model != null) break block21;
                listener.message(WsdlMessages.PARSING_PARSE_FAILED());
                int n = 0;
                return n != 0;
            }
            try {
                void var7_18;
                if (!this.options.quiet) {
                    listener.message(WscompileMessages.WSIMPORT_GENERATING_CODE());
                }
                TJavaGeneratorExtension[] tJavaGeneratorExtensionArray = (TJavaGeneratorExtension[])ServiceFinder.find(TJavaGeneratorExtension.class).toArray();
                CustomExceptionGenerator.generate(model, this.options, errorReceiverFilter);
                SeiGenerator.generate(model, this.options, errorReceiverFilter, tJavaGeneratorExtensionArray);
                if (errorReceiverFilter.hadError()) {
                    throw new AbortException();
                }
                ServiceGenerator.generate(model, this.options, errorReceiverFilter);
                WSCodeWriter wSCodeWriter = new WSCodeWriter(this.options.sourceDir, this.options);
                PrologCodeWriter prologCodeWriter = new PrologCodeWriter(wSCodeWriter, WsimportTool.getJAXClassComment());
                if (this.options.verbose) {
                    ProgressCodeWriter progressCodeWriter = new ProgressCodeWriter(prologCodeWriter, this.out);
                }
                this.options.getCodeModel().build((CodeWriter)var7_18);
            }
            catch (AbortException abortException) {
            }
            catch (IOException iOException) {
                errorReceiverFilter.error(iOException);
            }
            if (!this.options.nocompile && !this.compileGeneratedClasses(errorReceiverFilter, listener)) {
                listener.message(WscompileMessages.WSCOMPILE_COMPILATION_FAILED());
                boolean bl = false;
                return bl;
            }
        }
        catch (Options.WeAreDone weAreDone) {
            this.usage(weAreDone.getOptions());
        }
        catch (BadCommandLineException badCommandLineException) {
            if (badCommandLineException.getMessage() != null) {
                System.out.println(badCommandLineException.getMessage());
                System.out.println();
            }
            this.usage(badCommandLineException.getOptions());
            int n = 0;
            return n != 0;
        }
        finally {
            if (!this.options.keep) {
                this.options.removeGeneratedFiles();
            }
        }
        return true;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.options.entityResolver = entityResolver;
    }

    private static boolean useBootClasspath(Class clazz) {
        try {
            ParallelWorldClassLoader.toJarUrl(clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class"));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean compileGeneratedClasses(ErrorReceiver errorReceiver, WsimportListener wsimportListener) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File object : this.options.getGeneratedFiles()) {
            if (!object.exists() || !object.getName().endsWith(".java")) continue;
            arrayList.add(object.getAbsolutePath());
        }
        if (arrayList.size() > 0) {
            String string = this.options.destDir.getAbsolutePath();
            String string2 = this.createClasspathString();
            boolean bl = WsimportTool.useBootClasspath(EndpointReference.class) || WsimportTool.useBootClasspath(XmlSeeAlso.class);
            String[] stringArray = new String[4 + (bl ? 1 : 0) + (this.options.debug ? 1 : 0) + arrayList.size()];
            stringArray[0] = "-d";
            stringArray[1] = string;
            stringArray[2] = "-classpath";
            stringArray[3] = string2;
            int n = 4;
            if (bl) {
                stringArray[n++] = "-Xbootclasspath/p:" + JavaCompilerHelper.getJarFile(EndpointReference.class) + File.pathSeparator + JavaCompilerHelper.getJarFile(XmlSeeAlso.class);
            }
            if (this.options.debug) {
                stringArray[n++] = "-g";
            }
            for (int stringBuffer = 0; stringBuffer < arrayList.size(); ++stringBuffer) {
                stringArray[n + stringBuffer] = (String)arrayList.get(stringBuffer);
            }
            wsimportListener.message(WscompileMessages.WSIMPORT_COMPILING_CODE());
            if (this.options.verbose) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string3 : stringArray) {
                    stringBuffer.append(string3).append(" ");
                }
                wsimportListener.message("javac " + stringBuffer.toString());
            }
            return JavaCompilerHelper.compile(stringArray, this.out, errorReceiver);
        }
        return true;
    }

    private String createClasspathString() {
        String string = System.getProperty("java.class.path");
        for (String string2 : this.options.cmdlineJars) {
            string = string + File.pathSeparator + new File(string2);
        }
        return string;
    }

    protected void usage(Options options) {
        System.out.println(WscompileMessages.WSIMPORT_HELP(WSIMPORT));
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXTENSIONS());
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXAMPLES());
    }

    public static String getJAXClassComment() {
        String string = new String();
        String string2 = ResourceBundle.getBundle("com.sun.tools.internal.xjc.MessageBundle").getString("Driver.BuildID");
        string = "Generated By:" + ToolVersion.VERSION.BUILD_VERSION + " (JAXB RI IBM " + string2 + ")" + "\n";
        return string;
    }
}

