/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.document;

import com.sun.tools.internal.ws.resources.WsdlMessages;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Kinds;
import com.sun.tools.internal.ws.wsdl.document.MessagePart;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.internal.ws.wsdl.framework.Defining;
import com.sun.tools.internal.ws.wsdl.framework.EntityAction;
import com.sun.tools.internal.ws.wsdl.framework.GlobalEntity;
import com.sun.tools.internal.ws.wsdl.framework.Kind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends GlobalEntity {
    private Documentation _documentation;
    private List<MessagePart> _parts = new ArrayList<MessagePart>();
    private Map<String, MessagePart> _partsByName = new HashMap<String, MessagePart>();

    public Message(Defining defining, Locator locator, ErrorReceiver errorReceiver) {
        super(defining, locator, errorReceiver);
    }

    public void add(MessagePart messagePart) {
        if (this._partsByName.get(messagePart.getName()) != null) {
            this.errorReceiver.error(messagePart.getLocator(), WsdlMessages.VALIDATION_DUPLICATE_PART_NAME(this.getName(), messagePart.getName()));
            throw new AbortException();
        }
        if (messagePart.getDescriptor() != null && messagePart.getDescriptorKind() != null) {
            this._partsByName.put(messagePart.getName(), messagePart);
            this._parts.add(messagePart);
        } else {
            this.errorReceiver.warning(messagePart.getLocator(), WsdlMessages.PARSING_ELEMENT_OR_TYPE_REQUIRED(messagePart.getName()));
        }
    }

    public Iterator<MessagePart> parts() {
        return this._parts.iterator();
    }

    public List<MessagePart> getParts() {
        return this._parts;
    }

    public MessagePart getPart(String string) {
        return this._partsByName.get(string);
    }

    public int numParts() {
        return this._parts.size();
    }

    @Override
    public Kind getKind() {
        return Kinds.MESSAGE;
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_MESSAGE;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this._documentation = documentation;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction entityAction) {
        super.withAllSubEntitiesDo(entityAction);
        Iterator<MessagePart> iterator = this._parts.iterator();
        while (iterator.hasNext()) {
            entityAction.perform(iterator.next());
        }
    }

    public void accept(WSDLDocumentVisitor wSDLDocumentVisitor) throws Exception {
        wSDLDocumentVisitor.preVisit(this);
        Iterator<MessagePart> iterator = this._parts.iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(wSDLDocumentVisitor);
        }
        wSDLDocumentVisitor.postVisit(this);
    }

    @Override
    public void validateThis() {
        if (this.getName() == null) {
            this.errorReceiver.error(this.getLocator(), WsdlMessages.VALIDATION_MISSING_REQUIRED_ATTRIBUTE("name", "wsdl:message"));
            throw new AbortException();
        }
    }
}

