/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.document;

import com.sun.codemodel.internal.JClass;
import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.internal.ws.api.wsdl.TWSDLExtension;
import com.sun.tools.internal.ws.api.wsdl.TWSDLOperation;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Fault;
import com.sun.tools.internal.ws.wsdl.document.Input;
import com.sun.tools.internal.ws.wsdl.document.OperationStyle;
import com.sun.tools.internal.ws.wsdl.document.Output;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.EntityAction;
import com.sun.tools.internal.ws.wsdl.framework.ExtensibilityHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation
extends Entity
implements TWSDLOperation {
    private TWSDLExtensible parent;
    private Documentation _documentation;
    private String _name;
    private Input _input;
    private Output _output;
    private List<Fault> _faults;
    private OperationStyle _style;
    private String _parameterOrder;
    private String _uniqueKey;
    private ExtensibilityHelper _helper;
    private final Map<String, JClass> faultClassMap = new HashMap<String, JClass>();
    private final Map<String, JClass> unmodifiableFaultClassMap = Collections.unmodifiableMap(this.faultClassMap);

    public Operation(Locator locator) {
        super(locator);
        this._faults = new ArrayList<Fault>();
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getUniqueKey() {
        if (this._uniqueKey == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._name);
            stringBuffer.append(' ');
            if (this._input != null) {
                stringBuffer.append(this._input.getName());
            } else {
                stringBuffer.append(this._name);
                if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    stringBuffer.append("Request");
                } else if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    stringBuffer.append("Response");
                }
            }
            stringBuffer.append(' ');
            if (this._output != null) {
                stringBuffer.append(this._output.getName());
            } else {
                stringBuffer.append(this._name);
                if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    stringBuffer.append("Solicit");
                } else if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    stringBuffer.append("Response");
                }
            }
            this._uniqueKey = stringBuffer.toString();
        }
        return this._uniqueKey;
    }

    public OperationStyle getStyle() {
        return this._style;
    }

    public void setStyle(OperationStyle operationStyle) {
        this._style = operationStyle;
    }

    public Input getInput() {
        return this._input;
    }

    public void setInput(Input input) {
        this._input = input;
    }

    public Output getOutput() {
        return this._output;
    }

    public void setOutput(Output output) {
        this._output = output;
    }

    public void addFault(Fault fault) {
        this._faults.add(fault);
    }

    public Iterable<Fault> faults() {
        return this._faults;
    }

    public String getParameterOrder() {
        return this._parameterOrder;
    }

    public void setParameterOrder(String string) {
        this._parameterOrder = string;
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_OPERATION;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this._documentation = documentation;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction entityAction) {
        super.withAllSubEntitiesDo(entityAction);
        if (this._input != null) {
            entityAction.perform(this._input);
        }
        if (this._output != null) {
            entityAction.perform(this._output);
        }
        for (Fault fault : this._faults) {
            entityAction.perform(fault);
        }
        this._helper.withAllSubEntitiesDo(entityAction);
    }

    public void accept(WSDLDocumentVisitor wSDLDocumentVisitor) throws Exception {
        wSDLDocumentVisitor.preVisit(this);
        if (this._input != null) {
            this._input.accept(wSDLDocumentVisitor);
        }
        if (this._output != null) {
            this._output.accept(wSDLDocumentVisitor);
        }
        for (Fault fault : this._faults) {
            fault.accept(wSDLDocumentVisitor);
        }
        wSDLDocumentVisitor.postVisit(this);
    }

    @Override
    public void validateThis() {
        if (this._name == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
        if (this._style == null) {
            this.failValidation("validation.missingRequiredProperty", "style");
        }
        if (this._style == OperationStyle.ONE_WAY) {
            if (this._input == null) {
                this.failValidation("validation.missingRequiredSubEntity", "input");
            }
            if (this._output != null) {
                this.failValidation("validation.invalidSubEntity", "output");
            }
            if (this._faults != null && this._faults.size() != 0) {
                this.failValidation("validation.invalidSubEntity", "fault");
            }
        } else if (this._style == OperationStyle.NOTIFICATION && this._parameterOrder != null) {
            this.failValidation("validation.invalidAttribute", "parameterOrder");
        }
    }

    @Override
    public String getNameValue() {
        return this.getName();
    }

    @Override
    public String getNamespaceURI() {
        return this.parent.getNamespaceURI();
    }

    @Override
    public QName getWSDLElementName() {
        return this.getElementName();
    }

    @Override
    public void addExtension(TWSDLExtension tWSDLExtension) {
        this._helper.addExtension(tWSDLExtension);
    }

    @Override
    public Iterable<? extends TWSDLExtension> extensions() {
        return this._helper.extensions();
    }

    @Override
    public TWSDLExtensible getParent() {
        return this.parent;
    }

    public void setParent(TWSDLExtensible tWSDLExtensible) {
        this.parent = tWSDLExtensible;
    }

    @Override
    public Map<String, JClass> getFaults() {
        return this.unmodifiableFaultClassMap;
    }

    public void putFault(String string, JClass jClass) {
        this.faultClassMap.put(string, jClass);
    }
}

