/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.document;

import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wsdl.document.Definitions;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.internal.ws.wsdl.framework.AbstractDocument;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.EntityAction;
import com.sun.tools.internal.ws.wsdl.framework.EntityReferenceAction;
import com.sun.tools.internal.ws.wsdl.framework.EntityReferenceValidator;
import com.sun.tools.internal.ws.wsdl.framework.GloballyKnown;
import com.sun.tools.internal.ws.wsdl.framework.Kind;
import com.sun.tools.internal.ws.wsdl.framework.NoSuchEntityException;
import com.sun.tools.internal.ws.wsdl.framework.ValidationException;
import com.sun.tools.internal.ws.wsdl.parser.MetadataFinder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class WSDLDocument
extends AbstractDocument {
    private Definitions _definitions;

    public WSDLDocument(MetadataFinder metadataFinder, ErrorReceiver errorReceiver) {
        super(metadataFinder, errorReceiver);
    }

    public Definitions getDefinitions() {
        return this._definitions;
    }

    public void setDefinitions(Definitions definitions) {
        this._definitions = definitions;
    }

    public QName[] getAllServiceQNames() {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Iterator<Service> iterator = this.getDefinitions().services();
        while (iterator.hasNext()) {
            Service service = iterator.next();
            String string = service.getDefining().getTargetNamespaceURI();
            String string2 = service.getName();
            QName qName = new QName(string, string2);
            arrayList.add(qName);
        }
        return arrayList.toArray(new QName[arrayList.size()]);
    }

    public QName[] getAllPortQNames() {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Iterator<Service> iterator = this.getDefinitions().services();
        while (iterator.hasNext()) {
            Service service = iterator.next();
            Iterator<Port> iterator2 = service.ports();
            while (iterator2.hasNext()) {
                Port port = iterator2.next();
                String string = port.getDefining().getTargetNamespaceURI();
                String string2 = port.getName();
                QName qName = new QName(string, string2);
                arrayList.add(qName);
            }
        }
        return arrayList.toArray(new QName[arrayList.size()]);
    }

    public QName[] getPortQNames(String string) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        Iterator<Service> iterator = this.getDefinitions().services();
        while (iterator.hasNext()) {
            Service service = iterator.next();
            if (!service.getName().equals(string)) continue;
            Iterator<Port> iterator2 = service.ports();
            while (iterator2.hasNext()) {
                Port port = iterator2.next();
                String string2 = port.getDefining().getTargetNamespaceURI();
                String string3 = port.getName();
                QName qName = new QName(string2, string3);
                arrayList.add(qName);
            }
        }
        return arrayList.toArray(new QName[arrayList.size()]);
    }

    public void accept(WSDLDocumentVisitor wSDLDocumentVisitor) throws Exception {
        this._definitions.accept(wSDLDocumentVisitor);
    }

    public void validate(EntityReferenceValidator entityReferenceValidator) {
        GloballyValidatingAction globallyValidatingAction = new GloballyValidatingAction(this, entityReferenceValidator);
        this.withAllSubEntitiesDo(globallyValidatingAction);
        if (globallyValidatingAction.getException() != null) {
            throw globallyValidatingAction.getException();
        }
    }

    protected Entity getRoot() {
        return this._definitions;
    }

    private class GloballyValidatingAction
    implements EntityAction,
    EntityReferenceAction {
        private ValidationException _exception;
        private AbstractDocument _document;
        private EntityReferenceValidator _validator;

        public GloballyValidatingAction(AbstractDocument abstractDocument, EntityReferenceValidator entityReferenceValidator) {
            this._document = abstractDocument;
            this._validator = entityReferenceValidator;
        }

        public void perform(Entity entity) {
            block2: {
                try {
                    entity.validateThis();
                    entity.withAllEntityReferencesDo(this);
                    entity.withAllSubEntitiesDo(this);
                }
                catch (ValidationException validationException) {
                    if (this._exception != null) break block2;
                    this._exception = validationException;
                }
            }
        }

        public void perform(Kind kind, QName qName) {
            block2: {
                try {
                    GloballyKnown globallyKnown = this._document.find(kind, qName);
                }
                catch (NoSuchEntityException noSuchEntityException) {
                    if (this._exception != null || this._validator != null && this._validator.isValid(kind, qName)) break block2;
                    this._exception = noSuchEntityException;
                }
            }
        }

        public ValidationException getException() {
            return this._exception;
        }
    }
}

