/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.istack.internal.NotNull;
import com.sun.tools.internal.ws.resources.WscompileMessages;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.DefaultAuthenticator;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.parser.DOMBuilder;
import com.sun.tools.internal.ws.wsdl.parser.InternalizationLogic;
import com.sun.tools.internal.ws.wsdl.parser.VersionChecker;
import com.sun.tools.internal.ws.wsdl.parser.WhitespaceStripper;
import com.sun.tools.internal.xjc.reader.internalizer.LocatorTable;
import com.sun.xml.internal.bind.marshaller.DataWriter;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMForest {
    protected final Set<String> rootDocuments = new HashSet<String>();
    protected final Set<String> externalReferences = new HashSet<String>();
    protected final Map<String, Document> core = new HashMap<String, Document>();
    protected final WsimportOptions options;
    protected final ErrorReceiver errorReceiver;
    private final DocumentBuilder documentBuilder;
    private final SAXParserFactory parserFactory;
    protected final List<Element> inlinedSchemaElements = new ArrayList<Element>();
    public final LocatorTable locatorTable = new LocatorTable();
    public final Set<Element> outerMostBindings = new HashSet<Element>();
    protected final InternalizationLogic logic;

    public DOMForest(InternalizationLogic internalizationLogic, WsimportOptions wsimportOptions, ErrorReceiver errorReceiver) {
        this.options = wsimportOptions;
        this.errorReceiver = errorReceiver;
        this.logic = internalizationLogic;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.parserFactory = SAXParserFactory.newInstance();
            this.parserFactory.setNamespaceAware(true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    public List<Element> getInlinedSchemaElement() {
        return this.inlinedSchemaElements;
    }

    @NotNull
    public Document parse(InputSource inputSource, boolean bl) throws SAXException, IOException {
        if (inputSource.getSystemId() == null) {
            throw new IllegalArgumentException();
        }
        return this.parse(inputSource.getSystemId(), inputSource, bl);
    }

    public Document parse(String string, boolean bl) throws SAXException, IOException {
        string = this.normalizeSystemId(string);
        InputSource inputSource = null;
        if (this.options.entityResolver != null) {
            inputSource = this.options.entityResolver.resolveEntity(null, string);
        }
        if (inputSource == null) {
            inputSource = new InputSource(string);
        } else {
            string = inputSource.getSystemId();
        }
        if (this.core.containsKey(string)) {
            return this.core.get(string);
        }
        if (!bl) {
            this.addExternalReferences(string);
        }
        return this.parse(string, inputSource, bl);
    }

    @NotNull
    public Document parse(String string, InputSource inputSource, boolean bl) throws SAXException, IOException {
        Document document = this.documentBuilder.newDocument();
        string = this.normalizeSystemId(string);
        this.core.put(string, document);
        document.setDocumentURI(string);
        if (bl) {
            this.rootDocuments.add(string);
        }
        try {
            XMLReader xMLReader = this.parserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this.getParserHandler(document));
            if (this.errorReceiver != null) {
                xMLReader.setErrorHandler(this.errorReceiver);
            }
            if (this.options.entityResolver != null) {
                xMLReader.setEntityResolver(this.options.entityResolver);
            }
            InputStream inputStream = null;
            if (inputSource.getByteStream() != null) {
                inputStream = inputSource.getByteStream();
            }
            if (inputStream == null) {
                boolean bl2;
                int n = 0;
                URL uRL = JAXWSUtils.getFileOrURL((String)inputSource.getSystemId());
                URLConnection uRLConnection = uRL.openConnection();
                do {
                    URL uRL2;
                    List<String> list;
                    HttpURLConnection httpURLConnection;
                    int n2;
                    if (uRLConnection instanceof HttpsURLConnection && this.options.disableSSLHostnameVerification) {
                        ((HttpsURLConnection)uRLConnection).setHostnameVerifier(new HttpClientVerifier());
                    }
                    bl2 = false;
                    if (uRLConnection instanceof HttpURLConnection) {
                        ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
                    }
                    try {
                        inputStream = uRLConnection.getInputStream();
                    }
                    catch (IOException iOException) {
                        HttpURLConnection httpURLConnection2;
                        int n3;
                        if (uRLConnection instanceof HttpURLConnection && (n3 = (httpURLConnection2 = (HttpURLConnection)uRLConnection).getResponseCode()) == 401) {
                            this.errorReceiver.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_INFO_NEEDED(iOException.getMessage(), string, DefaultAuthenticator.defaultAuthfile), null, iOException));
                            throw new AbortException();
                        }
                        throw iOException;
                    }
                    if (!(uRLConnection instanceof HttpURLConnection) || (n2 = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) != 302 && n2 != 303 || (list = httpURLConnection.getHeaderFields().get("Location")) == null || list.size() <= 0 || (uRL2 = new URL(uRL, list.get(0))).equals(uRL)) continue;
                    this.errorReceiver.info(new SAXParseException(WscompileMessages.WSIMPORT_HTTP_REDIRECT(n2, list.get(0)), null));
                    uRL = uRL2;
                    httpURLConnection.disconnect();
                    if (n >= 5) {
                        this.errorReceiver.error(new SAXParseException(WscompileMessages.WSIMPORT_MAX_REDIRECT_ATTEMPT(), null));
                        throw new AbortException();
                    }
                    uRLConnection = uRL.openConnection();
                    inputSource.setSystemId(uRL.toExternalForm());
                    ++n;
                    bl2 = true;
                } while (bl2);
            }
            inputSource.setByteStream(inputStream);
            xMLReader.parse(inputSource);
            Element element = document.getDocumentElement();
            if (element == null) {
                return null;
            }
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.inlinedSchemaElements.add((Element)nodeList.item(i));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorReceiver.error(parserConfigurationException);
            throw new SAXException(parserConfigurationException.getMessage());
        }
        return document;
    }

    public void addExternalReferences(String string) {
        if (!this.externalReferences.contains(string)) {
            this.externalReferences.add(string);
        }
    }

    public Set<String> getExternalReferences() {
        return this.externalReferences;
    }

    public Handler getParserHandler(String string, boolean bl) {
        final Document document = this.documentBuilder.newDocument();
        this.core.put(string, document);
        if (bl) {
            this.rootDocuments.add(string);
        }
        ContentHandler contentHandler = this.getParserHandler(document);
        HandlerImpl handlerImpl = new HandlerImpl(){

            public Document getDocument() {
                return document;
            }
        };
        handlerImpl.setContentHandler(contentHandler);
        return handlerImpl;
    }

    private ContentHandler getParserHandler(Document document) {
        Object object = new DOMBuilder(document, this.locatorTable, this.outerMostBindings);
        object = new WhitespaceStripper((ContentHandler)object, this.errorReceiver, this.options.entityResolver);
        object = new VersionChecker((ContentHandler)object, this.errorReceiver, this.options.entityResolver);
        XMLFilterImpl xMLFilterImpl = this.logic.createExternalReferenceFinder(this);
        xMLFilterImpl.setContentHandler((ContentHandler)object);
        if (this.errorReceiver != null) {
            xMLFilterImpl.setErrorHandler(this.errorReceiver);
        }
        if (this.options.entityResolver != null) {
            xMLFilterImpl.setEntityResolver(this.options.entityResolver);
        }
        return xMLFilterImpl;
    }

    private String normalizeSystemId(String string) {
        try {
            string = new URI(string).normalize().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return string;
    }

    boolean isExtensionMode() {
        return this.options.isExtensionMode();
    }

    public Document get(String string) {
        Document document = this.core.get(string);
        if (document == null && string.startsWith("file:/") && !string.startsWith("file://")) {
            document = this.core.get("file://" + string.substring(5));
        }
        if (document == null && string.startsWith("file:")) {
            String string2 = this.getPath(string);
            for (String string3 : this.core.keySet()) {
                if (!string3.startsWith("file:") || !this.getPath(string3).equalsIgnoreCase(string2)) continue;
                document = this.core.get(string3);
                break;
            }
        }
        return document;
    }

    private String getPath(String string) {
        string = string.substring(5);
        while (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    public String[] listSystemIDs() {
        return this.core.keySet().toArray(new String[this.core.keySet().size()]);
    }

    public String getSystemId(Document document) {
        for (Map.Entry<String, Document> entry : this.core.entrySet()) {
            if (entry.getValue() != document) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getFirstRootDocument() {
        if (this.rootDocuments.isEmpty()) {
            return null;
        }
        return this.rootDocuments.iterator().next();
    }

    public Set<String> getRootDocuments() {
        return this.rootDocuments;
    }

    public void dump(OutputStream outputStream) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            for (Map.Entry<String, Document> entry : this.core.entrySet()) {
                outputStream.write(("---<< " + entry.getKey() + '\n').getBytes());
                DataWriter dataWriter = new DataWriter((Writer)new OutputStreamWriter(outputStream), null);
                dataWriter.setIndentStep("  ");
                transformer.transform(new DOMSource(entry.getValue()), new SAXResult((ContentHandler)dataWriter));
                outputStream.write("\n\n\n".getBytes());
            }
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    public static interface Handler
    extends ContentHandler {
        public Document getDocument();
    }

    private static abstract class HandlerImpl
    extends XMLFilterImpl
    implements Handler {
        private HandlerImpl() {
        }
    }

    private static class HttpClientVerifier
    implements HostnameVerifier {
        private HttpClientVerifier() {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }
}

