/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.internal.ws.api.wsdl.TWSDLExtension;
import com.sun.tools.internal.ws.api.wsdl.TWSDLParserContext;
import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wsdl.document.BindingOperation;
import com.sun.tools.internal.ws.wsdl.document.Definitions;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Fault;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.jaxws.CustomName;
import com.sun.tools.internal.ws.wsdl.document.jaxws.Exception;
import com.sun.tools.internal.ws.wsdl.document.jaxws.JAXWSBinding;
import com.sun.tools.internal.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import com.sun.tools.internal.ws.wsdl.document.jaxws.Parameter;
import com.sun.tools.internal.ws.wsdl.parser.AbstractExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.NamespaceContextImpl;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSBindingExtensionHandler
extends AbstractExtensionHandler {
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();

    public JAXWSBindingExtensionHandler(Map<String, AbstractExtensionHandler> map) {
        super(map);
    }

    @Override
    public String getNamespaceURI() {
        return "http://java.sun.com/xml/ns/jaxws";
    }

    private boolean parseGlobalJAXWSBindings(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        Element element2;
        String string;
        tWSDLParserContext.push();
        tWSDLParserContext.registerNamespaces(element);
        JAXWSBinding jAXWSBinding = JAXWSBindingExtensionHandler.getJAXWSExtension(tWSDLExtensible);
        if (jAXWSBinding == null) {
            jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"wsdlLocation")) != null) {
            jAXWSBinding.setWsdlLocation(string);
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"node")) != null) {
            jAXWSBinding.setNode(string);
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"version")) != null) {
            jAXWSBinding.setVersion(string);
        }
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PACKAGE)) {
                this.parsePackage(tWSDLParserContext, jAXWSBinding, element2);
                if (jAXWSBinding.getJaxwsPackage() == null || jAXWSBinding.getJaxwsPackage().getJavaDoc() == null) continue;
                ((Definitions)tWSDLExtensible).setDocumentation(new Documentation(jAXWSBinding.getJaxwsPackage().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(tWSDLParserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(tWSDLParserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                this.parseMimeContent(tWSDLParserContext, jAXWSBinding, element2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
            return false;
        }
        tWSDLExtensible.addExtension(jAXWSBinding);
        tWSDLParserContext.pop();
        return true;
    }

    private static JAXWSBinding getJAXWSExtension(TWSDLExtensible tWSDLExtensible) {
        for (TWSDLExtension tWSDLExtension : tWSDLExtensible.extensions()) {
            if (!tWSDLExtension.getClass().equals(JAXWSBinding.class)) continue;
            return (JAXWSBinding)tWSDLExtension;
        }
        return null;
    }

    private void parseProvider(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            jAXWSBinding.setProvider(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            jAXWSBinding.setProvider(Boolean.TRUE);
        }
    }

    private void parseJAXBBindings(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        JAXWSBinding jAXWSBinding = (JAXWSBinding)((Object)tWSDLExtensible);
        jAXWSBinding.addJaxbBindings(element);
    }

    private void parsePackage(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        JAXWSBinding jAXWSBinding2 = jAXWSBinding;
        jAXWSBinding2.setJaxwsPackage(new CustomName(string, this.getJavaDoc(element)));
    }

    private void parseWrapperStyle(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            jAXWSBinding.setEnableWrapperStyle(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            jAXWSBinding.setEnableWrapperStyle(Boolean.TRUE);
        }
    }

    private void parseAsynMapping(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            jAXWSBinding.setEnableAsyncMapping(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            jAXWSBinding.setEnableAsyncMapping(Boolean.TRUE);
        }
    }

    private void parseMimeContent(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            jAXWSBinding.setEnableMimeContentMapping(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            jAXWSBinding.setEnableMimeContentMapping(Boolean.TRUE);
        }
    }

    private void parseMethod(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        String string2 = this.getJavaDoc(element);
        CustomName customName = new CustomName(string, string2);
        jAXWSBinding.setMethodName(customName);
    }

    private void parseParameter(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"part");
        Element element2 = this.evaluateXPathNode(element.getOwnerDocument(), string, new NamespaceContextImpl(element));
        Node node = element2.getParentNode();
        String string2 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
        String string3 = XmlUtil.getAttributeOrNull((Element)((Element)node), (String)"name");
        if (string2 == null || string3 == null) {
            return;
        }
        String string4 = XmlUtil.getAttributeOrNull((Element)element2, (String)"element");
        String string5 = XmlUtil.getAttributeOrNull((Element)element, (String)"childElementName");
        String string6 = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        QName qName = null;
        if (string5 != null) {
            String string7 = element.lookupNamespaceURI(XmlUtil.getPrefix((String)string5));
            qName = string7 == null ? null : new QName(string7, XmlUtil.getLocalPart((String)string5));
        }
        jAXWSBinding.addParameter(new Parameter(string3, string2, qName, string6));
    }

    private Element evaluateXPathNode(Node node, String string, NamespaceContext namespaceContext) {
        NodeList nodeList;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nodeList = (NodeList)this.xpath.evaluate(string, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            Util.fail("internalizer.XPathEvaluationError", xPathExpressionException.getMessage());
            return null;
        }
        if (nodeList.getLength() == 0) {
            Util.fail("internalizer.XPathEvaluatesToNoTarget", new Object[]{string});
            return null;
        }
        if (nodeList.getLength() != 1) {
            Util.fail("internalizer.XPathEvaulatesToTooManyTargets", new Object[]{string, nodeList.getLength()});
            return null;
        }
        Node node2 = nodeList.item(0);
        if (!(node2 instanceof Element)) {
            Util.fail("internalizer.XPathEvaluatesToNonElement", new Object[]{string});
            return null;
        }
        return (Element)node2;
    }

    private void parseClass(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        String string2 = this.getJavaDoc(element);
        jAXWSBinding.setClassName(new CustomName(string, string2));
    }

    private void parseException(TWSDLParserContext tWSDLParserContext, JAXWSBinding jAXWSBinding, Element element) {
        Element element2;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (!XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) continue;
            String string = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
            String string2 = this.getJavaDoc(element2);
            jAXWSBinding.setException(new Exception(new CustomName(string, string2)));
        }
    }

    @Override
    public boolean handleDefinitionsExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        return this.parseGlobalJAXWSBindings(tWSDLParserContext, tWSDLExtensible, element);
    }

    @Override
    public boolean handlePortTypeExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                    this.parseWrapperStyle(tWSDLParserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                    this.parseAsynMapping(tWSDLParserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(tWSDLParserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getClassName() == null || jAXWSBinding.getClassName().getJavaDoc() == null) continue;
                    ((PortType)tWSDLExtensible).setDocumentation(new Documentation(jAXWSBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            tWSDLExtensible.addExtension(jAXWSBinding);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleOperationExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            if (tWSDLExtensible instanceof Operation) {
                return this.handlePortTypeOperation(tWSDLParserContext, (Operation)tWSDLExtensible, element);
            }
            if (tWSDLExtensible instanceof BindingOperation) {
                return this.handleBindingOperation(tWSDLParserContext, (BindingOperation)tWSDLExtensible, element);
            }
        } else {
            Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
            return false;
        }
        return false;
    }

    private boolean handleBindingOperation(TWSDLParserContext tWSDLParserContext, BindingOperation bindingOperation, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(tWSDLParserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PARAMETER)) {
                    this.parseParameter(tWSDLParserContext, jAXWSBinding, element2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            bindingOperation.addExtension(jAXWSBinding);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    private boolean handlePortTypeOperation(TWSDLParserContext tWSDLParserContext, Operation operation, Element element) {
        Element element2;
        tWSDLParserContext.push();
        tWSDLParserContext.registerNamespaces(element);
        JAXWSBinding jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(tWSDLParserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(tWSDLParserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.METHOD)) {
                this.parseMethod(tWSDLParserContext, jAXWSBinding, element2);
                if (jAXWSBinding.getMethodName() == null || jAXWSBinding.getMethodName().getJavaDoc() == null) continue;
                operation.setDocumentation(new Documentation(jAXWSBinding.getMethodName().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PARAMETER)) {
                this.parseParameter(tWSDLParserContext, jAXWSBinding, element2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
            return false;
        }
        operation.addExtension(jAXWSBinding);
        tWSDLParserContext.pop();
        return true;
    }

    @Override
    public boolean handleBindingExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(tWSDLParserContext, jAXWSBinding, element2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            tWSDLExtensible.addExtension(jAXWSBinding);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleFaultExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(tWSDLParserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getClassName() == null || jAXWSBinding.getClassName().getJavaDoc() == null) continue;
                    ((Fault)tWSDLExtensible).setDocumentation(new Documentation(jAXWSBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            tWSDLExtensible.addExtension(jAXWSBinding);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleServiceExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(tWSDLParserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getClassName() == null || jAXWSBinding.getClassName().getJavaDoc() == null) continue;
                    ((Service)tWSDLExtensible).setDocumentation(new Documentation(jAXWSBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            tWSDLExtensible.addExtension(jAXWSBinding);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handlePortExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding(tWSDLParserContext.getLocation(element));
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PROVIDER)) {
                    this.parseProvider(tWSDLParserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.METHOD)) {
                    this.parseMethod(tWSDLParserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getMethodName() == null || jAXWSBinding.getMethodName().getJavaDoc() == null) continue;
                    ((Port)tWSDLExtensible).setDocumentation(new Documentation(jAXWSBinding.getMethodName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            tWSDLExtensible.addExtension(jAXWSBinding);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    private String getJavaDoc(Element element) {
        Element element2;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (!XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.JAVADOC)) continue;
            return XmlUtil.getTextForNode((Node)element2);
        }
        return null;
    }
}

