/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.internal.ws.api.wsdl.TWSDLParserContext;
import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPAddress;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPBinding;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPBody;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPConstants;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPFault;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPHeader;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPHeaderFault;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPOperation;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPStyle;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPUse;
import com.sun.tools.internal.ws.wsdl.framework.TWSDLParserContextImpl;
import com.sun.tools.internal.ws.wsdl.parser.AbstractExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPExtensionHandler
extends AbstractExtensionHandler {
    public SOAPExtensionHandler(Map<String, AbstractExtensionHandler> map) {
        super(map);
    }

    @Override
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    @Override
    public boolean handleDefinitionsExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleTypesExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected SOAPBinding getSOAPBinding(Locator locator) {
        return new SOAPBinding(locator);
    }

    @Override
    public boolean handleBindingExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, this.getBindingQName())) {
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            SOAPBinding sOAPBinding = this.getSOAPBinding(tWSDLParserContext.getLocation(element));
            String string = Util.getRequiredAttribute(element, "transport");
            sOAPBinding.setTransport(string);
            String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"style");
            if (string2 != null) {
                if (string2.equals("rpc")) {
                    sOAPBinding.setStyle(SOAPStyle.RPC);
                } else if (string2.equals("document")) {
                    sOAPBinding.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", string2);
                }
            }
            tWSDLExtensible.addExtension(sOAPBinding);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleOperationExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, this.getOperationQName())) {
            String string;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            SOAPOperation sOAPOperation = new SOAPOperation(tWSDLParserContext.getLocation(element));
            String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"soapAction");
            if (string2 != null) {
                sOAPOperation.setSOAPAction(string2);
            }
            if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"style")) != null) {
                if (string.equals("rpc")) {
                    sOAPOperation.setStyle(SOAPStyle.RPC);
                } else if (string.equals("document")) {
                    sOAPOperation.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", string);
                }
            }
            tWSDLExtensible.addExtension(sOAPOperation);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleInputExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        return this.handleInputOutputExtension(tWSDLParserContext, tWSDLExtensible, element);
    }

    @Override
    public boolean handleOutputExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        return this.handleInputOutputExtension(tWSDLParserContext, tWSDLExtensible, element);
    }

    @Override
    protected boolean handleMIMEPartExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        return this.handleInputOutputExtension(tWSDLParserContext, tWSDLExtensible, element);
    }

    protected boolean handleInputOutputExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        TWSDLParserContextImpl tWSDLParserContextImpl = (TWSDLParserContextImpl)tWSDLParserContext;
        if (XmlUtil.matchesTagNS(element, this.getBodyQName())) {
            String string;
            String string2;
            String string3;
            tWSDLParserContextImpl.push();
            tWSDLParserContextImpl.registerNamespaces(element);
            SOAPBody sOAPBody = new SOAPBody(tWSDLParserContextImpl.getLocation(element));
            String string4 = XmlUtil.getAttributeOrNull((Element)element, (String)"use");
            if (string4 != null) {
                if (string4.equals("literal")) {
                    sOAPBody.setUse(SOAPUse.LITERAL);
                } else if (string4.equals("encoded")) {
                    sOAPBody.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", string4);
                }
            }
            if ((string3 = XmlUtil.getAttributeOrNull((Element)element, (String)"namespace")) != null) {
                sOAPBody.setNamespace(string3);
            }
            if ((string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"encodingStyle")) != null) {
                sOAPBody.setEncodingStyle(string2);
            }
            if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"parts")) != null) {
                sOAPBody.setParts(string);
            }
            tWSDLExtensible.addExtension(sOAPBody);
            tWSDLParserContextImpl.pop();
            return true;
        }
        if (XmlUtil.matchesTagNS(element, this.getHeaderQName())) {
            Element element2;
            String string;
            String string5;
            String string6;
            String string7;
            tWSDLParserContextImpl.push();
            tWSDLParserContextImpl.registerNamespaces(element);
            SOAPHeader sOAPHeader = new SOAPHeader(tWSDLParserContextImpl.getLocation(element));
            String string8 = XmlUtil.getAttributeOrNull((Element)element, (String)"use");
            if (string8 != null) {
                if (string8.equals("literal")) {
                    sOAPHeader.setUse(SOAPUse.LITERAL);
                } else if (string8.equals("encoded")) {
                    sOAPHeader.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", string8);
                }
            }
            if ((string7 = XmlUtil.getAttributeOrNull((Element)element, (String)"namespace")) != null) {
                sOAPHeader.setNamespace(string7);
            }
            if ((string6 = XmlUtil.getAttributeOrNull((Element)element, (String)"encodingStyle")) != null) {
                sOAPHeader.setEncodingStyle(string6);
            }
            if ((string5 = XmlUtil.getAttributeOrNull((Element)element, (String)"part")) != null) {
                sOAPHeader.setPart(string5);
            }
            if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"message")) != null) {
                sOAPHeader.setMessage(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element), string));
            }
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, this.getHeaderfaultQName())) {
                    String string9;
                    String string10;
                    String string11;
                    String string12;
                    tWSDLParserContextImpl.push();
                    tWSDLParserContextImpl.registerNamespaces(element);
                    SOAPHeaderFault sOAPHeaderFault = new SOAPHeaderFault(tWSDLParserContextImpl.getLocation(element));
                    String string13 = XmlUtil.getAttributeOrNull((Element)element2, (String)"use");
                    if (string13 != null) {
                        if (string13.equals("literal")) {
                            sOAPHeaderFault.setUse(SOAPUse.LITERAL);
                        } else if (string8.equals("encoded")) {
                            sOAPHeaderFault.setUse(SOAPUse.ENCODED);
                        } else {
                            Util.fail("parsing.invalidAttributeValue", "use", string13);
                        }
                    }
                    if ((string12 = XmlUtil.getAttributeOrNull((Element)element2, (String)"namespace")) != null) {
                        sOAPHeaderFault.setNamespace(string12);
                    }
                    if ((string11 = XmlUtil.getAttributeOrNull((Element)element2, (String)"encodingStyle")) != null) {
                        sOAPHeaderFault.setEncodingStyle(string11);
                    }
                    if ((string10 = XmlUtil.getAttributeOrNull((Element)element2, (String)"part")) != null) {
                        sOAPHeaderFault.setPart(string10);
                    }
                    if ((string9 = XmlUtil.getAttributeOrNull((Element)element2, (String)"message")) != null) {
                        sOAPHeaderFault.setMessage(tWSDLParserContextImpl.translateQualifiedName(tWSDLParserContextImpl.getLocation(element2), string9));
                    }
                    sOAPHeader.add(sOAPHeaderFault);
                    tWSDLParserContextImpl.pop();
                    continue;
                }
                Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
            }
            tWSDLExtensible.addExtension(sOAPHeader);
            tWSDLParserContextImpl.pop();
            tWSDLParserContextImpl.fireDoneParsingEntity(this.getHeaderQName(), sOAPHeader);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleFaultExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, this.getFaultQName())) {
            String string;
            String string2;
            String string3;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            SOAPFault sOAPFault = new SOAPFault(tWSDLParserContext.getLocation(element));
            String string4 = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
            if (string4 != null) {
                sOAPFault.setName(string4);
            }
            if ((string3 = XmlUtil.getAttributeOrNull((Element)element, (String)"use")) != null) {
                if (string3.equals("literal")) {
                    sOAPFault.setUse(SOAPUse.LITERAL);
                } else if (string3.equals("encoded")) {
                    sOAPFault.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", string3);
                }
            }
            if ((string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"namespace")) != null) {
                sOAPFault.setNamespace(string2);
            }
            if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"encodingStyle")) != null) {
                sOAPFault.setEncodingStyle(string);
            }
            tWSDLExtensible.addExtension(sOAPFault);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handleServiceExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handlePortExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, this.getAddressQName())) {
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            SOAPAddress sOAPAddress = new SOAPAddress(tWSDLParserContext.getLocation(element));
            String string = Util.getRequiredAttribute(element, "location");
            sOAPAddress.setLocation(string);
            tWSDLExtensible.addExtension(sOAPAddress);
            tWSDLParserContext.pop();
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    public boolean handlePortTypeExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected QName getBodyQName() {
        return SOAPConstants.QNAME_BODY;
    }

    protected QName getHeaderQName() {
        return SOAPConstants.QNAME_HEADER;
    }

    protected QName getHeaderfaultQName() {
        return SOAPConstants.QNAME_HEADERFAULT;
    }

    protected QName getOperationQName() {
        return SOAPConstants.QNAME_OPERATION;
    }

    protected QName getFaultQName() {
        return SOAPConstants.QNAME_FAULT;
    }

    protected QName getAddressQName() {
        return SOAPConstants.QNAME_ADDRESS;
    }

    protected QName getBindingQName() {
        return SOAPConstants.QNAME_BINDING;
    }
}

