/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.writer.ZipCodeWriter;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.tools.internal.xjc.AbortException;
import com.sun.tools.internal.xjc.BadCommandLineException;
import com.sun.tools.internal.xjc.ConsoleErrorReporter;
import com.sun.tools.internal.xjc.Language;
import com.sun.tools.internal.xjc.Messages;
import com.sun.tools.internal.xjc.ModelLoader;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.ProgressCodeWriter;
import com.sun.tools.internal.xjc.XJCListener;
import com.sun.tools.internal.xjc.generator.bean.BeanGenerator;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.outline.Outline;
import com.sun.tools.internal.xjc.reader.gbind.Expression;
import com.sun.tools.internal.xjc.reader.gbind.Graph;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForest;
import com.sun.tools.internal.xjc.reader.xmlschema.ExpressionBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.parser.XMLSchemaInternalizationLogic;
import com.sun.tools.internal.xjc.util.ErrorReceiverFilter;
import com.sun.tools.internal.xjc.util.NullStream;
import com.sun.tools.internal.xjc.util.Util;
import com.sun.tools.internal.xjc.writer.SignatureWriter;
import com.sun.xml.internal.xsom.XSComplexType;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSSchemaSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Iterator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Driver {
    public static void main(final String[] stringArray) throws Exception {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (Util.getSystemProperty(Driver.class, "noThreadSwap") != null) {
            Driver._main(stringArray);
        }
        final Throwable[] throwableArray = new Throwable[1];
        Thread thread = new Thread(){

            public void run() {
                try {
                    Driver._main(stringArray);
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
            }
        };
        thread.start();
        thread.join();
        if (throwableArray[0] != null) {
            if (throwableArray[0] instanceof Exception) {
                throw (Exception)throwableArray[0];
            }
            throw (Error)throwableArray[0];
        }
    }

    private static void _main(String[] stringArray) throws Exception {
        try {
            System.exit(Driver.run(stringArray, System.out, System.out));
        }
        catch (BadCommandLineException badCommandLineException) {
            if (badCommandLineException.getMessage() != null) {
                System.out.println(badCommandLineException.getMessage());
                System.out.println();
            }
            Driver.usage(badCommandLineException.getOptions(), false);
            System.exit(-1);
        }
    }

    public static int run(String[] stringArray, final PrintStream printStream, final PrintStream printStream2) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Listener
        extends XJCListener {
            ConsoleErrorReporter cer;

            Listener() {
                this.cer = new ConsoleErrorReporter(printStream2 == null ? new PrintStream(new NullStream()) : printStream2);
            }

            @Override
            public void generatedFile(String string, int n, int n2) {
                this.message(string);
            }

            @Override
            public void message(String string) {
                if (printStream != null) {
                    printStream.println(string);
                }
            }

            @Override
            public void error(SAXParseException sAXParseException) {
                this.cer.error(sAXParseException);
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) {
                this.cer.fatalError(sAXParseException);
            }

            @Override
            public void warning(SAXParseException sAXParseException) {
                this.cer.warning(sAXParseException);
            }

            @Override
            public void info(SAXParseException sAXParseException) {
                this.cer.info(sAXParseException);
            }
        }
        return Driver.run(stringArray, new Listener());
    }

    public static int run(String[] stringArray, final @NotNull XJCListener xJCListener) throws BadCommandLineException {
        for (String object : stringArray) {
            if (!object.equals("-version")) continue;
            xJCListener.message(Messages.format("Driver.Version", new Object[0]));
            return -1;
        }
        final OptionsEx optionsEx = new OptionsEx();
        optionsEx.setSchemaLanguage(Language.XMLSCHEMA);
        try {
            optionsEx.parseArguments(stringArray);
        }
        catch (WeAreDone weAreDone) {
            return -1;
        }
        catch (BadCommandLineException badCommandLineException) {
            badCommandLineException.initOptions(optionsEx);
            throw badCommandLineException;
        }
        if (optionsEx.defaultPackage != null && optionsEx.defaultPackage.length() == 0) {
            xJCListener.message(Messages.format("Driver.WarningMessage", Messages.format("Driver.DefaultPackageWarning", new Object[0])));
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(optionsEx.getUserClassLoader(classLoader));
        try {
            if (!optionsEx.quiet) {
                xJCListener.message(Messages.format("Driver.ParsingSchema", new Object[0]));
            }
            final boolean[] blArray = new boolean[1];
            ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(xJCListener){

                public void info(SAXParseException sAXParseException) {
                    if (optionsEx.verbose) {
                        super.info(sAXParseException);
                    }
                }

                public void warning(SAXParseException sAXParseException) {
                    blArray[0] = true;
                    if (!optionsEx.quiet) {
                        super.warning(sAXParseException);
                    }
                }

                public void pollAbort() throws AbortException {
                    if (xJCListener.isCanceled()) {
                        throw new AbortException();
                    }
                }
            };
            if (optionsEx.mode == Mode.FOREST) {
                ModelLoader xSSchemaSet = new ModelLoader(optionsEx, new JCodeModel(), errorReceiverFilter);
                try {
                    DOMForest sAXException = xSSchemaSet.buildDOMForest(new XMLSchemaInternalizationLogic());
                    sAXException.dump(System.out);
                    return 0;
                }
                catch (SAXException iOException) {
                }
                catch (IOException iterator) {
                    errorReceiverFilter.error(iterator);
                }
                return -1;
            }
            if (optionsEx.mode == Mode.GBIND) {
                try {
                    XSSchemaSet sAXException = new ModelLoader(optionsEx, new JCodeModel(), errorReceiverFilter).loadXMLSchema();
                    Iterator<XSComplexType> iOException = sAXException.iterateComplexTypes();
                    while (iOException.hasNext()) {
                        XSComplexType outputStream = iOException.next();
                        XSParticle xSParticle = outputStream.getContentType().asParticle();
                        if (xSParticle == null) continue;
                        Expression expression = ExpressionBuilder.createTree(xSParticle);
                        System.out.println("Graph for " + outputStream.getName());
                        System.out.println(expression.toString());
                        Graph graph = new Graph(expression);
                        System.out.println(graph.toString());
                        System.out.println();
                    }
                    return 0;
                }
                catch (SAXException model) {
                    return -1;
                }
            }
            Model model = ModelLoader.load(optionsEx, new JCodeModel(), errorReceiverFilter);
            if (model == null) {
                xJCListener.message(Messages.format("Driver.ParseFailed", new Object[0]));
                return -1;
            }
            if (!optionsEx.quiet) {
                xJCListener.message(Messages.format("Driver.CompilingSchema", new Object[0]));
            }
            switch (optionsEx.mode) {
                case SIGNATURE: {
                    try {
                        SignatureWriter.write(BeanGenerator.generate(model, errorReceiverFilter), new OutputStreamWriter(System.out));
                        return 0;
                    }
                    catch (IOException object2) {
                        errorReceiverFilter.error(object2);
                        return -1;
                    }
                }
                case CODE: 
                case DRYRUN: 
                case ZIP: {
                    errorReceiverFilter.debug("generating code");
                    Object iOException = model.generateCode(optionsEx, errorReceiverFilter);
                    if (iOException == null) {
                        xJCListener.message(Messages.format("Driver.FailedToGenerateCode", new Object[0]));
                        return -1;
                    }
                    xJCListener.compiled((Outline)iOException);
                    if (optionsEx.mode == Mode.DRYRUN) break;
                    try {
                        if (optionsEx.mode == Mode.ZIP) {
                            OutputStream outputStream = optionsEx.targetDir.getPath().equals(".") ? System.out : new FileOutputStream(optionsEx.targetDir);
                            iOException = optionsEx.createCodeWriter(new ZipCodeWriter(outputStream));
                        } else {
                            iOException = optionsEx.createCodeWriter();
                        }
                        if (!optionsEx.quiet) {
                            iOException = new ProgressCodeWriter((CodeWriter)iOException, xJCListener, model.codeModel.countArtifacts());
                        }
                        model.codeModel.build((CodeWriter)iOException);
                        break;
                    }
                    catch (IOException iOException2) {
                        errorReceiverFilter.error(iOException2);
                        return -1;
                    }
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (optionsEx.debugMode) {
                try {
                    new FileOutputStream(new File(optionsEx.targetDir, blArray[0] ? "hadWarning" : "noWarning")).close();
                }
                catch (IOException iOException) {
                    errorReceiverFilter.error(iOException);
                    return -1;
                }
            }
            return 0;
        }
        catch (StackOverflowError stackOverflowError) {
            if (optionsEx.verbose) {
                throw stackOverflowError;
            }
            xJCListener.message(Messages.format("Driver.StackOverflow", new Object[0]));
            return -1;
        }
    }

    public static String getBuildID() {
        return Messages.format("Driver.BuildID", new Object[0]);
    }

    public static void usage(@Nullable Options options, boolean bl) {
        if (bl) {
            System.out.println(Messages.format("Driver.Private.Usage", new Object[0]));
        } else {
            System.out.println(Messages.format("Driver.Public.Usage", new Object[0]));
        }
        if (options != null && options.getAllPlugins().size() != 0) {
            System.out.println(Messages.format("Driver.AddonUsage", new Object[0]));
            for (Plugin plugin : options.getAllPlugins()) {
                System.out.println(plugin.getUsage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        CODE,
        SIGNATURE,
        FOREST,
        DRYRUN,
        ZIP,
        GBIND;

    }

    static class OptionsEx
    extends Options {
        protected Mode mode = Mode.CODE;
        public boolean noNS = false;

        OptionsEx() {
        }

        public int parseArgument(String[] stringArray, int n) throws BadCommandLineException {
            if (stringArray[n].equals("-noNS")) {
                this.noNS = true;
                return 1;
            }
            if (stringArray[n].equals("-mode")) {
                if (++n == stringArray.length) {
                    throw new BadCommandLineException(Messages.format("Driver.MissingModeOperand", new Object[0]));
                }
                String string = stringArray[n].toLowerCase();
                for (Mode mode : Mode.values()) {
                    if (!mode.name().toLowerCase().startsWith(string) || string.length() <= 2) continue;
                    this.mode = mode;
                    return 2;
                }
                throw new BadCommandLineException(Messages.format("Driver.UnrecognizedMode", stringArray[n]));
            }
            if (stringArray[n].equals("-help")) {
                Driver.usage(this, false);
                throw new WeAreDone();
            }
            if (stringArray[n].equals("-private")) {
                Driver.usage(this, true);
                throw new WeAreDone();
            }
            return super.parseArgument(stringArray, n);
        }
    }

    private static final class WeAreDone
    extends BadCommandLineException {
        private WeAreDone() {
        }
    }
}

