/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.api.util;

import com.sun.istack.internal.Nullable;
import com.sun.tools.internal.xjc.api.util.ToolsJarNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public final class APTClassLoader
extends URLClassLoader {
    private final String[] packagePrefixes;

    public APTClassLoader(@Nullable ClassLoader classLoader, String[] stringArray) throws ToolsJarNotFoundException {
        super(APTClassLoader.getToolsJar(classLoader), classLoader);
        this.packagePrefixes = this.getURLs().length == 0 ? new String[0] : stringArray;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        for (String string2 : this.packagePrefixes) {
            if (!string.startsWith(string2)) continue;
            return this.findClass(string);
        }
        return super.loadClass(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6);
        stringBuilder.append(string.replace('.', '/')).append(".class");
        InputStream inputStream = this.getResourceAsStream(stringBuilder.toString());
        if (inputStream == null) {
            throw new ClassNotFoundException("Class not found" + stringBuilder);
        }
        try {
            String string2;
            Package package_;
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1 && (package_ = this.getPackage(string2 = string.substring(0, n2))) == null) {
                this.definePackage(string2, null, null, null, null, null, null, null);
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string, iOException);
        }
    }

    private static URL[] getToolsJar(@Nullable ClassLoader classLoader) throws ToolsJarNotFoundException {
        try {
            Class.forName("com.sun.tools.javac.Main", false, classLoader);
            Class.forName("com.sun.tools.apt.Main", false, classLoader);
            return new URL[0];
        }
        catch (ClassNotFoundException classNotFoundException) {
            File file = new File(System.getProperty("java.home"));
            File file2 = new File(file.getParent(), "lib/tools.jar");
            if (!file2.exists()) {
                throw new ToolsJarNotFoundException(file2);
            }
            try {
                return new URL[]{file2.toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
    }
}

