/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.reader.Messages;
import com.sun.tools.internal.xjc.reader.Ring;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;

public final class ModelChecker {
    private final Model model = Ring.get(Model.class);
    private final ErrorReceiver errorReceiver = Ring.get(ErrorReceiver.class);

    public void check() {
        for (CClassInfo cClassInfo : this.model.beans().values()) {
            this.check(cClassInfo);
        }
    }

    private void check(CClassInfo cClassInfo) {
        List<CPropertyInfo> list = cClassInfo.getProperties();
        HashMap<QName, CPropertyInfo> hashMap = new HashMap<QName, CPropertyInfo>();
        block0: for (int i = 0; i < list.size(); ++i) {
            CPropertyInfo cPropertyInfo = list.get(i);
            if (cPropertyInfo.getName(true).equals("Class")) {
                this.errorReceiver.error(cPropertyInfo.locator, Messages.PROPERTY_CLASS_IS_RESERVED.format(new Object[0]));
                continue;
            }
            QName qName = cPropertyInfo.collectElementNames(hashMap);
            if (qName != null) {
                CPropertyInfo cPropertyInfo2 = (CPropertyInfo)hashMap.get(qName);
                this.errorReceiver.error(cPropertyInfo.locator, Messages.DUPLICATE_ELEMENT.format(qName));
                this.errorReceiver.error(cPropertyInfo2.locator, Messages.ERR_RELEVANT_LOCATION.format(new Object[0]));
            }
            for (int j = i + 1; j < list.size(); ++j) {
                if (this.checkPropertyCollision(cPropertyInfo, list.get(j))) continue block0;
            }
            for (CClassInfo cClassInfo2 = cClassInfo.getBaseClass(); cClassInfo2 != null; cClassInfo2 = cClassInfo2.getBaseClass()) {
                for (CPropertyInfo cPropertyInfo3 : cClassInfo2.getProperties()) {
                    if (!this.checkPropertyCollision(cPropertyInfo, cPropertyInfo3)) continue;
                    continue block0;
                }
            }
        }
    }

    private boolean checkPropertyCollision(CPropertyInfo cPropertyInfo, CPropertyInfo cPropertyInfo2) {
        if (!cPropertyInfo.getName(true).equals(cPropertyInfo2.getName(true))) {
            return false;
        }
        this.errorReceiver.error(cPropertyInfo.locator, Messages.DUPLICATE_PROPERTY.format(cPropertyInfo.getName(true)));
        this.errorReceiver.error(cPropertyInfo2.locator, Messages.ERR_RELEVANT_LOCATION.format(new Object[0]));
        return true;
    }
}

