/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.dtd;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JPackage;
import com.sun.istack.internal.SAXParseException2;
import com.sun.tools.internal.xjc.AbortException;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.model.CAttributePropertyInfo;
import com.sun.tools.internal.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CDefaultValue;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.model.TypeUse;
import com.sun.tools.internal.xjc.model.TypeUseFactory;
import com.sun.tools.internal.xjc.reader.ModelChecker;
import com.sun.tools.internal.xjc.reader.Ring;
import com.sun.tools.internal.xjc.reader.dtd.Element;
import com.sun.tools.internal.xjc.reader.dtd.Messages;
import com.sun.tools.internal.xjc.reader.dtd.ModelGroup;
import com.sun.tools.internal.xjc.reader.dtd.Occurence;
import com.sun.tools.internal.xjc.reader.dtd.Term;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIAttribute;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIElement;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIInterface;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BindInfo;
import com.sun.tools.internal.xjc.util.CodeModelClassFactory;
import com.sun.tools.internal.xjc.util.ErrorReceiverFilter;
import com.sun.xml.internal.bind.api.impl.NameConverter;
import com.sun.xml.internal.dtdparser.DTDHandlerBase;
import com.sun.xml.internal.dtdparser.DTDParser;
import com.sun.xml.internal.dtdparser.InputEntity;
import com.sun.xml.internal.xsom.XmlString;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class TDTDReader
extends DTDHandlerBase {
    private final EntityResolver entityResolver;
    final BindInfo bindInfo;
    final Model model = Ring.get(Model.class);
    private final CodeModelClassFactory classFactory;
    private final ErrorReceiverFilter errorReceiver;
    private final Map<String, Element> elements = new HashMap<String, Element>();
    private final Stack<ModelGroup> modelGroups = new Stack();
    private Locator locator;
    private static final Map<String, TypeUse> builtinConversions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model parse(InputSource inputSource, InputSource inputSource2, ErrorReceiver errorReceiver, Options options) {
        try {
            Ring ring = Ring.begin();
            try {
                ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(errorReceiver);
                JCodeModel jCodeModel = new JCodeModel();
                Model model = new Model(options, jCodeModel, NameConverter.standard, options.classNameAllocator, null);
                Ring.add(jCodeModel);
                Ring.add(model);
                Ring.add(ErrorReceiver.class, errorReceiverFilter);
                TDTDReader tDTDReader = new TDTDReader(errorReceiverFilter, options, inputSource2);
                DTDParser dTDParser = new DTDParser();
                dTDParser.setDtdHandler(tDTDReader);
                if (options.entityResolver != null) {
                    dTDParser.setEntityResolver(options.entityResolver);
                }
                try {
                    dTDParser.parse(inputSource);
                }
                catch (SAXParseException sAXParseException) {
                    Model model2 = null;
                    Ring.end(ring);
                    return model2;
                }
                Ring.get(ModelChecker.class).check();
                if (errorReceiverFilter.hadError()) {
                    Model model3 = null;
                    return model3;
                }
                Model model4 = model;
                return model4;
            }
            finally {
                Ring.end(ring);
            }
        }
        catch (IOException iOException) {
            errorReceiver.error((SAXParseException)new SAXParseException2(iOException.getMessage(), null, (Exception)iOException));
            return null;
        }
        catch (SAXException sAXException) {
            errorReceiver.error((SAXParseException)new SAXParseException2(sAXException.getMessage(), null, (Exception)sAXException));
            return null;
        }
        catch (AbortException abortException) {
            return null;
        }
    }

    protected TDTDReader(ErrorReceiver errorReceiver, Options options, InputSource inputSource) throws AbortException {
        this.entityResolver = options.entityResolver;
        this.errorReceiver = new ErrorReceiverFilter(errorReceiver);
        this.bindInfo = new BindInfo(this.model, inputSource, (ErrorReceiver)this.errorReceiver);
        this.classFactory = new CodeModelClassFactory(errorReceiver);
    }

    public void startDTD(InputEntity inputEntity) throws SAXException {
    }

    public void endDTD() throws SAXException {
        for (Element element : this.elements.values()) {
            element.bind();
        }
        if (this.errorReceiver.hadError()) {
            return;
        }
        this.processInterfaceDeclarations();
        this.model.serialVersionUID = this.bindInfo.getSerialVersionUID();
        if (this.model.serialVersionUID != null) {
            this.model.serializable = true;
        }
        this.model.rootClass = this.bindInfo.getSuperClass();
        this.model.rootInterface = this.bindInfo.getSuperInterface();
        this.processConstructorDeclarations();
    }

    private void processInterfaceDeclarations() {
        Object object;
        HashMap<String, InterfaceAcceptor> hashMap = new HashMap<String, InterfaceAcceptor>();
        HashMap<BIInterface, JDefinedClass> hashMap2 = new HashMap<BIInterface, JDefinedClass>();
        for (BIInterface object2 : this.bindInfo.interfaces()) {
            object = this.classFactory.createInterface(this.bindInfo.getTargetPackage(), object2.name(), this.copyLocator());
            hashMap2.put(object2, (JDefinedClass)object);
            hashMap.put(object2.name(), new InterfaceAcceptor((JDefinedClass)object){
                final /* synthetic */ JDefinedClass val$intf;
                {
                    this.val$intf = jDefinedClass;
                }

                public void implement(JClass jClass) {
                    this.val$intf._implements(jClass);
                }
            });
        }
        for (final CClassInfo cClassInfo : this.model.beans().values()) {
            hashMap.put(cClassInfo.getName(), new InterfaceAcceptor(){

                public void implement(JClass jClass) {
                    cClassInfo._implements(jClass);
                }
            });
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = (BIInterface)entry.getKey();
            JClass jClass = (JClass)entry.getValue();
            for (String string : ((BIInterface)object).members()) {
                InterfaceAcceptor interfaceAcceptor = (InterfaceAcceptor)hashMap.get(string);
                if (interfaceAcceptor == null) {
                    this.error(((BIInterface)object).getSourceLocation(), "TDTDReader.BindInfo.NonExistentInterfaceMember", string);
                    continue;
                }
                interfaceAcceptor.implement(jClass);
            }
        }
    }

    JPackage getTargetPackage() {
        return this.bindInfo.getTargetPackage();
    }

    private void processConstructorDeclarations() {
        for (BIElement bIElement : this.bindInfo.elements()) {
            Element element = this.elements.get(bIElement.name());
            if (element == null) {
                this.error(bIElement.getSourceLocation(), "TDTDReader.BindInfo.NonExistentElementDeclaration", bIElement.name());
                continue;
            }
            if (!bIElement.isClass()) continue;
            bIElement.declareConstructors(element.getClassInfo());
        }
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, short s, String string4) throws SAXException {
        this.getOrCreateElement((String)string).attributes.add(this.createAttribute(string, string2, string3, stringArray, s, string4));
    }

    protected CPropertyInfo createAttribute(String string, String string2, String string3, String[] stringArray, short s, String string4) throws SAXException {
        boolean bl = s == 3;
        BIElement bIElement = this.bindInfo.element(string);
        BIAttribute bIAttribute = null;
        if (bIElement != null) {
            bIAttribute = bIElement.attribute(string2);
        }
        String string5 = bIAttribute == null ? this.model.getNameConverter().toPropertyName(string2) : bIAttribute.getPropertyName();
        QName qName = new QName("", string2);
        TypeUse typeUse = bIAttribute != null && bIAttribute.getConversion() != null ? bIAttribute.getConversion().getTransducer() : builtinConversions.get(string3);
        CAttributePropertyInfo cAttributePropertyInfo = new CAttributePropertyInfo(string5, null, null, this.copyLocator(), qName, typeUse, null, bl);
        if (string4 != null) {
            cAttributePropertyInfo.defaultValue = CDefaultValue.create(typeUse, new XmlString(string4));
        }
        return cAttributePropertyInfo;
    }

    Element getOrCreateElement(String string) {
        Element element = this.elements.get(string);
        if (element == null) {
            element = new Element(this, string);
            this.elements.put(string, element);
        }
        return element;
    }

    public void startContentModel(String string, short s) throws SAXException {
        assert (this.modelGroups.isEmpty());
        this.modelGroups.push(new ModelGroup());
    }

    public void endContentModel(String string, short s) throws SAXException {
        assert (this.modelGroups.size() == 1);
        Term term = this.modelGroups.pop().wrapUp();
        Element element = this.getOrCreateElement(string);
        element.define(s, term, this.copyLocator());
    }

    public void startModelGroup() throws SAXException {
        this.modelGroups.push(new ModelGroup());
    }

    public void endModelGroup(short s) throws SAXException {
        Term term = Occurence.wrap(this.modelGroups.pop().wrapUp(), s);
        this.modelGroups.peek().addTerm(term);
    }

    public void connector(short s) throws SAXException {
        this.modelGroups.peek().setKind(s);
    }

    public void childElement(String string, short s) throws SAXException {
        Element element = this.getOrCreateElement(string);
        this.modelGroups.peek().addTerm(Occurence.wrap(element, s));
        element.isReferenced = true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private Locator copyLocator() {
        return new LocatorImpl(this.locator);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.errorReceiver.error(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errorReceiver.fatalError(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.errorReceiver.warning(sAXParseException);
    }

    protected final void error(Locator locator, String string, Object ... objectArray) {
        this.errorReceiver.error(locator, Messages.format(string, objectArray));
    }

    static {
        HashMap<String, TypeUse> hashMap = new HashMap<String, TypeUse>();
        hashMap.put("CDATA", CBuiltinLeafInfo.NORMALIZED_STRING);
        hashMap.put("ENTITY", CBuiltinLeafInfo.TOKEN);
        hashMap.put("ENTITIES", CBuiltinLeafInfo.STRING.makeCollection());
        hashMap.put("NMTOKEN", CBuiltinLeafInfo.TOKEN);
        hashMap.put("NMTOKENS", CBuiltinLeafInfo.STRING.makeCollection());
        hashMap.put("ID", CBuiltinLeafInfo.ID);
        hashMap.put("IDREF", CBuiltinLeafInfo.IDREF);
        hashMap.put("IDREFS", TypeUseFactory.makeCollection(CBuiltinLeafInfo.IDREF));
        hashMap.put("ENUMERATION", CBuiltinLeafInfo.TOKEN);
        builtinConversions = Collections.unmodifiableMap(hashMap);
    }

    private static interface InterfaceAcceptor {
        public void implement(JClass var1);
    }
}

