/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.dtd.bindinfo;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JPackage;
import com.sun.istack.internal.SAXParseException2;
import com.sun.tools.internal.xjc.AbortException;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.SchemaCache;
import com.sun.tools.internal.xjc.model.CCustomizations;
import com.sun.tools.internal.xjc.model.CPluginCustomization;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIConversion;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIElement;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIEnumeration;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIInterface;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.BIUserConversion;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.DOMBuilder;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.DOMLocator;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.DOMUtil;
import com.sun.tools.internal.xjc.reader.dtd.bindinfo.DTDExtensionBindingChecker;
import com.sun.tools.internal.xjc.util.CodeModelClassFactory;
import com.sun.tools.internal.xjc.util.ErrorReceiverFilter;
import com.sun.tools.internal.xjc.util.ForkContentHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindInfo {
    protected final ErrorReceiver errorReceiver;
    final Model model;
    private final String defaultPackage;
    final JCodeModel codeModel;
    final CodeModelClassFactory classFactory;
    private final Element dom;
    private final Map<String, BIConversion> conversions = new HashMap<String, BIConversion>();
    private final Map<String, BIElement> elements = new HashMap<String, BIElement>();
    private final Map<String, BIInterface> interfaces = new HashMap<String, BIInterface>();
    private static final String XJC_NS = "http://java.sun.com/xml/ns/jaxb/xjc";
    private static SchemaCache bindingFileSchema = new SchemaCache(BindInfo.class.getResource("bindingfile.xsd"));

    public BindInfo(Model model, InputSource inputSource, ErrorReceiver errorReceiver) throws AbortException {
        this(model, BindInfo.parse(model, inputSource, errorReceiver), errorReceiver);
    }

    public BindInfo(Model model, Document document, ErrorReceiver errorReceiver) {
        Object object;
        this.model = model;
        this.dom = document.getDocumentElement();
        this.codeModel = model.codeModel;
        this.errorReceiver = errorReceiver;
        this.classFactory = new CodeModelClassFactory(errorReceiver);
        this.defaultPackage = model.options.defaultPackage;
        model.getCustomizations().addAll(this.getGlobalCustomizations());
        for (Element element : DOMUtil.getChildElements(this.dom, "element")) {
            object = new BIElement(this, element);
            this.elements.put(((BIElement)object).name(), (BIElement)object);
        }
        BIUserConversion.addBuiltinConversions(this, this.conversions);
        for (Element element : DOMUtil.getChildElements(this.dom, "conversion")) {
            object = new BIUserConversion(this, element);
            this.conversions.put(object.name(), (BIConversion)object);
        }
        for (Element element : DOMUtil.getChildElements(this.dom, "enumeration")) {
            object = BIEnumeration.create(element, this);
            this.conversions.put(object.name(), (BIConversion)object);
        }
        for (Element element : DOMUtil.getChildElements(this.dom, "interface")) {
            object = new BIInterface(element);
            this.interfaces.put(((BIInterface)object).name(), (BIInterface)object);
        }
    }

    public Long getSerialVersionUID() {
        Element element = DOMUtil.getElement(this.dom, XJC_NS, "serializable");
        if (element == null) {
            return null;
        }
        String string = DOMUtil.getAttribute(element, "uid");
        if (string == null) {
            string = "1";
        }
        return new Long(string);
    }

    public JClass getSuperClass() {
        JDefinedClass jDefinedClass;
        Element element = DOMUtil.getElement(this.dom, XJC_NS, "superClass");
        if (element == null) {
            return null;
        }
        try {
            String string = DOMUtil.getAttribute(element, "name");
            if (string == null) {
                return null;
            }
            jDefinedClass = this.codeModel._class(string);
            jDefinedClass.hide();
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            jDefinedClass = jClassAlreadyExistsException.getExistingClass();
        }
        return jDefinedClass;
    }

    public JClass getSuperInterface() {
        JDefinedClass jDefinedClass;
        Element element = DOMUtil.getElement(this.dom, XJC_NS, "superInterface");
        if (element == null) {
            return null;
        }
        String string = DOMUtil.getAttribute(element, "name");
        if (string == null) {
            return null;
        }
        try {
            jDefinedClass = this.codeModel._class(string, ClassType.INTERFACE);
            jDefinedClass.hide();
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            jDefinedClass = jClassAlreadyExistsException.getExistingClass();
        }
        return jDefinedClass;
    }

    public JPackage getTargetPackage() {
        if (this.model.options.defaultPackage != null) {
            return this.codeModel._package(this.model.options.defaultPackage);
        }
        String string = this.defaultPackage != null ? this.defaultPackage : this.getOption("package", "");
        return this.codeModel._package(string);
    }

    public BIConversion conversion(String string) {
        BIConversion bIConversion = this.conversions.get(string);
        if (bIConversion == null) {
            throw new AssertionError((Object)"undefined conversion name: this should be checked by the validator before we read it");
        }
        return bIConversion;
    }

    public BIElement element(String string) {
        return this.elements.get(string);
    }

    public Collection<BIElement> elements() {
        return this.elements.values();
    }

    public Collection<BIInterface> interfaces() {
        return this.interfaces.values();
    }

    private CCustomizations getGlobalCustomizations() {
        CCustomizations cCustomizations = null;
        for (Element element : DOMUtil.getChildElements(this.dom)) {
            if (!this.model.options.pluginURIs.contains(element.getNamespaceURI())) continue;
            if (cCustomizations == null) {
                cCustomizations = new CCustomizations();
            }
            cCustomizations.add(new CPluginCustomization(element, DOMLocator.getLocationInfo(element)));
        }
        if (cCustomizations == null) {
            cCustomizations = CCustomizations.EMPTY;
        }
        return new CCustomizations(cCustomizations);
    }

    private String getOption(String string, String string2) {
        String string3;
        Element element = DOMUtil.getElement(this.dom, "options");
        if (element != null && (string3 = DOMUtil.getAttribute(element, string)) != null) {
            return string3;
        }
        return string2;
    }

    private static Document parse(Model model, InputSource inputSource, ErrorReceiver errorReceiver) throws AbortException {
        try {
            ValidatorHandler validatorHandler = bindingFileSchema.newValidator();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            DOMBuilder dOMBuilder = new DOMBuilder();
            ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(errorReceiver);
            validatorHandler.setErrorHandler(errorReceiverFilter);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            xMLReader.setErrorHandler(errorReceiverFilter);
            DTDExtensionBindingChecker dTDExtensionBindingChecker = new DTDExtensionBindingChecker("", model.options, errorReceiverFilter);
            dTDExtensionBindingChecker.setContentHandler(validatorHandler);
            xMLReader.setContentHandler(new ForkContentHandler(dTDExtensionBindingChecker, (ContentHandler)((Object)dOMBuilder)));
            xMLReader.parse(inputSource);
            if (errorReceiverFilter.hadError()) {
                throw new AbortException();
            }
            return (Document)dOMBuilder.getDOM();
        }
        catch (IOException iOException) {
            errorReceiver.error((SAXParseException)new SAXParseException2(iOException.getMessage(), null, (Exception)iOException));
        }
        catch (SAXException sAXException) {
            errorReceiver.error((SAXParseException)new SAXParseException2(sAXException.getMessage(), null, (Exception)sAXException));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            errorReceiver.error((SAXParseException)new SAXParseException2(parserConfigurationException.getMessage(), null, (Exception)parserConfigurationException));
        }
        throw new AbortException();
    }
}

