/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.internalizer;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.XMLStreamReaderToContentHandler;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.reader.internalizer.ContentHandlerNamespacePrefixAdapter;
import com.sun.tools.internal.xjc.reader.internalizer.DOMBuilder;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForestParser;
import com.sun.tools.internal.xjc.reader.internalizer.InternalizationLogic;
import com.sun.tools.internal.xjc.reader.internalizer.Internalizer;
import com.sun.tools.internal.xjc.reader.internalizer.LocatorTable;
import com.sun.tools.internal.xjc.reader.internalizer.Messages;
import com.sun.tools.internal.xjc.reader.internalizer.SCDBasedBindingSet;
import com.sun.tools.internal.xjc.reader.internalizer.VersionChecker;
import com.sun.tools.internal.xjc.reader.internalizer.WhitespaceStripper;
import com.sun.tools.internal.xjc.util.ErrorReceiverFilter;
import com.sun.xml.internal.bind.marshaller.DataWriter;
import com.sun.xml.internal.xsom.parser.JAXPParser;
import com.sun.xml.internal.xsom.parser.XMLParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMForest {
    private final Map<String, Document> core = new HashMap<String, Document>();
    private final Set<String> rootDocuments = new HashSet<String>();
    public final LocatorTable locatorTable = new LocatorTable();
    public final Set<Element> outerMostBindings = new HashSet<Element>();
    private EntityResolver entityResolver = null;
    private ErrorReceiver errorReceiver = null;
    protected final InternalizationLogic logic;
    private final SAXParserFactory parserFactory;
    private final DocumentBuilder documentBuilder;

    public DOMForest(SAXParserFactory sAXParserFactory, DocumentBuilder documentBuilder, InternalizationLogic internalizationLogic) {
        this.parserFactory = sAXParserFactory;
        this.documentBuilder = documentBuilder;
        this.logic = internalizationLogic;
    }

    public DOMForest(InternalizationLogic internalizationLogic) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.parserFactory = SAXParserFactory.newInstance();
            this.parserFactory.setNamespaceAware(true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
        this.logic = internalizationLogic;
    }

    public Document get(String string) {
        Document document = this.core.get(string);
        if (document == null && string.startsWith("file:/") && !string.startsWith("file://")) {
            document = this.core.get("file://" + string.substring(5));
        }
        if (document == null && string.startsWith("file:")) {
            String string2 = this.getPath(string);
            for (String string3 : this.core.keySet()) {
                if (!string3.startsWith("file:") || !this.getPath(string3).equalsIgnoreCase(string2)) continue;
                document = this.core.get(string3);
                break;
            }
        }
        return document;
    }

    private String getPath(String string) {
        string = string.substring(5);
        while (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    public Set<String> getRootDocuments() {
        return Collections.unmodifiableSet(this.rootDocuments);
    }

    public Document getOneDocument() {
        for (Document document : this.core.values()) {
            if (document.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb")) continue;
            return document;
        }
        throw new AssertionError();
    }

    public boolean checkSchemaCorrectness(ErrorReceiver errorReceiver) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(errorReceiver);
            schemaFactory.setErrorHandler(errorReceiverFilter);
            Set<String> set = this.getRootDocuments();
            Source[] sourceArray = new Source[set.size()];
            int n = 0;
            for (String string : set) {
                sourceArray[n++] = new DOMSource(this.get(string), string);
            }
            schemaFactory.newSchema(sourceArray);
            return !errorReceiverFilter.hadError();
        }
        catch (SAXException sAXException) {
            return false;
        }
    }

    public String getSystemId(Document document) {
        for (Map.Entry<String, Document> entry : this.core.entrySet()) {
            if (entry.getValue() != document) continue;
            return entry.getKey();
        }
        return null;
    }

    public Document parse(InputSource inputSource, boolean bl) throws SAXException {
        if (inputSource.getSystemId() == null) {
            throw new IllegalArgumentException();
        }
        return this.parse(inputSource.getSystemId(), inputSource, bl);
    }

    public Document parse(String string, boolean bl) throws SAXException, IOException {
        if (this.core.containsKey(string = this.normalizeSystemId(string))) {
            return this.core.get(string);
        }
        InputSource inputSource = null;
        if (this.entityResolver != null) {
            inputSource = this.entityResolver.resolveEntity(null, string);
        }
        if (inputSource == null) {
            inputSource = new InputSource(string);
        }
        return this.parse(string, inputSource, bl);
    }

    private ContentHandler getParserHandler(Document document) {
        Object object = new DOMBuilder(document, this.locatorTable, this.outerMostBindings);
        object = new WhitespaceStripper((ContentHandler)object, this.errorReceiver, this.entityResolver);
        object = new VersionChecker((ContentHandler)object, this.errorReceiver, this.entityResolver);
        XMLFilterImpl xMLFilterImpl = this.logic.createExternalReferenceFinder(this);
        xMLFilterImpl.setContentHandler((ContentHandler)object);
        if (this.errorReceiver != null) {
            xMLFilterImpl.setErrorHandler(this.errorReceiver);
        }
        if (this.entityResolver != null) {
            xMLFilterImpl.setEntityResolver(this.entityResolver);
        }
        return xMLFilterImpl;
    }

    public Handler getParserHandler(String string, boolean bl) {
        final Document document = this.documentBuilder.newDocument();
        this.core.put(string, document);
        if (bl) {
            this.rootDocuments.add(string);
        }
        ContentHandler contentHandler = this.getParserHandler(document);
        HandlerImpl handlerImpl = new HandlerImpl(){

            public Document getDocument() {
                return document;
            }
        };
        handlerImpl.setContentHandler(contentHandler);
        return handlerImpl;
    }

    public Document parse(String string, InputSource inputSource, boolean bl) throws SAXException {
        Document document = this.documentBuilder.newDocument();
        string = this.normalizeSystemId(string);
        this.core.put(string, document);
        if (bl) {
            this.rootDocuments.add(string);
        }
        try {
            XMLReader xMLReader = this.parserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this.getParserHandler(document));
            if (this.errorReceiver != null) {
                xMLReader.setErrorHandler(this.errorReceiver);
            }
            if (this.entityResolver != null) {
                xMLReader.setEntityResolver(this.entityResolver);
            }
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorReceiver.error(parserConfigurationException.getMessage(), parserConfigurationException);
            this.core.remove(string);
            this.rootDocuments.remove(string);
            return null;
        }
        catch (IOException iOException) {
            this.errorReceiver.error(iOException.getMessage(), iOException);
            this.core.remove(string);
            this.rootDocuments.remove(string);
            return null;
        }
        return document;
    }

    private String normalizeSystemId(String string) {
        try {
            string = new URI(string).normalize().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return string;
    }

    public Document parse(String string, XMLStreamReader xMLStreamReader, boolean bl) throws XMLStreamException {
        Document document = this.documentBuilder.newDocument();
        string = this.normalizeSystemId(string);
        if (bl) {
            this.rootDocuments.add(string);
        }
        if (string == null) {
            throw new IllegalArgumentException("system id cannot be null");
        }
        this.core.put(string, document);
        new XMLStreamReaderToContentHandler(xMLStreamReader, this.getParserHandler(document), false, false).bridge();
        return document;
    }

    public SCDBasedBindingSet transform(boolean bl) {
        return Internalizer.transform(this, bl);
    }

    public void weakSchemaCorrectnessCheck(SchemaFactory schemaFactory) {
        ArrayList<SAXSource> arrayList = new ArrayList<SAXSource>();
        for (String string : this.getRootDocuments()) {
            Document document = this.get(string);
            if (document.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb")) continue;
            SAXSource sAXSource = this.createSAXSource(string);
            try {
                sAXSource.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException sAXException) {
                throw new AssertionError((Object)sAXException);
            }
            arrayList.add(sAXSource);
        }
        try {
            schemaFactory.newSchema(arrayList.toArray(new SAXSource[0]));
        }
        catch (SAXException sAXException) {
        }
        catch (RuntimeException runtimeException) {
            try {
                schemaFactory.getErrorHandler().warning(new SAXParseException(Messages.format("ERR_GENERAL_SCHEMA_CORRECTNESS_ERROR", runtimeException.getMessage()), null, null, -1, -1, runtimeException));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public SAXSource createSAXSource(String string) {
        ContentHandlerNamespacePrefixAdapter contentHandlerNamespacePrefixAdapter = new ContentHandlerNamespacePrefixAdapter(new XMLFilterImpl(){

            public void parse(InputSource inputSource) throws SAXException, IOException {
                DOMForest.this.createParser().parse(inputSource, this, this, this);
            }

            public void parse(String string) throws SAXException, IOException {
                this.parse(new InputSource(string));
            }
        });
        return new SAXSource(contentHandlerNamespacePrefixAdapter, new InputSource(string));
    }

    public XMLParser createParser() {
        return new DOMForestParser(this, new JAXPParser());
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorReceiver getErrorHandler() {
        return this.errorReceiver;
    }

    public void setErrorHandler(ErrorReceiver errorReceiver) {
        this.errorReceiver = errorReceiver;
    }

    public Document[] listDocuments() {
        return this.core.values().toArray(new Document[this.core.size()]);
    }

    public String[] listSystemIDs() {
        return this.core.keySet().toArray(new String[this.core.keySet().size()]);
    }

    public void dump(OutputStream outputStream) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            for (Map.Entry<String, Document> entry : this.core.entrySet()) {
                outputStream.write(("---<< " + entry.getKey() + '\n').getBytes());
                DataWriter dataWriter = new DataWriter((Writer)new OutputStreamWriter(outputStream), null);
                dataWriter.setIndentStep("  ");
                transformer.transform(new DOMSource(entry.getValue()), new SAXResult((ContentHandler)dataWriter));
                outputStream.write("\n\n\n".getBytes());
            }
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    public static interface Handler
    extends ContentHandler {
        public Document getDocument();
    }

    private static abstract class HandlerImpl
    extends XMLFilterImpl
    implements Handler {
        private HandlerImpl() {
        }
    }
}

