/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.internalizer;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.SAXParseException2;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForest;
import com.sun.tools.internal.xjc.reader.internalizer.DOMForestScanner;
import com.sun.tools.internal.xjc.reader.internalizer.Messages;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.tools.internal.xjc.util.DOMUtils;
import com.sun.tools.internal.xjc.util.ForkContentHandler;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import com.sun.xml.internal.xsom.SCD;
import com.sun.xml.internal.xsom.XSAnnotation;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSSchemaSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SCDBasedBindingSet {
    private Target topLevel;
    private final DOMForest forest;
    private ErrorReceiver errorReceiver;
    private UnmarshallerHandler unmarshaller;
    private ForkContentHandler loader;

    SCDBasedBindingSet(DOMForest dOMForest) {
        this.forest = dOMForest;
    }

    Target createNewTarget(Target target, Element element, SCD sCD) {
        return new Target(target, element, sCD);
    }

    public void apply(XSSchemaSet xSSchemaSet, ErrorReceiver errorReceiver) {
        if (this.topLevel != null) {
            this.errorReceiver = errorReceiver;
            UnmarshallerImpl unmarshallerImpl = BindInfo.getJAXBContext().createUnmarshaller();
            this.unmarshaller = unmarshallerImpl.getUnmarshallerHandler();
            ValidatorHandler validatorHandler = BindInfo.bindingFileSchema.newValidator();
            validatorHandler.setErrorHandler(errorReceiver);
            this.loader = new ForkContentHandler(validatorHandler, (ContentHandler)this.unmarshaller);
            this.topLevel.applyAll(xSSchemaSet.getSchemas());
            this.loader = null;
            this.unmarshaller = null;
            this.errorReceiver = null;
        }
    }

    private void reportError(Element element, String string) {
        this.reportError(element, string, null);
    }

    private void reportError(Element element, String string, Exception exception) {
        SAXParseException2 sAXParseException2 = new SAXParseException2(string, this.forest.locatorTable.getStartLocation(element), exception);
        this.errorReceiver.error((SAXParseException)sAXParseException2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Target {
        private Target firstChild;
        private final Target nextSibling;
        @NotNull
        private final SCD scd;
        @NotNull
        private final Element src;
        private final List<Element> bindings = new ArrayList<Element>();

        private Target(Target target, Element element, SCD sCD) {
            if (target == null) {
                this.nextSibling = SCDBasedBindingSet.this.topLevel;
                SCDBasedBindingSet.this.topLevel = this;
            } else {
                this.nextSibling = target.firstChild;
                target.firstChild = this;
            }
            this.src = element;
            this.scd = sCD;
        }

        void addBinidng(Element element) {
            this.bindings.add(element);
        }

        private void applyAll(Collection<? extends XSComponent> collection) {
            Target target = this;
            while (target != null) {
                target.apply(collection);
                target = target.nextSibling;
            }
        }

        private void apply(Collection<? extends XSComponent> collection) {
            Collection<XSComponent> collection2 = this.scd.select(collection);
            if (collection2.isEmpty()) {
                if (this.src.getAttributeNode("if-exists") != null) {
                    return;
                }
                SCDBasedBindingSet.this.reportError(this.src, Messages.format("ERR_SCD_EVALUATED_EMPTY", this.scd));
                return;
            }
            if (this.firstChild != null) {
                this.firstChild.applyAll(collection2);
            }
            if (!this.bindings.isEmpty()) {
                Iterator<XSComponent> iterator = collection2.iterator();
                XSComponent xSComponent = iterator.next();
                if (iterator.hasNext()) {
                    SCDBasedBindingSet.this.reportError(this.src, Messages.format("ERR_SCD_MATCHED_MULTIPLE_NODES", this.scd, collection2.size()));
                    SCDBasedBindingSet.this.errorReceiver.error(xSComponent.getLocator(), Messages.format("ERR_SCD_MATCHED_MULTIPLE_NODES_FIRST", new Object[0]));
                    SCDBasedBindingSet.this.errorReceiver.error(iterator.next().getLocator(), Messages.format("ERR_SCD_MATCHED_MULTIPLE_NODES_SECOND", new Object[0]));
                }
                for (Element element : this.bindings) {
                    for (Element element2 : DOMUtils.getChildElements(element)) {
                        String string = element2.getLocalName();
                        if ("bindings".equals(string)) continue;
                        try {
                            new DOMForestScanner(SCDBasedBindingSet.this.forest).scan(element2, (ContentHandler)SCDBasedBindingSet.this.loader);
                            BIDeclaration bIDeclaration = (BIDeclaration)SCDBasedBindingSet.this.unmarshaller.getResult();
                            XSAnnotation xSAnnotation = xSComponent.getAnnotation(true);
                            BindInfo bindInfo = (BindInfo)xSAnnotation.getAnnotation();
                            if (bindInfo == null) {
                                bindInfo = new BindInfo();
                                xSAnnotation.setAnnotation(bindInfo);
                            }
                            bindInfo.addDecl(bIDeclaration);
                        }
                        catch (SAXException sAXException) {
                        }
                        catch (JAXBException jAXBException) {
                            throw new AssertionError((Object)jAXBException);
                        }
                    }
                }
            }
        }
    }
}

