/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.relaxng;

import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JPackage;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CClassInfoParent;
import com.sun.tools.internal.xjc.model.CEnumConstant;
import com.sun.tools.internal.xjc.model.CEnumLeafInfo;
import com.sun.tools.internal.xjc.model.CNonElement;
import com.sun.tools.internal.xjc.model.CTypeInfo;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.reader.relaxng.ContentModelBinder;
import com.sun.tools.internal.xjc.reader.relaxng.DatatypeLib;
import com.sun.tools.internal.xjc.reader.relaxng.DefineFinder;
import com.sun.tools.internal.xjc.reader.relaxng.TypeUseBinder;
import com.sun.xml.internal.bind.api.impl.NameConverter;
import com.sun.xml.internal.rngom.digested.DChoicePattern;
import com.sun.xml.internal.rngom.digested.DDefine;
import com.sun.xml.internal.rngom.digested.DElementPattern;
import com.sun.xml.internal.rngom.digested.DPattern;
import com.sun.xml.internal.rngom.digested.DPatternWalker;
import com.sun.xml.internal.rngom.digested.DRefPattern;
import com.sun.xml.internal.rngom.digested.DValuePattern;
import com.sun.xml.internal.rngom.nc.NameClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public final class RELAXNGCompiler {
    final DPattern grammar;
    final Set<DDefine> defs;
    final Options opts;
    final Model model;
    final JPackage pkg;
    final Map<String, DatatypeLib> datatypes = new HashMap<String, DatatypeLib>();
    final Map<DPattern, CTypeInfo[]> classes = new HashMap<DPattern, CTypeInfo[]>();
    final Map<CClassInfo, DPattern> bindQueue = new HashMap<CClassInfo, DPattern>();
    final TypeUseBinder typeUseBinder = new TypeUseBinder(this);

    public static Model build(DPattern dPattern, JCodeModel jCodeModel, Options options) {
        RELAXNGCompiler rELAXNGCompiler = new RELAXNGCompiler(dPattern, jCodeModel, options);
        rELAXNGCompiler.compile();
        return rELAXNGCompiler.model;
    }

    public RELAXNGCompiler(DPattern dPattern, JCodeModel jCodeModel, Options options) {
        this.grammar = dPattern;
        this.opts = options;
        this.model = new Model(options, jCodeModel, NameConverter.smart, options.classNameAllocator, null);
        this.datatypes.put("", DatatypeLib.BUILTIN);
        this.datatypes.put("http://www.w3.org/2001/XMLSchema-datatypes", DatatypeLib.XMLSCHEMA);
        DefineFinder defineFinder = new DefineFinder();
        dPattern.accept(defineFinder);
        this.defs = defineFinder.defs;
        this.pkg = options.defaultPackage2 != null ? jCodeModel._package(options.defaultPackage2) : (options.defaultPackage != null ? jCodeModel._package(options.defaultPackage) : jCodeModel.rootPackage());
    }

    private void compile() {
        this.promoteElementDefsToClasses();
        this.promoteTypeSafeEnums();
        this.promoteTypePatternsToClasses();
        for (Map.Entry<CClassInfo, DPattern> entry : this.bindQueue.entrySet()) {
            this.bindContentModel(entry.getKey(), entry.getValue());
        }
    }

    private void bindContentModel(CClassInfo cClassInfo, DPattern dPattern) {
        dPattern.accept(new ContentModelBinder(this, cClassInfo));
    }

    private void promoteTypeSafeEnums() {
        ArrayList<CEnumConstant> arrayList = new ArrayList<CEnumConstant>();
        block0: for (DDefine dDefine : this.defs) {
            Object object;
            Object object22;
            DPattern dPattern = dDefine.getPattern();
            if (!(dPattern instanceof DChoicePattern)) continue;
            DChoicePattern dChoicePattern = (DChoicePattern)dPattern;
            arrayList.clear();
            DValuePattern dValuePattern = null;
            for (Object object22 : dChoicePattern) {
                if (!(object22 instanceof DValuePattern)) continue block0;
                object = (DValuePattern)object22;
                if (dValuePattern == null) {
                    dValuePattern = object;
                } else if (!dValuePattern.getDatatypeLibrary().equals(((DValuePattern)object).getDatatypeLibrary()) || !dValuePattern.getType().equals(((DValuePattern)object).getType())) continue block0;
                arrayList.add(new CEnumConstant(this.model.getNameConverter().toConstantName(((DValuePattern)object).getValue()), null, ((DValuePattern)object).getValue(), ((DPattern)object).getLocation()));
            }
            if (arrayList.isEmpty()) continue;
            Object object3 = CBuiltinLeafInfo.STRING;
            object22 = this.datatypes.get(dValuePattern.getNs());
            if (object22 != null && (object = ((DatatypeLib)object22).get(dValuePattern.getType())) instanceof CNonElement) {
                object3 = (CNonElement)object;
            }
            object = new CEnumLeafInfo(this.model, null, new CClassInfoParent.Package(this.pkg), dDefine.getName(), (CNonElement)object3, new ArrayList<CEnumConstant>(arrayList), null, null, dChoicePattern.getLocation());
            this.classes.put(dChoicePattern, new CTypeInfo[]{object});
        }
    }

    private void promoteElementDefsToClasses() {
        for (DDefine dDefine : this.defs) {
            DPattern dPattern = dDefine.getPattern();
            if (!(dPattern instanceof DElementPattern)) continue;
            DElementPattern dElementPattern = (DElementPattern)dPattern;
            this.mapToClass(dElementPattern);
        }
        this.grammar.accept(new DPatternWalker(){

            public Void onRef(DRefPattern dRefPattern) {
                return null;
            }

            public Void onElement(DElementPattern dElementPattern) {
                RELAXNGCompiler.this.mapToClass(dElementPattern);
                return null;
            }
        });
    }

    private void mapToClass(DElementPattern dElementPattern) {
        NameClass nameClass = dElementPattern.getName();
        if (nameClass.isOpen()) {
            return;
        }
        Set<QName> set = nameClass.listNames();
        CClassInfo[] cClassInfoArray = new CClassInfo[set.size()];
        int n = 0;
        for (QName qName : set) {
            String string = this.model.getNameConverter().toClassName(qName.getLocalPart());
            int n2 = n++;
            CClassInfo cClassInfo = new CClassInfo(this.model, this.pkg, string, dElementPattern.getLocation(), null, qName, null, null);
            cClassInfoArray[n2] = cClassInfo;
            this.bindQueue.put(cClassInfo, dElementPattern.getChild());
        }
        this.classes.put(dElementPattern, cClassInfoArray);
    }

    private void promoteTypePatternsToClasses() {
    }
}

