/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema;

import com.sun.tools.internal.xjc.reader.Ring;
import com.sun.tools.internal.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.BindingComponent;
import com.sun.tools.internal.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.xml.internal.xsom.XSAnnotation;
import com.sun.xml.internal.xsom.XSAttContainer;
import com.sun.xml.internal.xsom.XSAttGroupDecl;
import com.sun.xml.internal.xsom.XSAttributeDecl;
import com.sun.xml.internal.xsom.XSAttributeUse;
import com.sun.xml.internal.xsom.XSComplexType;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSContentType;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSFacet;
import com.sun.xml.internal.xsom.XSIdentityConstraint;
import com.sun.xml.internal.xsom.XSListSimpleType;
import com.sun.xml.internal.xsom.XSModelGroup;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSNotation;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSRestrictionSimpleType;
import com.sun.xml.internal.xsom.XSSchema;
import com.sun.xml.internal.xsom.XSSchemaSet;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XSUnionSimpleType;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.XSXPath;
import com.sun.xml.internal.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.internal.xsom.visitor.XSVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnusedCustomizationChecker
extends BindingComponent
implements XSVisitor,
XSSimpleTypeVisitor {
    private final BGMBuilder builder = Ring.get(BGMBuilder.class);
    private final SimpleTypeBuilder stb = Ring.get(SimpleTypeBuilder.class);
    private final Set<XSComponent> visitedComponents = new HashSet<XSComponent>();

    UnusedCustomizationChecker() {
    }

    void run() {
        for (XSSchema xSSchema : Ring.get(XSSchemaSet.class).getSchemas()) {
            this.schema(xSSchema);
            this.run(xSSchema.getAttGroupDecls());
            this.run(xSSchema.getAttributeDecls());
            this.run(xSSchema.getComplexTypes());
            this.run(xSSchema.getElementDecls());
            this.run(xSSchema.getModelGroupDecls());
            this.run(xSSchema.getNotations());
            this.run(xSSchema.getSimpleTypes());
        }
    }

    private void run(Map<String, ? extends XSComponent> map) {
        for (XSComponent xSComponent : map.values()) {
            xSComponent.visit(this);
        }
    }

    private boolean check(XSComponent xSComponent) {
        if (!this.visitedComponents.add(xSComponent)) {
            return false;
        }
        for (BIDeclaration bIDeclaration : this.builder.getBindInfo(xSComponent).getDecls()) {
            this.check(bIDeclaration, xSComponent);
        }
        this.checkExpectedContentTypes(xSComponent);
        return true;
    }

    private void checkExpectedContentTypes(XSComponent xSComponent) {
        if (xSComponent.getForeignAttribute("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes") == null) {
            return;
        }
        if (xSComponent instanceof XSParticle) {
            return;
        }
        if (!this.stb.isAcknowledgedXmimeContentTypes(xSComponent)) {
            this.getErrorReporter().warning(xSComponent.getLocator(), "UnusedCustomizationChecker.WarnUnusedExpectedContentTypes", new Object[0]);
        }
    }

    private void check(BIDeclaration bIDeclaration, XSComponent xSComponent) {
        if (!bIDeclaration.isAcknowledged()) {
            this.getErrorReporter().error(bIDeclaration.getLocation(), "UnusedCustomizationChecker.UnacknolwedgedCustomization", bIDeclaration.getName().getLocalPart());
            this.getErrorReporter().error(xSComponent.getLocator(), "UnusedCustomizationChecker.UnacknolwedgedCustomization.Relevant", new Object[0]);
            bIDeclaration.markAsAcknowledged();
        }
        for (BIDeclaration bIDeclaration2 : bIDeclaration.getChildren()) {
            this.check(bIDeclaration2, xSComponent);
        }
    }

    @Override
    public void annotation(XSAnnotation xSAnnotation) {
    }

    @Override
    public void attGroupDecl(XSAttGroupDecl xSAttGroupDecl) {
        if (this.check(xSAttGroupDecl)) {
            this.attContainer(xSAttGroupDecl);
        }
    }

    @Override
    public void attributeDecl(XSAttributeDecl xSAttributeDecl) {
        if (this.check(xSAttributeDecl)) {
            xSAttributeDecl.getType().visit(this);
        }
    }

    @Override
    public void attributeUse(XSAttributeUse xSAttributeUse) {
        if (this.check(xSAttributeUse)) {
            xSAttributeUse.getDecl().visit(this);
        }
    }

    @Override
    public void complexType(XSComplexType xSComplexType) {
        if (this.check(xSComplexType)) {
            xSComplexType.getContentType().visit(this);
            this.attContainer(xSComplexType);
        }
    }

    private void attContainer(XSAttContainer xSAttContainer) {
        Object object = xSAttContainer.iterateAttGroups();
        while (object.hasNext()) {
            object.next().visit(this);
        }
        object = xSAttContainer.iterateDeclaredAttributeUses();
        while (object.hasNext()) {
            ((XSAttributeUse)object.next()).visit(this);
        }
        object = xSAttContainer.getAttributeWildcard();
        if (object != null) {
            object.visit(this);
        }
    }

    @Override
    public void schema(XSSchema xSSchema) {
        this.check(xSSchema);
    }

    @Override
    public void facet(XSFacet xSFacet) {
        this.check(xSFacet);
    }

    @Override
    public void notation(XSNotation xSNotation) {
        this.check(xSNotation);
    }

    @Override
    public void wildcard(XSWildcard xSWildcard) {
        this.check(xSWildcard);
    }

    @Override
    public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
        if (this.check(xSModelGroupDecl)) {
            xSModelGroupDecl.getModelGroup().visit(this);
        }
    }

    @Override
    public void modelGroup(XSModelGroup xSModelGroup) {
        if (this.check(xSModelGroup)) {
            for (int i = 0; i < xSModelGroup.getSize(); ++i) {
                xSModelGroup.getChild(i).visit(this);
            }
        }
    }

    @Override
    public void elementDecl(XSElementDecl xSElementDecl) {
        if (this.check(xSElementDecl)) {
            xSElementDecl.getType().visit(this);
            for (XSIdentityConstraint xSIdentityConstraint : xSElementDecl.getIdentityConstraints()) {
                xSIdentityConstraint.visit(this);
            }
        }
    }

    @Override
    public void simpleType(XSSimpleType xSSimpleType) {
        if (this.check(xSSimpleType)) {
            xSSimpleType.visit(this);
        }
    }

    @Override
    public void particle(XSParticle xSParticle) {
        if (this.check(xSParticle)) {
            xSParticle.getTerm().visit(this);
        }
    }

    @Override
    public void empty(XSContentType xSContentType) {
        this.check(xSContentType);
    }

    @Override
    public void listSimpleType(XSListSimpleType xSListSimpleType) {
        if (this.check(xSListSimpleType)) {
            xSListSimpleType.getItemType().visit(this);
        }
    }

    @Override
    public void restrictionSimpleType(XSRestrictionSimpleType xSRestrictionSimpleType) {
        if (this.check(xSRestrictionSimpleType)) {
            xSRestrictionSimpleType.getBaseType().visit(this);
        }
    }

    @Override
    public void unionSimpleType(XSUnionSimpleType xSUnionSimpleType) {
        if (this.check(xSUnionSimpleType)) {
            for (int i = 0; i < xSUnionSimpleType.getMemberSize(); ++i) {
                xSUnionSimpleType.getMember(i).visit(this);
            }
        }
    }

    @Override
    public void identityConstraint(XSIdentityConstraint xSIdentityConstraint) {
        if (this.check(xSIdentityConstraint)) {
            xSIdentityConstraint.getSelector().visit(this);
            for (XSXPath xSXPath : xSIdentityConstraint.getFields()) {
                xSXPath.visit(this);
            }
        }
    }

    @Override
    public void xpath(XSXPath xSXPath) {
        this.check(xSXPath);
    }
}

