/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)ClassWriter.java\t1.127 10/03/23")
public class ClassWriter
extends ClassFile {
    protected static final Context.Key<ClassWriter> classWriterKey = new Context.Key();
    private final Symtab syms;
    private final Options options;
    private boolean verbose;
    private boolean scramble;
    private boolean scrambleAll;
    private boolean retrofit;
    private boolean emitSourceFile;
    private boolean genCrt;
    boolean debugstackmap;
    private Target target;
    private Source source;
    private Types types;
    static final int DATA_BUF_SIZE = 65520;
    static final int POOL_BUF_SIZE = 131056;
    ByteBuffer databuf = new ByteBuffer(65520);
    ByteBuffer poolbuf = new ByteBuffer(131056);
    ByteBuffer sigbuf = new ByteBuffer();
    Pool pool;
    Set<Symbol.ClassSymbol> innerClasses;
    ListBuffer<Symbol.ClassSymbol> innerClassesQueue;
    private final Log log;
    private final Name.Table names;
    private final JavaFileManager fileManager;
    static final int SAME_FRAME_SIZE = 64;
    static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int FULL_FRAME = 255;
    static final int MAX_LOCAL_LENGTH_DIFF = 4;
    private final boolean dumpClassModifiers;
    private final boolean dumpFieldModifiers;
    private final boolean dumpInnerClassModifiers;
    private final boolean dumpMethodModifiers;
    private static final String[] flagName = new String[]{"PUBLIC", "PRIVATE", "PROTECTED", "STATIC", "FINAL", "SUPER", "VOLATILE", "TRANSIENT", "NATIVE", "INTERFACE", "ABSTRACT", "STRICTFP"};
    AttributeWriter awriter = new AttributeWriter();

    public static ClassWriter instance(Context context) {
        ClassWriter classWriter = context.get(classWriterKey);
        if (classWriter == null) {
            classWriter = new ClassWriter(context);
        }
        return classWriter;
    }

    private ClassWriter(Context context) {
        context.put(classWriterKey, this);
        this.log = Log.instance(context);
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        this.options = Options.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.verbose = this.options.get("-verbose") != null;
        this.scramble = this.options.get("-scramble") != null;
        this.scrambleAll = this.options.get("-scrambleAll") != null;
        this.retrofit = this.options.get("-retrofit") != null;
        this.genCrt = this.options.get("-Xjcov") != null;
        this.debugstackmap = this.options.get("debugstackmap") != null;
        this.emitSourceFile = this.options.get("-g:") == null || this.options.get("-g:source") != null;
        String string = this.options.get("dumpmodifiers");
        this.dumpClassModifiers = string != null && string.indexOf(99) != -1;
        this.dumpFieldModifiers = string != null && string.indexOf(102) != -1;
        this.dumpInnerClassModifiers = string != null && string.indexOf(105) != -1;
        this.dumpMethodModifiers = string != null && string.indexOf(109) != -1;
    }

    public static String flagNames(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        long l2 = l & 0xFFFL;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                stringBuffer.append(" " + flagName[n]);
            }
            l2 >>= 1;
            ++n;
        }
        return stringBuffer.toString();
    }

    void putChar(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 & 0xFF);
    }

    void putInt(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 24 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byteBuffer.elems[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 3] = (byte)(n2 & 0xFF);
    }

    void assembleSig(Type type) {
        block0 : switch (type.tag) {
            case 1: {
                this.sigbuf.appendByte(66);
                break;
            }
            case 3: {
                this.sigbuf.appendByte(83);
                break;
            }
            case 2: {
                this.sigbuf.appendByte(67);
                break;
            }
            case 4: {
                this.sigbuf.appendByte(73);
                break;
            }
            case 5: {
                this.sigbuf.appendByte(74);
                break;
            }
            case 6: {
                this.sigbuf.appendByte(70);
                break;
            }
            case 7: {
                this.sigbuf.appendByte(68);
                break;
            }
            case 8: {
                this.sigbuf.appendByte(90);
                break;
            }
            case 9: {
                this.sigbuf.appendByte(86);
                break;
            }
            case 10: {
                this.sigbuf.appendByte(76);
                this.assembleClassSig(type);
                this.sigbuf.appendByte(59);
                break;
            }
            case 11: {
                Type.ArrayType arrayType = (Type.ArrayType)type;
                this.sigbuf.appendByte(91);
                this.assembleSig(arrayType.elemtype);
                break;
            }
            case 12: {
                Type.MethodType methodType = (Type.MethodType)type;
                this.sigbuf.appendByte(40);
                this.assembleSig(methodType.argtypes);
                this.sigbuf.appendByte(41);
                this.assembleSig(methodType.restype);
                if (!this.hasTypeVar(methodType.thrown)) break;
                List<Type> list = methodType.thrown;
                while (list.nonEmpty()) {
                    this.sigbuf.appendByte(94);
                    this.assembleSig((Type)list.head);
                    list = list.tail;
                }
                break;
            }
            case 15: {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                switch (wildcardType.kind) {
                    case SUPER: {
                        this.sigbuf.appendByte(45);
                        this.assembleSig(wildcardType.type);
                        break block0;
                    }
                    case EXTENDS: {
                        this.sigbuf.appendByte(43);
                        this.assembleSig(wildcardType.type);
                        break block0;
                    }
                    case UNBOUND: {
                        this.sigbuf.appendByte(42);
                        break block0;
                    }
                }
                throw new AssertionError((Object)wildcardType.kind);
            }
            case 14: {
                this.sigbuf.appendByte(84);
                this.sigbuf.appendName(type.tsym.name);
                this.sigbuf.appendByte(59);
                break;
            }
            case 16: {
                Type.ForAll forAll = (Type.ForAll)type;
                this.assembleParamsSig(forAll.tvars);
                this.assembleSig(forAll.qtype);
                break;
            }
            case 22: 
            case 23: {
                this.assembleSig(this.types.erasure(((UninitializedType)type).qtype));
                break;
            }
            default: {
                throw new AssertionError((Object)("typeSig " + type.tag));
            }
        }
    }

    boolean hasTypeVar(List<Type> list) {
        while (list.nonEmpty()) {
            if (((Type)list.head).tag == 14) {
                return true;
            }
            list = list.tail;
        }
        return false;
    }

    void assembleClassSig(Type type) {
        Type.ClassType classType = (Type.ClassType)type;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
        this.enterInner(classSymbol);
        Type type2 = classType.getEnclosingType();
        if (type2.allparams().nonEmpty()) {
            boolean bl = classSymbol.owner.kind == 16 || classSymbol.name == this.names.empty;
            this.assembleClassSig(bl ? this.types.erasure(type2) : type2);
            this.sigbuf.appendByte(46);
            assert (classSymbol.flatname.startsWith(classSymbol.owner.enclClass().flatname));
            this.sigbuf.appendName(bl ? classSymbol.flatname.subName(classSymbol.owner.enclClass().flatname.len + 1, classSymbol.flatname.len) : classSymbol.name);
        } else {
            this.sigbuf.appendBytes(ClassWriter.externalize(classSymbol.flatname));
        }
        if (((List)classType.getTypeArguments()).nonEmpty()) {
            this.sigbuf.appendByte(60);
            this.assembleSig((List<Type>)classType.getTypeArguments());
            this.sigbuf.appendByte(62);
        }
    }

    void assembleSig(List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            this.assembleSig((Type)list2.head);
            list2 = list2.tail;
        }
    }

    void assembleParamsSig(List<Type> list) {
        this.sigbuf.appendByte(60);
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            Type.TypeVar typeVar = (Type.TypeVar)list2.head;
            this.sigbuf.appendName(typeVar.tsym.name);
            List<Type> list3 = this.types.getBounds(typeVar);
            if ((((Type)list3.head).tsym.flags() & 0x200L) != 0L) {
                this.sigbuf.appendByte(58);
            }
            List<Type> list4 = list3;
            while (list4.nonEmpty()) {
                this.sigbuf.appendByte(58);
                this.assembleSig((Type)list4.head);
                list4 = list4.tail;
            }
            list2 = list2.tail;
        }
        this.sigbuf.appendByte(62);
    }

    Name typeSig(Type type) {
        assert (this.sigbuf.length == 0);
        this.assembleSig(type);
        Name name = this.sigbuf.toName(this.names);
        this.sigbuf.reset();
        return name;
    }

    public Name xClassName(Type type) {
        if (type.tag == 10) {
            return this.names.fromUtf(ClassWriter.externalize(type.tsym.flatName()));
        }
        if (type.tag == 11) {
            return this.typeSig(this.types.erasure(type));
        }
        throw new AssertionError((Object)"xClassName");
    }

    void writePool(Pool pool) throws PoolOverflow, StringOverflow {
        int n = this.poolbuf.length;
        this.poolbuf.appendChar(0);
        for (int i = 1; i < pool.pp; ++i) {
            Object object;
            Object object2 = pool.pool[i];
            assert (object2 != null);
            if (object2 instanceof Pool.Method) {
                object2 = ((Pool.Method)object2).m;
            } else if (object2 instanceof Pool.Variable) {
                object2 = ((Pool.Variable)object2).v;
            }
            if (object2 instanceof Symbol.MethodSymbol) {
                object = (Symbol.MethodSymbol)object2;
                this.poolbuf.appendByte((((Symbol.MethodSymbol)object).owner.flags() & 0x200L) != 0L ? 11 : 10);
                this.poolbuf.appendChar(pool.put(((Symbol.MethodSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof Symbol.VarSymbol) {
                object = (Symbol.VarSymbol)object2;
                this.poolbuf.appendByte(9);
                this.poolbuf.appendChar(pool.put(((Symbol.VarSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof Name) {
                this.poolbuf.appendByte(1);
                object = ((Name)object2).toUtf();
                this.poolbuf.appendChar(((Object)object).length);
                this.poolbuf.appendBytes((byte[])object, 0, ((Object)object).length);
                if (((Object)object).length <= 65535) continue;
                throw new StringOverflow(object2.toString());
            }
            if (object2 instanceof Symbol.ClassSymbol) {
                object = (Symbol.ClassSymbol)object2;
                if (((Symbol.ClassSymbol)object).owner.kind == 2) {
                    pool.put(((Symbol.ClassSymbol)object).owner);
                }
                this.poolbuf.appendByte(7);
                if (((Symbol.ClassSymbol)object).type.tag == 11) {
                    this.poolbuf.appendChar(pool.put(this.typeSig(((Symbol.ClassSymbol)object).type)));
                    continue;
                }
                this.poolbuf.appendChar(pool.put(this.names.fromUtf(ClassWriter.externalize(((Symbol.ClassSymbol)object).flatname))));
                this.enterInner((Symbol.ClassSymbol)object);
                continue;
            }
            if (object2 instanceof ClassFile.NameAndType) {
                object = (ClassFile.NameAndType)object2;
                this.poolbuf.appendByte(12);
                this.poolbuf.appendChar(pool.put(((ClassFile.NameAndType)object).name));
                this.poolbuf.appendChar(pool.put(this.typeSig(((ClassFile.NameAndType)object).type)));
                continue;
            }
            if (object2 instanceof Integer) {
                this.poolbuf.appendByte(3);
                this.poolbuf.appendInt((Integer)object2);
                continue;
            }
            if (object2 instanceof Long) {
                this.poolbuf.appendByte(5);
                this.poolbuf.appendLong((Long)object2);
                ++i;
                continue;
            }
            if (object2 instanceof Float) {
                this.poolbuf.appendByte(4);
                this.poolbuf.appendFloat(((Float)object2).floatValue());
                continue;
            }
            if (object2 instanceof Double) {
                this.poolbuf.appendByte(6);
                this.poolbuf.appendDouble((Double)object2);
                ++i;
                continue;
            }
            if (object2 instanceof String) {
                this.poolbuf.appendByte(8);
                this.poolbuf.appendChar(pool.put(this.names.fromString((String)object2)));
                continue;
            }
            if (object2 instanceof Type) {
                object = (Type)object2;
                if (((Type)object).tag == 10) {
                    this.enterInner((Symbol.ClassSymbol)((Type)object).tsym);
                }
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(pool.put(this.xClassName((Type)object)));
                continue;
            }
            assert (false) : "writePool " + object2;
        }
        if (pool.pp > 65535) {
            throw new PoolOverflow();
        }
        this.putChar(this.poolbuf, n, pool.pp);
    }

    Name fieldName(Symbol symbol) {
        if (this.scramble && (symbol.flags() & 2L) != 0L || this.scrambleAll && (symbol.flags() & 5L) == 0L) {
            return this.names.fromString("_$" + symbol.name.index);
        }
        return symbol.name;
    }

    ClassFile.NameAndType nameType(Symbol symbol) {
        return new ClassFile.NameAndType(this.fieldName(symbol), this.retrofit ? symbol.erasure(this.types) : symbol.externalType(this.types));
    }

    int writeAttr(Name name) {
        this.databuf.appendChar(this.pool.put(name));
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    void endAttr(int n) {
        this.putInt(this.databuf, n - 4, this.databuf.length - n);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int n, int n2) {
        this.putChar(this.databuf, n - 2, n2);
    }

    int writeEnclosingMethodAttribute(Symbol.ClassSymbol classSymbol) {
        if (!this.target.hasEnclosingMethodAttribute() || classSymbol.owner.kind != 16 && classSymbol.name != this.names.empty) {
            return 0;
        }
        int n = this.writeAttr(this.names.EnclosingMethod);
        Symbol.ClassSymbol classSymbol2 = classSymbol.owner.enclClass();
        Symbol.MethodSymbol methodSymbol = classSymbol.owner.type == null || classSymbol.owner.kind != 16 ? null : (Symbol.MethodSymbol)classSymbol.owner;
        this.databuf.appendChar(this.pool.put(classSymbol2));
        this.databuf.appendChar(methodSymbol == null ? 0 : this.pool.put(this.nameType(classSymbol.owner)));
        this.endAttr(n);
        return 1;
    }

    int writeFlagAttrs(long l) {
        int n;
        int n2 = 0;
        if ((l & 0x20000L) != 0L) {
            n = this.writeAttr(this.names.Deprecated);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x4000L) != 0L && !this.target.useEnumFlag()) {
            n = this.writeAttr(this.names.Enum);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x1000L) != 0L && !this.target.useSyntheticFlag()) {
            n = this.writeAttr(this.names.Synthetic);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x80000000L) != 0L && !this.target.useBridgeFlag()) {
            n = this.writeAttr(this.names.Bridge);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x400000000L) != 0L && !this.target.useVarargsFlag()) {
            n = this.writeAttr(this.names.Varargs);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x2000L) != 0L && !this.target.useAnnotationFlag()) {
            n = this.writeAttr(this.names.Annotation);
            this.endAttr(n);
            ++n2;
        }
        return n2;
    }

    int writeMemberAttrs(Symbol symbol) {
        int n = this.writeFlagAttrs(symbol.flags());
        long l = symbol.flags();
        if (this.source.allowGenerics() && (l & 0x80001000L) != 4096L && (l & 0x20000000L) == 0L && (!this.types.isSameType(symbol.type, symbol.erasure(this.types)) || this.hasTypeVar(symbol.type.getThrownTypes()))) {
            int n2 = this.writeAttr(this.names.Signature);
            this.databuf.appendChar(this.pool.put(this.typeSig(symbol.type)));
            this.endAttr(n2);
            ++n;
        }
        return n += this.writeJavaAnnotations((List<Attribute.Compound>)symbol.getAnnotationMirrors());
    }

    int writeParameterAttrs(Symbol.MethodSymbol methodSymbol) {
        ListBuffer<Attribute.Compound> listBuffer;
        boolean bl = false;
        boolean bl2 = false;
        if (methodSymbol.params != null) {
            for (Symbol.VarSymbol varSymbol : methodSymbol.params) {
                for (Attribute.Compound object : varSymbol.getAnnotationMirrors()) {
                    switch (this.getRetention(object.type.tsym)) {
                        case SOURCE: {
                            break;
                        }
                        case CLASS: {
                            bl2 = true;
                            break;
                        }
                        case RUNTIME: {
                            bl = true;
                            break;
                        }
                    }
                }
            }
        }
        int n = 0;
        if (bl) {
            int n2 = this.writeAttr(this.names.RuntimeVisibleParameterAnnotations);
            this.databuf.appendByte(methodSymbol.params.length());
            for (Symbol.VarSymbol varSymbol : methodSymbol.params) {
                listBuffer = new ListBuffer<Attribute.Compound>();
                for (Attribute.Compound compound : varSymbol.getAnnotationMirrors()) {
                    if (this.getRetention(compound.type.tsym) != RetentionPolicy.RUNTIME) continue;
                    listBuffer.append(compound);
                }
                this.databuf.appendChar(listBuffer.length());
                for (Attribute.Compound compound : listBuffer) {
                    this.writeCompoundAttribute(compound);
                }
            }
            this.endAttr(n2);
            ++n;
        }
        if (bl2) {
            int n3 = this.writeAttr(this.names.RuntimeInvisibleParameterAnnotations);
            this.databuf.appendByte(methodSymbol.params.length());
            for (Symbol.VarSymbol varSymbol : methodSymbol.params) {
                listBuffer = new ListBuffer();
                for (Attribute.Compound compound : varSymbol.getAnnotationMirrors()) {
                    if (this.getRetention(compound.type.tsym) != RetentionPolicy.CLASS) continue;
                    listBuffer.append(compound);
                }
                this.databuf.appendChar(listBuffer.length());
                for (Attribute.Compound compound : listBuffer) {
                    this.writeCompoundAttribute(compound);
                }
            }
            this.endAttr(n3);
            ++n;
        }
        return n;
    }

    int writeJavaAnnotations(List<Attribute.Compound> list) {
        if (list.isEmpty()) {
            return 0;
        }
        ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
        ListBuffer<Attribute.Compound> listBuffer2 = new ListBuffer<Attribute.Compound>();
        for (Attribute.Compound compound : list) {
            switch (this.getRetention(compound.type.tsym)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    listBuffer2.append(compound);
                    break;
                }
                case RUNTIME: {
                    listBuffer.append(compound);
                    break;
                }
            }
        }
        int n = 0;
        if (listBuffer.length() != 0) {
            int n2 = this.writeAttr(this.names.RuntimeVisibleAnnotations);
            this.databuf.appendChar(listBuffer.length());
            for (Attribute.Compound compound : listBuffer) {
                this.writeCompoundAttribute(compound);
            }
            this.endAttr(n2);
            ++n;
        }
        if (listBuffer2.length() != 0) {
            int n3 = this.writeAttr(this.names.RuntimeInvisibleAnnotations);
            this.databuf.appendChar(listBuffer2.length());
            for (Attribute.Compound compound : listBuffer2) {
                this.writeCompoundAttribute(compound);
            }
            this.endAttr(n3);
            ++n;
        }
        return n;
    }

    RetentionPolicy getRetention(Symbol.TypeSymbol typeSymbol) {
        Attribute attribute;
        RetentionPolicy retentionPolicy = RetentionPolicy.CLASS;
        Attribute.Compound compound = typeSymbol.attribute(this.syms.retentionType.tsym);
        if (compound != null && (attribute = compound.member(this.names.value)) != null && attribute instanceof Attribute.Enum) {
            Name name = ((Attribute.Enum)attribute).value.name;
            if (name == this.names.SOURCE) {
                retentionPolicy = RetentionPolicy.SOURCE;
            } else if (name == this.names.CLASS) {
                retentionPolicy = RetentionPolicy.CLASS;
            } else if (name == this.names.RUNTIME) {
                retentionPolicy = RetentionPolicy.RUNTIME;
            }
        }
        return retentionPolicy;
    }

    void writeCompoundAttribute(Attribute.Compound compound) {
        this.databuf.appendChar(this.pool.put(this.typeSig(compound.type)));
        this.databuf.appendChar(compound.values.length());
        for (Pair<Symbol.MethodSymbol, Attribute> pair : compound.values) {
            this.databuf.appendChar(this.pool.put(((Symbol.MethodSymbol)pair.fst).name));
            ((Attribute)pair.snd).accept(this.awriter);
        }
    }

    void enterInner(Symbol.ClassSymbol classSymbol) {
        assert (!classSymbol.type.isCompound());
        try {
            classSymbol.complete();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            System.err.println("error: " + classSymbol + ": " + completionFailure.getMessage());
            throw completionFailure;
        }
        if (classSymbol.type.tag != 10) {
            return;
        }
        if (!(this.pool == null || classSymbol.owner.kind == 1 || this.innerClasses != null && this.innerClasses.contains(classSymbol))) {
            if (classSymbol.owner.kind == 2) {
                this.enterInner((Symbol.ClassSymbol)classSymbol.owner);
            }
            this.pool.put(classSymbol);
            this.pool.put(classSymbol.name);
            if (this.innerClasses == null) {
                this.innerClasses = new HashSet<Symbol.ClassSymbol>();
                this.innerClassesQueue = new ListBuffer();
                this.pool.put(this.names.InnerClasses);
            }
            this.innerClasses.add(classSymbol);
            this.innerClassesQueue.append(classSymbol);
        }
    }

    void writeInnerClasses() {
        int n = this.writeAttr(this.names.InnerClasses);
        this.databuf.appendChar(this.innerClassesQueue.length());
        List<Symbol.ClassSymbol> list = this.innerClassesQueue.toList();
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)list.head;
            char c = (char)this.adjustFlags(classSymbol.flags_field);
            if ((c & 0x200) != 0) {
                c = (char)(c | 0x400);
            }
            if (classSymbol.name.isEmpty()) {
                c = (char)(c & 0xFFFFFFEF);
            }
            if (this.dumpInnerClassModifiers) {
                this.log.errWriter.println("INNERCLASS  " + classSymbol.name);
                this.log.errWriter.println("---" + ClassWriter.flagNames(c));
            }
            this.databuf.appendChar(this.pool.get(classSymbol));
            this.databuf.appendChar(classSymbol.owner.kind == 2 ? this.pool.get(classSymbol.owner) : 0);
            this.databuf.appendChar(classSymbol.name.len != 0 ? this.pool.get(classSymbol.name) : 0);
            this.databuf.appendChar(c);
            list = list.tail;
        }
        this.endAttr(n);
    }

    void writeField(Symbol.VarSymbol varSymbol) {
        int n = this.adjustFlags(varSymbol.flags());
        this.databuf.appendChar(n);
        if (this.dumpFieldModifiers) {
            this.log.errWriter.println("FIELD  " + this.fieldName(varSymbol));
            this.log.errWriter.println("---" + ClassWriter.flagNames(varSymbol.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(varSymbol)));
        this.databuf.appendChar(this.pool.put(this.typeSig(varSymbol.erasure(this.types))));
        int n2 = this.beginAttrs();
        int n3 = 0;
        if (varSymbol.getConstValue() != null) {
            int n4 = this.writeAttr(this.names.ConstantValue);
            this.databuf.appendChar(this.pool.put(varSymbol.getConstValue()));
            this.endAttr(n4);
            ++n3;
        }
        this.endAttrs(n2, n3 += this.writeMemberAttrs(varSymbol));
    }

    void writeMethod(Symbol.MethodSymbol methodSymbol) {
        int n;
        List<Type> list;
        int n2 = this.adjustFlags(methodSymbol.flags());
        this.databuf.appendChar(n2);
        if (this.dumpMethodModifiers) {
            this.log.errWriter.println("METHOD  " + this.fieldName(methodSymbol));
            this.log.errWriter.println("---" + ClassWriter.flagNames(methodSymbol.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(methodSymbol)));
        this.databuf.appendChar(this.pool.put(this.typeSig(methodSymbol.externalType(this.types))));
        int n3 = this.beginAttrs();
        int n4 = 0;
        if (methodSymbol.code != null) {
            int n5 = this.writeAttr(this.names.Code);
            this.writeCode(methodSymbol.code);
            methodSymbol.code = null;
            this.endAttr(n5);
            ++n4;
        }
        if ((list = methodSymbol.erasure(this.types).getThrownTypes()).nonEmpty()) {
            n = this.writeAttr(this.names.Exceptions);
            this.databuf.appendChar(list.length());
            List<Type> list2 = list;
            while (list2.nonEmpty()) {
                this.databuf.appendChar(this.pool.put(((Type)list2.head).tsym));
                list2 = list2.tail;
            }
            this.endAttr(n);
            ++n4;
        }
        if (methodSymbol.defaultValue != null) {
            n = this.writeAttr(this.names.AnnotationDefault);
            methodSymbol.defaultValue.accept(this.awriter);
            this.endAttr(n);
            ++n4;
        }
        n4 += this.writeMemberAttrs(methodSymbol);
        this.endAttrs(n3, n4 += this.writeParameterAttrs(methodSymbol));
    }

    void writeCode(Code code) {
        AnnotatedConstruct annotatedConstruct;
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List<Object> list = code.catchInfo.toList();
        while (list.nonEmpty()) {
            for (n4 = 0; n4 < ((char[])list.head).length; ++n4) {
                this.databuf.appendChar(((char[])list.head)[n4]);
            }
            list = list.tail;
        }
        int n5 = this.beginAttrs();
        n4 = 0;
        if (code.lineInfo.nonEmpty()) {
            n3 = this.writeAttr(this.names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List<Object> list2 = code.lineInfo.reverse();
            while (list2.nonEmpty()) {
                for (n2 = 0; n2 < ((char[])list2.head).length; ++n2) {
                    this.databuf.appendChar(((char[])list2.head)[n2]);
                }
                list2 = list2.tail;
            }
            this.endAttr(n3);
            ++n4;
        }
        if (this.genCrt && code.crt != null) {
            CRTable cRTable = code.crt;
            int n6 = this.writeAttr(this.names.CharacterRangeTable);
            n2 = this.beginAttrs();
            n = cRTable.writeCRT(this.databuf, code.lineMap, this.log);
            this.endAttrs(n2, n);
            this.endAttr(n6);
            ++n4;
        }
        n3 = 0;
        if (code.varBufferSize > 0) {
            int n7 = this.writeAttr(this.names.LocalVariableTable);
            this.databuf.appendChar(code.varBufferSize);
            for (n2 = 0; n2 < code.varBufferSize; ++n2) {
                Code.LocalVar localVar = code.varBuffer[n2];
                assert (localVar.start_pc >= '\u0000');
                assert (localVar.start_pc <= code.cp);
                this.databuf.appendChar(localVar.start_pc);
                assert (localVar.length >= '\u0000');
                assert (localVar.start_pc + localVar.length <= code.cp);
                this.databuf.appendChar(localVar.length);
                object = localVar.sym;
                this.databuf.appendChar(this.pool.put(((Symbol.VarSymbol)object).name));
                annotatedConstruct = ((Symbol)object).erasure(this.types);
                if (!this.types.isSameType(((Symbol.VarSymbol)object).type, (Type)annotatedConstruct)) {
                    ++n3;
                }
                this.databuf.appendChar(this.pool.put(this.typeSig((Type)annotatedConstruct)));
                this.databuf.appendChar(localVar.reg);
            }
            this.endAttr(n7);
            ++n4;
        }
        if (n3 > 0) {
            int n8 = this.writeAttr(this.names.LocalVariableTypeTable);
            this.databuf.appendChar(n3);
            n2 = 0;
            for (n = 0; n < code.varBufferSize; ++n) {
                object = code.varBuffer[n];
                annotatedConstruct = ((Code.LocalVar)object).sym;
                if (this.types.isSameType(annotatedConstruct.type, annotatedConstruct.erasure(this.types))) continue;
                ++n2;
                this.databuf.appendChar(((Code.LocalVar)object).start_pc);
                this.databuf.appendChar(((Code.LocalVar)object).length);
                this.databuf.appendChar(this.pool.put(annotatedConstruct.name));
                this.databuf.appendChar(this.pool.put(this.typeSig(annotatedConstruct.type)));
                this.databuf.appendChar(((Code.LocalVar)object).reg);
            }
            assert (n2 == n3);
            this.endAttr(n8);
            ++n4;
        }
        if (code.stackMapBufferSize > 0) {
            if (this.debugstackmap) {
                System.out.println("Stack map for " + code.meth);
            }
            int n9 = this.writeAttr(code.stackMap.getAttributeName(this.names));
            this.writeStackMap(code);
            this.endAttr(n9);
            ++n4;
        }
        this.endAttrs(n5, n4);
    }

    void writeStackMap(Code code) {
        int n = code.stackMapBufferSize;
        if (this.debugstackmap) {
            System.out.println(" nframes = " + n);
        }
        this.databuf.appendChar(n);
        switch (code.stackMap) {
            case CLDC: {
                for (int i = 0; i < n; ++i) {
                    int n2;
                    int n3;
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    Code.StackMapFrame stackMapFrame = code.stackMapBuffer[i];
                    if (this.debugstackmap) {
                        System.out.print(" pc=" + stackMapFrame.pc);
                    }
                    this.databuf.appendChar(stackMapFrame.pc);
                    int n4 = 0;
                    for (n3 = 0; n3 < stackMapFrame.locals.length; n3 += this.target.generateEmptyAfterBig() ? 1 : Code.width(stackMapFrame.locals[n3])) {
                        ++n4;
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nlocals=" + n4);
                    }
                    this.databuf.appendChar(n4);
                    for (n3 = 0; n3 < stackMapFrame.locals.length; n3 += this.target.generateEmptyAfterBig() ? 1 : Code.width(stackMapFrame.locals[n3])) {
                        if (this.debugstackmap) {
                            System.out.print(" local[" + n3 + "]=");
                        }
                        this.writeStackMapType(stackMapFrame.locals[n3]);
                    }
                    n3 = 0;
                    for (n2 = 0; n2 < stackMapFrame.stack.length; n2 += this.target.generateEmptyAfterBig() ? 1 : Code.width(stackMapFrame.stack[n2])) {
                        ++n3;
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nstack=" + n3);
                    }
                    this.databuf.appendChar(n3);
                    for (n2 = 0; n2 < stackMapFrame.stack.length; n2 += this.target.generateEmptyAfterBig() ? 1 : Code.width(stackMapFrame.stack[n2])) {
                        if (this.debugstackmap) {
                            System.out.print(" stack[" + n2 + "]=");
                        }
                        this.writeStackMapType(stackMapFrame.stack[n2]);
                    }
                    if (!this.debugstackmap) continue;
                    System.out.println();
                }
                break;
            }
            case JSR202: {
                assert (code.stackMapBuffer == null);
                for (int i = 0; i < n; ++i) {
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    StackMapTableFrame stackMapTableFrame = code.stackMapTableBuffer[i];
                    stackMapTableFrame.write(this);
                    if (!this.debugstackmap) continue;
                    System.out.println();
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected stackmap format value");
            }
        }
    }

    void writeStackMapType(Type type) {
        if (type == null) {
            if (this.debugstackmap) {
                System.out.print("empty");
            }
            this.databuf.appendByte(0);
        } else {
            switch (type.tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    if (this.debugstackmap) {
                        System.out.print("int");
                    }
                    this.databuf.appendByte(1);
                    break;
                }
                case 6: {
                    if (this.debugstackmap) {
                        System.out.print("float");
                    }
                    this.databuf.appendByte(2);
                    break;
                }
                case 7: {
                    if (this.debugstackmap) {
                        System.out.print("double");
                    }
                    this.databuf.appendByte(3);
                    break;
                }
                case 5: {
                    if (this.debugstackmap) {
                        System.out.print("long");
                    }
                    this.databuf.appendByte(4);
                    break;
                }
                case 17: {
                    if (this.debugstackmap) {
                        System.out.print("null");
                    }
                    this.databuf.appendByte(5);
                    break;
                }
                case 10: 
                case 11: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + type + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(type));
                    break;
                }
                case 14: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + this.types.erasure((Type)type).tsym + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(this.types.erasure((Type)type).tsym));
                    break;
                }
                case 22: {
                    if (this.debugstackmap) {
                        System.out.print("uninit_this");
                    }
                    this.databuf.appendByte(6);
                    break;
                }
                case 23: {
                    UninitializedType uninitializedType = (UninitializedType)type;
                    this.databuf.appendByte(8);
                    if (this.debugstackmap) {
                        System.out.print("uninit_object@" + uninitializedType.offset);
                    }
                    this.databuf.appendChar(uninitializedType.offset);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    void writeFields(Scope.Entry entry) {
        List<Symbol.VarSymbol> list = List.nil();
        Scope.Entry entry2 = entry;
        while (entry2 != null) {
            if (entry2.sym.kind == 4) {
                list = list.prepend((Symbol.VarSymbol)entry2.sym);
            }
            entry2 = entry2.sibling;
        }
        while (list.nonEmpty()) {
            this.writeField((Symbol.VarSymbol)list.head);
            list = list.tail;
        }
    }

    void writeMethods(Scope.Entry entry) {
        List<Symbol.MethodSymbol> list = List.nil();
        Scope.Entry entry2 = entry;
        while (entry2 != null) {
            if (entry2.sym.kind == 16 && (entry2.sym.flags() & 0x2000000000L) == 0L) {
                list = list.prepend((Symbol.MethodSymbol)entry2.sym);
            }
            entry2 = entry2.sibling;
        }
        while (list.nonEmpty()) {
            this.writeMethod((Symbol.MethodSymbol)list.head);
            list = list.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFileObject writeClass(Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        JavaFileObject javaFileObject = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, classSymbol.flatname.toString(), JavaFileObject.Kind.CLASS, classSymbol.sourcefile);
        OutputStream outputStream = javaFileObject.openOutputStream();
        try {
            this.writeClassFile(outputStream, classSymbol);
            if (this.verbose) {
                this.log.errWriter.println(Log.getLocalizedString("verbose.wrote.file", javaFileObject));
            }
            outputStream.close();
            outputStream = null;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
                javaFileObject.delete();
                javaFileObject = null;
            }
        }
        return javaFileObject;
    }

    public void writeClassFile(OutputStream outputStream, Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        Object object;
        assert ((classSymbol.flags() & 0x1000000L) == 0L);
        this.databuf.reset();
        this.poolbuf.reset();
        this.sigbuf.reset();
        this.pool = classSymbol.pool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        Type type = this.types.supertype(classSymbol.type);
        List<Type> list = this.types.interfaces(classSymbol.type);
        List<Type> list2 = classSymbol.type.getTypeArguments();
        int n = this.adjustFlags(classSymbol.flags());
        if ((n & 4) != 0) {
            n |= 1;
        }
        if (((n = n & 0x7E11 & 0xFFFFF7FF) & 0x200) == 0) {
            n |= 0x20;
        }
        if (classSymbol.isInner() && classSymbol.name.isEmpty()) {
            n &= 0xFFFFFFEF;
        }
        if (this.dumpClassModifiers) {
            this.log.errWriter.println();
            this.log.errWriter.println("CLASSFILE  " + classSymbol.getQualifiedName());
            this.log.errWriter.println("---" + ClassWriter.flagNames(n));
        }
        this.databuf.appendChar(n);
        this.databuf.appendChar(this.pool.put(classSymbol));
        this.databuf.appendChar(type.tag == 10 ? this.pool.put(type.tsym) : 0);
        this.databuf.appendChar(list.length());
        List<Type> list3 = list;
        while (list3.nonEmpty()) {
            this.databuf.appendChar(this.pool.put(((Type)list3.head).tsym));
            list3 = list3.tail;
        }
        int n2 = 0;
        int n3 = 0;
        Scope.Entry entry = classSymbol.members().elems;
        while (entry != null) {
            switch (entry.sym.kind) {
                case 4: {
                    ++n2;
                    break;
                }
                case 16: {
                    if ((entry.sym.flags() & 0x2000000000L) != 0L) break;
                    ++n3;
                    break;
                }
                case 2: {
                    this.enterInner((Symbol.ClassSymbol)entry.sym);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            entry = entry.sibling;
        }
        this.databuf.appendChar(n2);
        this.writeFields(classSymbol.members().elems);
        this.databuf.appendChar(n3);
        this.writeMethods(classSymbol.members().elems);
        int n4 = this.beginAttrs();
        int n5 = 0;
        boolean bl = list2.length() != 0 || type.getTypeArguments().length() != 0;
        List<Type> list4 = list;
        while (!bl && list4.nonEmpty()) {
            bl = ((Type)list4.head).getTypeArguments().length() != 0;
            list4 = list4.tail;
        }
        if (bl) {
            assert (this.source.allowGenerics());
            int n6 = this.writeAttr(this.names.Signature);
            if (list2.length() != 0) {
                this.assembleParamsSig(list2);
            }
            this.assembleSig(type);
            object = list;
            while (((List)object).nonEmpty()) {
                this.assembleSig((Type)((List)object).head);
                object = ((List)object).tail;
            }
            this.databuf.appendChar(this.pool.put(this.sigbuf.toName(this.names)));
            this.sigbuf.reset();
            this.endAttr(n6);
            ++n5;
        }
        if (classSymbol.sourcefile != null && this.emitSourceFile) {
            int n7 = this.writeAttr(this.names.SourceFile);
            object = classSymbol.sourcefile.toString();
            int n8 = ((String)object).lastIndexOf(File.separatorChar);
            int n9 = ((String)object).lastIndexOf(47);
            if (n9 > n8) {
                n8 = n9;
            }
            if (n8 >= 0) {
                object = ((String)object).substring(n8 + 1);
            }
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString((CharSequence)object)));
            this.endAttr(n7);
            ++n5;
        }
        if (this.genCrt) {
            int n10 = this.writeAttr(this.names.SourceID);
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString(Long.toString(this.getLastModified(classSymbol.sourcefile)))));
            this.endAttr(n10);
            ++n5;
            n10 = this.writeAttr(this.names.CompilationID);
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString(Long.toString(System.currentTimeMillis()))));
            this.endAttr(n10);
            ++n5;
        }
        n5 += this.writeFlagAttrs(classSymbol.flags());
        n5 += this.writeJavaAnnotations((List<Attribute.Compound>)classSymbol.getAnnotationMirrors());
        n5 += this.writeEnclosingMethodAttribute(classSymbol);
        this.poolbuf.appendInt(-889275714);
        this.poolbuf.appendChar(this.target.minorVersion);
        this.poolbuf.appendChar(this.target.majorVersion);
        this.writePool(classSymbol.pool);
        if (this.innerClasses != null) {
            this.writeInnerClasses();
            ++n5;
        }
        this.endAttrs(n4, n5);
        this.poolbuf.appendBytes(this.databuf.elems, 0, this.databuf.length);
        outputStream.write(this.poolbuf.elems, 0, this.poolbuf.length);
        classSymbol.pool = null;
        this.pool = null;
    }

    int adjustFlags(long l) {
        int n = (int)l;
        if ((l & 0x1000L) != 0L && !this.target.useSyntheticFlag()) {
            n &= 0xFFFFEFFF;
        }
        if ((l & 0x4000L) != 0L && !this.target.useEnumFlag()) {
            n &= 0xFFFFBFFF;
        }
        if ((l & 0x2000L) != 0L && !this.target.useAnnotationFlag()) {
            n &= 0xFFFFDFFF;
        }
        if ((l & 0x80000000L) != 0L && this.target.useBridgeFlag()) {
            n |= 0x40;
        }
        if ((l & 0x400000000L) != 0L && this.target.useVarargsFlag()) {
            n |= 0x80;
        }
        return n;
    }

    long getLastModified(FileObject fileObject) {
        long l = 0L;
        try {
            l = fileObject.getLastModified();
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)("CRT: couldn't get source file modification date: " + securityException.getMessage()));
        }
        return l;
    }

    class AttributeWriter
    implements Attribute.Visitor {
        AttributeWriter() {
        }

        public void visitConstant(Attribute.Constant constant) {
            Object object = constant.value;
            switch (constant.type.tag) {
                case 1: {
                    ClassWriter.this.databuf.appendByte(66);
                    break;
                }
                case 2: {
                    ClassWriter.this.databuf.appendByte(67);
                    break;
                }
                case 3: {
                    ClassWriter.this.databuf.appendByte(83);
                    break;
                }
                case 4: {
                    ClassWriter.this.databuf.appendByte(73);
                    break;
                }
                case 5: {
                    ClassWriter.this.databuf.appendByte(74);
                    break;
                }
                case 6: {
                    ClassWriter.this.databuf.appendByte(70);
                    break;
                }
                case 7: {
                    ClassWriter.this.databuf.appendByte(68);
                    break;
                }
                case 8: {
                    ClassWriter.this.databuf.appendByte(90);
                    break;
                }
                case 10: {
                    assert (object instanceof String);
                    ClassWriter.this.databuf.appendByte(115);
                    object = ClassWriter.this.names.fromString(object.toString());
                    break;
                }
                default: {
                    throw new AssertionError(constant.type);
                }
            }
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(object));
        }

        public void visitEnum(Attribute.Enum enum_) {
            ClassWriter.this.databuf.appendByte(101);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(enum_.value.type)));
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(enum_.value.name));
        }

        public void visitClass(Attribute.Class clazz) {
            ClassWriter.this.databuf.appendByte(99);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(clazz.type)));
        }

        public void visitCompound(Attribute.Compound compound) {
            ClassWriter.this.databuf.appendByte(64);
            ClassWriter.this.writeCompoundAttribute(compound);
        }

        public void visitError(Attribute.Error error) {
            throw new AssertionError(error);
        }

        public void visitArray(Attribute.Array array) {
            ClassWriter.this.databuf.appendByte(91);
            ClassWriter.this.databuf.appendChar(array.values.length);
            for (Attribute attribute : array.values) {
                attribute.accept(this);
            }
        }
    }

    public static class PoolOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RetentionPolicy {
        SOURCE,
        CLASS,
        RUNTIME;

    }

    static abstract class StackMapTableFrame {
        StackMapTableFrame() {
        }

        abstract int getFrameType();

        void write(ClassWriter classWriter) {
            int n = this.getFrameType();
            classWriter.databuf.appendByte(n);
            if (classWriter.debugstackmap) {
                System.out.print(" frame_type=" + n);
            }
        }

        static StackMapTableFrame getInstance(Code.StackMapFrame stackMapFrame, int n, Type[] typeArray, Types types) {
            Type[] typeArray2 = stackMapFrame.locals;
            Type[] typeArray3 = stackMapFrame.stack;
            int n2 = stackMapFrame.pc - n - 1;
            if (typeArray3.length == 1) {
                if (typeArray2.length == typeArray.length && StackMapTableFrame.compare(typeArray, typeArray2, types) == 0) {
                    return new SameLocals1StackItemFrame(n2, typeArray3[0]);
                }
            } else if (typeArray3.length == 0) {
                int n3 = StackMapTableFrame.compare(typeArray, typeArray2, types);
                if (n3 == 0) {
                    return new SameFrame(n2);
                }
                if (-4 < n3 && n3 < 0) {
                    Type[] typeArray4 = new Type[-n3];
                    int n4 = typeArray.length;
                    int n5 = 0;
                    while (n4 < typeArray2.length) {
                        typeArray4[n5] = typeArray2[n4];
                        ++n4;
                        ++n5;
                    }
                    return new AppendFrame(251 - n3, n2, typeArray4);
                }
                if (0 < n3 && n3 < 4) {
                    return new ChopFrame(251 - n3, n2);
                }
            }
            return new FullFrame(n2, typeArray2, typeArray3);
        }

        static boolean isInt(Type type) {
            return type.tag < 4 || type.tag == 8;
        }

        static boolean isSameType(Type type, Type type2, Types types) {
            if (type == null) {
                return type2 == null;
            }
            if (type2 == null) {
                return false;
            }
            if (StackMapTableFrame.isInt(type) && StackMapTableFrame.isInt(type2)) {
                return true;
            }
            if (type.tag == 22) {
                return type2.tag == 22;
            }
            if (type.tag == 23) {
                if (type2.tag == 23) {
                    return ((UninitializedType)type).offset == ((UninitializedType)type2).offset;
                }
                return false;
            }
            if (type2.tag == 22 || type2.tag == 23) {
                return false;
            }
            return types.isSameType(type, type2);
        }

        static int compare(Type[] typeArray, Type[] typeArray2, Types types) {
            int n = typeArray.length - typeArray2.length;
            if (n > 4 || n < -4) {
                return Integer.MAX_VALUE;
            }
            int n2 = n > 0 ? typeArray2.length : typeArray.length;
            for (int i = 0; i < n2; ++i) {
                if (StackMapTableFrame.isSameType(typeArray[i], typeArray2[i], types)) continue;
                return Integer.MAX_VALUE;
            }
            return n;
        }

        static class AppendFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;
            final Type[] locals;

            AppendFrame(int n, int n2, Type[] typeArray) {
                this.frameType = n;
                this.offsetDelta = n2;
                this.locals = typeArray;
            }

            int getFrameType() {
                return this.frameType;
            }

            void write(ClassWriter classWriter) {
                super.write(classWriter);
                classWriter.databuf.appendChar(this.offsetDelta);
                if (classWriter.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
                for (int i = 0; i < this.locals.length; ++i) {
                    if (classWriter.debugstackmap) {
                        System.out.print(" locals[" + i + "]=");
                    }
                    classWriter.writeStackMapType(this.locals[i]);
                }
            }
        }

        static class ChopFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;

            ChopFrame(int n, int n2) {
                this.frameType = n;
                this.offsetDelta = n2;
            }

            int getFrameType() {
                return this.frameType;
            }

            void write(ClassWriter classWriter) {
                super.write(classWriter);
                classWriter.databuf.appendChar(this.offsetDelta);
                if (classWriter.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
            }
        }

        static class FullFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type[] locals;
            final Type[] stack;

            FullFrame(int n, Type[] typeArray, Type[] typeArray2) {
                this.offsetDelta = n;
                this.locals = typeArray;
                this.stack = typeArray2;
            }

            int getFrameType() {
                return 255;
            }

            void write(ClassWriter classWriter) {
                int n;
                super.write(classWriter);
                classWriter.databuf.appendChar(this.offsetDelta);
                classWriter.databuf.appendChar(this.locals.length);
                if (classWriter.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                    System.out.print(" nlocals=" + this.locals.length);
                }
                for (n = 0; n < this.locals.length; ++n) {
                    if (classWriter.debugstackmap) {
                        System.out.print(" locals[" + n + "]=");
                    }
                    classWriter.writeStackMapType(this.locals[n]);
                }
                classWriter.databuf.appendChar(this.stack.length);
                if (classWriter.debugstackmap) {
                    System.out.print(" nstack=" + this.stack.length);
                }
                for (n = 0; n < this.stack.length; ++n) {
                    if (classWriter.debugstackmap) {
                        System.out.print(" stack[" + n + "]=");
                    }
                    classWriter.writeStackMapType(this.stack[n]);
                }
            }
        }

        static class SameFrame
        extends StackMapTableFrame {
            final int offsetDelta;

            SameFrame(int n) {
                this.offsetDelta = n;
            }

            int getFrameType() {
                return this.offsetDelta < 64 ? this.offsetDelta : 251;
            }

            void write(ClassWriter classWriter) {
                super.write(classWriter);
                if (this.getFrameType() == 251) {
                    classWriter.databuf.appendChar(this.offsetDelta);
                    if (classWriter.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
            }
        }

        static class SameLocals1StackItemFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type stack;

            SameLocals1StackItemFrame(int n, Type type) {
                this.offsetDelta = n;
                this.stack = type;
            }

            int getFrameType() {
                return this.offsetDelta < 64 ? 64 + this.offsetDelta : 247;
            }

            void write(ClassWriter classWriter) {
                super.write(classWriter);
                if (this.getFrameType() == 247) {
                    classWriter.databuf.appendChar(this.offsetDelta);
                    if (classWriter.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
                if (classWriter.debugstackmap) {
                    System.out.print(" stack[0]=");
                }
                classWriter.writeStackMapType(this.stack);
            }
        }
    }

    public static class StringOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
        public final String value;

        public StringOverflow(String string) {
            this.value = string;
        }
    }
}

