/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.DiagnosticFormatter;
import com.sun.tools.javac.util.Messages;
import com.sun.tools.javac.util.Version;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)JCDiagnostic.java\t1.20 10/03/23")
public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final Messages messages;
    private final DiagnosticType type;
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final int line;
    private final int column;
    private final String key;
    private final Object[] args;
    private boolean mandatory;
    private static DiagnosticFormatter defaultFormatter;
    private static final String messageBundleName = "com.sun.tools.javac.resources.compiler";

    public static JCDiagnostic fragment(String string, Object ... objectArray) {
        return new JCDiagnostic(Messages.getDefaultMessages(), DiagnosticType.FRAGMENT, false, null, null, "compiler." + DiagnosticType.FRAGMENT.key + "." + string, objectArray);
    }

    protected JCDiagnostic(Messages messages, DiagnosticType diagnosticType, boolean bl, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        int n;
        if (diagnosticSource == null && diagnosticPosition != null && diagnosticPosition.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.messages = messages;
        this.type = diagnosticType;
        this.mandatory = bl;
        this.source = diagnosticSource;
        this.position = diagnosticPosition;
        this.key = string;
        this.args = objectArray;
        int n2 = n = diagnosticPosition == null ? -1 : diagnosticPosition.getPreferredPosition();
        if (n == -1 || diagnosticSource == null) {
            this.column = -1;
            this.line = -1;
        } else {
            this.line = diagnosticSource.getLineNumber(n);
            this.column = diagnosticSource.getColumnNumber(n);
        }
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public String getSourceName() {
        JavaFileObject javaFileObject = this.getSource();
        return javaFileObject == null ? null : DefaultFileManager.getJavacFileName(javaFileObject);
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    @Override
    public long getLineNumber() {
        return this.line;
    }

    @Override
    public long getColumnNumber() {
        return this.column;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.type);
    }

    public String getPrefix(DiagnosticType diagnosticType) {
        switch (diagnosticType) {
            case FRAGMENT: {
                return "";
            }
            case NOTE: {
                return this.getLocalizedString("compiler.note.note", new Object[0]);
            }
            case WARNING: {
                return this.getLocalizedString("compiler.warn.warning", new Object[0]);
            }
            case ERROR: {
                return this.getLocalizedString("compiler.err.error", new Object[0]);
            }
        }
        throw new AssertionError((Object)("Unknown diagnostic type: " + (Object)((Object)diagnosticType)));
    }

    public String getText() {
        return this.getLocalizedString(this.key, this.args);
    }

    public String toString() {
        return this.getMessage(null);
    }

    private String getLocalizedString(String string, Object ... objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = objectArray[i];
            stringArray[i] = object == null ? null : (object instanceof JCDiagnostic ? ((JCDiagnostic)object).getText() : object.toString());
        }
        return this.messages.getLocalizedString(string, stringArray);
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.mandatory ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.key;
    }

    @Override
    public String getMessage(Locale locale) {
        if (defaultFormatter == null) {
            defaultFormatter = new DiagnosticFormatter();
        }
        return defaultFormatter.format(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(Map<JCTree, Integer> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DiagnosticSource {
        public JavaFileObject getFile();

        public CharSequence getName();

        public int getLineNumber(int var1);

        public int getColumnNumber(int var1);

        public Map<JCTree, Integer> getEndPosTable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String string2) {
            this.key = string2;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        final Messages messages;
        final String prefix;

        public static Factory instance(Context context) {
            Factory factory = context.get(diagnosticFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            context.put(diagnosticFactoryKey, this);
            this.messages = Messages.instance(context);
            this.prefix = "compiler";
        }

        public Factory(Messages messages, String string) {
            this.messages = messages;
            this.prefix = string;
        }

        public JCDiagnostic error(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.messages, DiagnosticType.ERROR, true, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.ERROR, string), objectArray);
        }

        public JCDiagnostic mandatoryWarning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.messages, DiagnosticType.WARNING, true, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.WARNING, string), objectArray);
        }

        public JCDiagnostic warning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.messages, DiagnosticType.WARNING, false, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.WARNING, string), objectArray);
        }

        public JCDiagnostic mandatoryNote(String string, Object ... objectArray) {
            return new JCDiagnostic(this.messages, DiagnosticType.NOTE, true, null, null, this.qualify(DiagnosticType.NOTE, string), objectArray);
        }

        public JCDiagnostic note(String string, Object ... objectArray) {
            return this.note(null, null, string, objectArray);
        }

        public JCDiagnostic note(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.messages, DiagnosticType.NOTE, false, diagnosticSource, diagnosticPosition, this.qualify(DiagnosticType.NOTE, string), objectArray);
        }

        public JCDiagnostic fragment(String string, Object ... objectArray) {
            return new JCDiagnostic(this.messages, DiagnosticType.FRAGMENT, false, null, null, this.qualify(DiagnosticType.FRAGMENT, string), objectArray);
        }

        protected String qualify(DiagnosticType diagnosticType, String string) {
            return this.prefix + "." + diagnosticType.key + "." + string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int n) {
            this.pos = n;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(Map<JCTree, Integer> map) {
            return this.pos;
        }
    }
}

