/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.AttributePattern;
import com.sun.xml.internal.rngom.binary.DataExceptPattern;
import com.sun.xml.internal.rngom.binary.DataPattern;
import com.sun.xml.internal.rngom.binary.ElementPattern;
import com.sun.xml.internal.rngom.binary.ErrorPattern;
import com.sun.xml.internal.rngom.binary.ListPattern;
import com.sun.xml.internal.rngom.binary.NotAllowedPattern;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.PatternBuilder;
import com.sun.xml.internal.rngom.binary.PatternInterner;
import com.sun.xml.internal.rngom.binary.TextPattern;
import com.sun.xml.internal.rngom.binary.ValuePattern;
import com.sun.xml.internal.rngom.nc.NameClass;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

public class SchemaPatternBuilder
extends PatternBuilder {
    private boolean idTypes;
    private final Pattern unexpandedNotAllowed = new NotAllowedPattern(){

        boolean isNotAllowed() {
            return false;
        }

        Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
            return schemaPatternBuilder.makeNotAllowed();
        }
    };
    private final TextPattern text = new TextPattern();
    private final PatternInterner schemaInterner = new PatternInterner();

    public boolean hasIdTypes() {
        return this.idTypes;
    }

    Pattern makeElement(NameClass nameClass, Pattern pattern, Locator locator) {
        ElementPattern elementPattern = new ElementPattern(nameClass, pattern, locator);
        return this.schemaInterner.intern(elementPattern);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern pattern, Locator locator) {
        if (pattern == this.notAllowed) {
            return pattern;
        }
        AttributePattern attributePattern = new AttributePattern(nameClass, pattern, locator);
        return this.schemaInterner.intern(attributePattern);
    }

    Pattern makeData(Datatype datatype) {
        this.noteDatatype(datatype);
        DataPattern dataPattern = new DataPattern(datatype);
        return this.schemaInterner.intern(dataPattern);
    }

    Pattern makeDataExcept(Datatype datatype, Pattern pattern, Locator locator) {
        this.noteDatatype(datatype);
        DataExceptPattern dataExceptPattern = new DataExceptPattern(datatype, pattern, locator);
        return this.schemaInterner.intern(dataExceptPattern);
    }

    Pattern makeValue(Datatype datatype, Object object) {
        this.noteDatatype(datatype);
        ValuePattern valuePattern = new ValuePattern(datatype, object);
        return this.schemaInterner.intern(valuePattern);
    }

    Pattern makeText() {
        return this.text;
    }

    Pattern makeOneOrMore(Pattern pattern) {
        if (pattern == this.text) {
            return pattern;
        }
        return super.makeOneOrMore(pattern);
    }

    Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    Pattern makeError() {
        ErrorPattern errorPattern = new ErrorPattern();
        return this.schemaInterner.intern(errorPattern);
    }

    Pattern makeChoice(Pattern pattern, Pattern pattern2) {
        if (pattern == this.notAllowed || pattern == pattern2) {
            return pattern2;
        }
        if (pattern2 == this.notAllowed) {
            return pattern;
        }
        return super.makeChoice(pattern, pattern2);
    }

    Pattern makeList(Pattern pattern, Locator locator) {
        if (pattern == this.notAllowed) {
            return pattern;
        }
        ListPattern listPattern = new ListPattern(pattern, locator);
        return this.schemaInterner.intern(listPattern);
    }

    Pattern makeMixed(Pattern pattern) {
        return this.makeInterleave(this.text, pattern);
    }

    private void noteDatatype(Datatype datatype) {
        if (datatype.getIdType() != 0) {
            this.idTypes = true;
        }
    }
}

