/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import sun.tools.attach.HotSpotVirtualMachine;

public class AixVirtualMachine
extends HotSpotVirtualMachine {
    String path;
    private static final String PROTOCOL_VERSION = "1";
    private static final int ATTACH_ERROR_BADVERSION = 101;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AixVirtualMachine(AttachProvider attachProvider, String string) throws AttachNotSupportedException, IOException {
        super(attachProvider, string);
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AttachNotSupportedException("Invalid process identifier");
        }
        this.path = this.findSocketFile(n);
        if (this.path == null) {
            File file = this.createAttachFile(n);
            try {
                AixVirtualMachine.sendQuitTo(n);
                int n2 = 0;
                do {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.path = this.findSocketFile(n);
                } while (++n2 <= 10 && this.path == null);
                if (this.path == null) {
                    throw new AttachNotSupportedException("Unable to open socket file");
                }
            }
            finally {
                file.delete();
            }
        }
        AixVirtualMachine.checkPermissions(this.path);
        int n3 = AixVirtualMachine.socket();
        try {
            AixVirtualMachine.connect(n3, this.path);
        }
        finally {
            AixVirtualMachine.close(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() throws IOException {
        AixVirtualMachine aixVirtualMachine = this;
        synchronized (aixVirtualMachine) {
            if (this.path != null) {
                this.path = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream execute(String string, Object ... objectArray) throws AgentLoadException, IOException {
        int n;
        String string2;
        assert (objectArray.length <= 3);
        AixVirtualMachine aixVirtualMachine = this;
        synchronized (aixVirtualMachine) {
            if (this.path == null) {
                throw new IOException("Detached from target VM");
            }
            string2 = this.path;
        }
        int n2 = AixVirtualMachine.socket();
        try {
            AixVirtualMachine.connect(n2, string2);
        }
        catch (IOException iOException) {
            AixVirtualMachine.close(n2);
            throw iOException;
        }
        IOException iOException = null;
        try {
            this.writeString(n2, PROTOCOL_VERSION);
            this.writeString(n2, string);
            for (int i = 0; i < 3; ++i) {
                if (i < objectArray.length && objectArray[i] != null) {
                    this.writeString(n2, (String)objectArray[i]);
                    continue;
                }
                this.writeString(n2, "");
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        SocketInputStream socketInputStream = new SocketInputStream(n2);
        try {
            n = this.readInt(socketInputStream);
        }
        catch (IOException iOException3) {
            socketInputStream.close();
            if (iOException != null) {
                throw iOException;
            }
            throw iOException3;
        }
        if (n != 0) {
            socketInputStream.close();
            if (n == 101) {
                throw new IOException("Protocol mismatch with target VM");
            }
            if (string.equals("load")) {
                throw new AgentLoadException("Failed to load agent library");
            }
            throw new IOException("Command failed in target VM");
        }
        return socketInputStream;
    }

    private String findSocketFile(int n) {
        String string = ".java_pid" + n;
        String string2 = "/proc/" + n + "/cwd/" + string;
        File file = new File(string2);
        if (!file.exists() && !(file = new File(string2 = "/tmp/" + string)).exists()) {
            return null;
        }
        return string2;
    }

    private File createAttachFile(int n) throws IOException {
        String string = ".attach_pid" + n;
        String string2 = "/proc/" + n + "/cwd/" + string;
        File file = new File(string2);
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            string2 = "/tmp/" + string;
            file = new File(string2);
            file.createNewFile();
        }
        return file;
    }

    private void writeString(int n, String string) throws IOException {
        byte[] byArray;
        if (string.length() > 0) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError();
            }
            AixVirtualMachine.write(n, byArray, 0, byArray.length);
        }
        byArray = new byte[]{0};
        AixVirtualMachine.write(n, byArray, 0, 1);
    }

    static native int getAixThreadsManager(int var0) throws IOException;

    static native void sendQuitToChildrenOf(int var0) throws IOException;

    static native void sendQuitTo(int var0) throws IOException;

    static native void checkPermissions(String var0) throws IOException;

    static native int socket() throws IOException;

    static native void connect(int var0, String var1) throws IOException;

    static native void close(int var0) throws IOException;

    static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void write(int var0, byte[] var1, int var2, int var3) throws IOException;

    static {
        System.loadLibrary("attach");
    }

    private class SocketInputStream
    extends InputStream {
        int s;

        public SocketInputStream(int n) {
            this.s = n;
        }

        public synchronized int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            return AixVirtualMachine.read(this.s, byArray, n, n2);
        }

        public void close() throws IOException {
            AixVirtualMachine.close(this.s);
        }
    }
}

