/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;

class AuthProxy
extends Proxy {
    String user = null;
    String password = null;

    AuthProxy(Proxy.Type type, SocketAddress sa) {
        super(type, sa);
    }

    AuthProxy(Proxy.Type type, SocketAddress sa, String username, String passwd) {
        super(type, sa);
        this.user = username;
        this.password = passwd;
        if (this.user != null) {
            Authenticator.setDefault(new MyAuthenticator());
        }
    }

    static AuthProxy newProxy(URL proxyURL) {
        String pHost = proxyURL.getHost();
        int pPort = proxyURL.getPort();
        String userInfo = proxyURL.getUserInfo();
        String user = null;
        String password = null;
        if (pPort < 0) {
            pPort = 80;
        }
        if (userInfo != null && userInfo.length() != 0) {
            String[] tokens = userInfo.split(":", 2);
            user = tokens[0];
            password = tokens[1];
        }
        InetSocketAddress addr = new InetSocketAddress(pHost, pPort);
        return new AuthProxy(Proxy.Type.HTTP, addr, user, password);
    }

    public String toString() {
        String s = "";
        InetSocketAddress ia = (InetSocketAddress)this.address();
        switch (this.type()) {
            case DIRECT: {
                s = "Direct";
                break;
            }
            case HTTP: {
                s = "http://";
                break;
            }
            case SOCKS: {
                s = "socks:";
                break;
            }
            default: {
                s = "";
            }
        }
        if (this.user == null) {
            return s + ia.getHostName() + ":" + ia.getPort();
        }
        StringBuffer sb = new StringBuffer("");
        if (this.password != null) {
            for (int n = this.password.length(); n > 0; --n) {
                sb.append('*');
            }
        }
        return s + this.user + ":" + sb + "@" + ia.getHostName() + ":" + ia.getPort();
    }

    private class MyAuthenticator
    extends Authenticator {
        private MyAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
                return null;
            }
            String protocol = this.getRequestingProtocol();
            if (!protocol.equalsIgnoreCase("http")) {
                return null;
            }
            if (AuthProxy.this.user == null) {
                return null;
            }
            return new PasswordAuthentication(AuthProxy.this.user, AuthProxy.this.password == null ? null : AuthProxy.this.password.toCharArray());
        }
    }
}

