/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.WriteableView;
import org.jvnet.tiger_types.Types;

@Service
@Scoped(value=Singleton.class)
public class ConfigSupport {
    @Inject
    Habitat habitat;
    public static int lockTimeOutInSeconds = Integer.getInteger("org.glassfish.hk2.config.locktimeout", 3);

    public static <T extends ConfigBeanProxy> Object apply(final SingleConfigCode<T> code, T param) throws TransactionFailure {
        ConfigBeanProxy[] objects = new ConfigBeanProxy[]{param};
        return ConfigSupport.apply(new ConfigCode(){

            @Override
            public Object run(ConfigBeanProxy ... objects) throws PropertyVetoException, TransactionFailure {
                return code.run(objects[0]);
            }
        }, objects);
    }

    public static Object apply(ConfigCode code, ConfigBeanProxy ... objects) throws TransactionFailure {
        ConfigBean source = (ConfigBean)ConfigBean.unwrap(objects[0]);
        return ((ConfigSupport)source.getHabitat().getComponent(ConfigSupport.class))._apply(code, objects);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _apply(ConfigCode code, ConfigBeanProxy ... objects) throws TransactionFailure {
        WriteableView[] views = new WriteableView[objects.length];
        ConfigBeanProxy[] proxies = new ConfigBeanProxy[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            proxies[i] = this.getWriteableView(objects[i]);
            views[i] = (WriteableView)Proxy.getInvocationHandler(proxies[i]);
        }
        Transaction t = new Transaction();
        for (WriteableView view : views) {
            if (view.join(t)) continue;
            t.rollback();
            throw new TransactionFailure("Cannot enlist " + view.getMasterView().getProxyType() + " in transaction", null);
        }
        try {
            Object toReturn = code.run(proxies);
            try {
                t.commit();
                if (toReturn instanceof WriteableView) {
                    return ((WriteableView)toReturn).getMasterView();
                }
                return toReturn;
            }
            catch (RetryableException e) {
                System.out.println("Retryable...");
                t.rollback();
                return null;
            }
            catch (TransactionFailure e) {
                t.rollback();
                throw e;
            }
        }
        catch (UndeclaredThrowableException e) {
            t.rollback();
            Throwable throwable = e.getCause();
            if (throwable instanceof PropertyVetoException) {
                throw new TransactionFailure(throwable.toString(), throwable);
            }
            throw new TransactionFailure(e.toString(), e);
        }
        catch (TransactionFailure e) {
            t.rollback();
            throw e;
        }
        catch (Exception e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), e);
        }
    }

    static <T extends ConfigBeanProxy> WriteableView getWriteableView(T s, ConfigBean sourceBean) throws TransactionFailure {
        WriteableView f = new WriteableView(s);
        try {
            if (sourceBean.getLock().tryLock(lockTimeOutInSeconds, TimeUnit.SECONDS)) {
                return f;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new TransactionFailure("Config bean already locked " + sourceBean, null);
    }

    public <T extends ConfigBeanProxy> T getWriteableView(T source) throws TransactionFailure {
        ConfigView sourceBean = (ConfigView)Proxy.getInvocationHandler(source);
        WriteableView writeableView = ConfigSupport.getWriteableView(source, (ConfigBean)sourceBean.getMasterView());
        return writeableView.getProxy(sourceBean.getProxyType());
    }

    public static ConfigView getImpl(ConfigBeanProxy source) {
        InvocationHandler bean = Proxy.getInvocationHandler(source);
        if (bean instanceof ConfigView) {
            return ((ConfigView)bean).getMasterView();
        }
        return (ConfigBean)bean;
    }

    public static <T extends ConfigBeanProxy> Class<T> proxyType(T element) {
        ConfigView bean = ConfigSupport.getImpl(element);
        return bean.getProxyType();
    }

    public static UnprocessedChangeEvents sortAndDispatch(PropertyChangeEvent[] events, Changed target, Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<UnprocessedChangeEvent> unprocessed = new ArrayList<UnprocessedChangeEvent>();
        ArrayList<Dom> added = new ArrayList<Dom>();
        ArrayList<Dom> changed = new ArrayList<Dom>();
        for (PropertyChangeEvent event : events) {
            if (event.getOldValue() != null || !(event.getNewValue() instanceof ConfigBeanProxy)) continue;
            try {
                ConfigBeanProxy proxy = (ConfigBeanProxy)ConfigBeanProxy.class.cast(event.getNewValue());
                added.add(Dom.unwrap(proxy));
                NotProcessed nc = target.changed(Changed.TYPE.ADD, ConfigSupport.proxyType(proxy), proxy);
                if (nc == null) continue;
                unprocessed.add(new UnprocessedChangeEvent(event, nc.getReason()));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while processing config bean changes : ", e);
            }
        }
        for (PropertyChangeEvent event : events) {
            try {
                NotProcessed nc;
                Dom eventSource = Dom.unwrap((ConfigBeanProxy)event.getSource());
                if (added.contains(eventSource)) continue;
                ConfigBeanProxy proxy = null;
                if (event.getNewValue() == null) {
                    try {
                        proxy = (ConfigBeanProxy)ConfigBeanProxy.class.cast(event.getOldValue());
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    if (proxy != null) {
                        nc = target.changed(Changed.TYPE.REMOVE, ConfigSupport.proxyType(proxy), proxy);
                        if (nc == null) continue;
                        unprocessed.add(new UnprocessedChangeEvent(event, nc.getReason()));
                        continue;
                    }
                }
                if (changed.contains(eventSource)) continue;
                proxy = (ConfigBeanProxy)ConfigBeanProxy.class.cast(event.getSource());
                changed.add(eventSource);
                nc = target.changed(Changed.TYPE.CHANGE, ConfigSupport.proxyType(proxy), proxy);
                if (nc == null) continue;
                unprocessed.add(new UnprocessedChangeEvent(event, nc.getReason()));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while processing config bean changes : ", e);
            }
        }
        return new UnprocessedChangeEvents(unprocessed);
    }

    private static List<String> defaultPropertyValue() {
        return null;
    }

    public void apply(Map<ConfigBean, Map<String, String>> mapOfChanges) throws TransactionFailure {
        Transaction t = new Transaction();
        try {
            for (Map.Entry<ConfigBean, Map<String, String>> configBeanChange : mapOfChanges.entrySet()) {
                ConfigBean source = configBeanChange.getKey();
                Object readableView = source.getProxy(source.getProxyType());
                WriteableView writeable = ConfigSupport.getWriteableView(readableView, source);
                if (!writeable.join(t)) {
                    t.rollback();
                    throw new TransactionFailure("Cannot enlist " + source.getProxyType() + " in transaction", null);
                }
                for (Map.Entry<String, String> change : configBeanChange.getValue().entrySet()) {
                    String xmlName = change.getKey();
                    ConfigModel.Property prop = writeable.getProperty(xmlName);
                    if (prop == null) {
                        throw new TransactionFailure("Unknown property name " + xmlName + " on " + source.getProxyType(), null);
                    }
                    if (prop.isCollection()) {
                        try {
                            List values = (List)writeable.getter(prop, ConfigSupport.class.getDeclaredMethod("defaultPropertyValue", null).getGenericReturnType());
                            values.add(change.getValue());
                            continue;
                        }
                        catch (NoSuchMethodException e) {
                            throw new TransactionFailure("Unknown property name " + xmlName + " on " + source.getProxyType(), null);
                        }
                    }
                    writeable.setter(prop, change.getValue(), (Type)((Object)String.class));
                }
            }
        }
        catch (TransactionFailure e) {
            t.rollback();
            throw e;
        }
        catch (Exception e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), e);
        }
        try {
            t.commit();
        }
        catch (RetryableException e) {
            System.out.println("Retryable...");
            t.rollback();
            throw new TransactionFailure(e.getMessage(), e);
        }
        catch (TransactionFailure e) {
            System.out.println("failure, not retryable...");
            t.rollback();
            throw e;
        }
    }

    public static Class<?>[] getSubElementsTypes(ConfigBean bean) throws ClassNotFoundException {
        ArrayList subTypes = new ArrayList();
        for (ConfigModel.Property element : bean.model.elements.values()) {
            if (!element.isLeaf()) {
                ConfigModel elementModel = ((ConfigModel.Node)element).model;
                Class<?> subType = ((ClassLoader)elementModel.classLoaderHolder.get()).loadClass(elementModel.targetTypeName);
                subTypes.add(subType);
                continue;
            }
            if (!element.isCollection()) continue;
            subTypes.add(List.class);
        }
        return subTypes.toArray(new Class[subTypes.size()]);
    }

    public String[] getAttributesNames(ConfigBean bean) {
        return this.xmlNames(bean.model.attributes.values());
    }

    public String[] getElementsNames(ConfigBean bean) {
        return this.xmlNames(bean.model.elements.values());
    }

    private String[] xmlNames(Collection<? extends ConfigModel.Property> properties) {
        ArrayList<String> names = new ArrayList<String>();
        for (ConfigModel.Property property : properties) {
            names.add(property.xmlName());
        }
        return names.toArray(new String[names.size()]);
    }

    public static ConfigBean createAndSet(ConfigBean parent, Class<? extends ConfigBeanProxy> childType, Map<String, String> attributes, TransactionCallBack<WriteableView> runnable) throws TransactionFailure {
        return ConfigSupport.createAndSet(parent, childType, AttributeChanges.from(attributes), runnable);
    }

    public static ConfigBean createAndSet(ConfigBean parent, Class<? extends ConfigBeanProxy> childType, List<AttributeChanges> attributes, TransactionCallBack<WriteableView> runnable) throws TransactionFailure {
        return ((ConfigSupport)parent.getHabitat().getComponent(ConfigSupport.class))._createAndSet(parent, childType, attributes, runnable);
    }

    ConfigBean _createAndSet(final ConfigBean parent, final Class<? extends ConfigBeanProxy> childType, final List<AttributeChanges> attributes, final TransactionCallBack<WriteableView> runnable) throws TransactionFailure {
        Object readableView = parent.getProxy(parent.getProxyType());
        ConfigBeanProxy readableChild = (ConfigBeanProxy)ConfigSupport.apply(new SingleConfigCode<ConfigBeanProxy>(){

            @Override
            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Object child = param.createChild(childType);
                Dom dom = Dom.unwrap(child);
                WriteableView writeableParent = (WriteableView)Proxy.getInvocationHandler(param);
                Class parentProxyType = parent.getProxyType();
                Class<?> targetClass = null;
                ConfigModel.Property element = null;
                for (ConfigModel.Property e : parent.model.elements.values()) {
                    if (e.isLeaf()) continue;
                    ConfigModel elementModel = ((ConfigModel.Node)e).model;
                    if (Logger.getAnonymousLogger().isLoggable(Level.FINE)) {
                        Logger.getAnonymousLogger().fine("elementModel.targetTypeName = " + elementModel.targetTypeName + ", collection: " + e.isCollection() + ", childType.getName() = " + childType.getName());
                    }
                    if (elementModel.targetTypeName.equals(childType.getName())) {
                        element = e;
                        break;
                    }
                    if (!e.isCollection()) continue;
                    try {
                        Class<?> tempClass = ((ClassLoader)elementModel.classLoaderHolder.get()).loadClass(elementModel.targetTypeName);
                        if (!tempClass.isAssignableFrom(childType)) continue;
                        element = e;
                        targetClass = tempClass;
                        break;
                    }
                    catch (Exception ex) {
                        throw new TransactionFailure("EXCEPTION getting class for " + elementModel.targetTypeName, ex);
                    }
                }
                if (element != null) {
                    if (element.isCollection()) {
                        for (Method m : parentProxyType.getMethods()) {
                            Class<?> returnType = m.getReturnType();
                            if (!Collection.class.isAssignableFrom(returnType)) continue;
                            if (!(m.getGenericReturnType() instanceof ParameterizedType)) {
                                throw new IllegalArgumentException("List needs to be parameterized");
                            }
                            Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)m.getGenericReturnType(), (int)0));
                            if (!itemType.isAssignableFrom(childType)) continue;
                            List list = null;
                            try {
                                list = (List)m.invoke((Object)param, null);
                            }
                            catch (IllegalAccessException e) {
                                throw new TransactionFailure("Exception while adding to the parent", e);
                            }
                            catch (InvocationTargetException e) {
                                throw new TransactionFailure("Exception while adding to the parent", e);
                            }
                            if (list == null) continue;
                            list.add(child);
                            break;
                        }
                    } else {
                        writeableParent.setter(element, dom.createProxy(), childType);
                    }
                } else {
                    throw new TransactionFailure("Parent " + parent.getProxyType() + " does not have a child of type " + childType);
                }
                WriteableView writeableChild = (WriteableView)Proxy.getInvocationHandler(child);
                ConfigSupport.this.applyProperties(writeableChild, attributes);
                dom.addDefaultChildren();
                dom.register();
                if (runnable != null) {
                    runnable.performOn(writeableChild);
                }
                return child;
            }
        }, readableView);
        return (ConfigBean)Dom.unwrap(readableChild);
    }

    private void applyProperties(WriteableView target, List<? extends AttributeChanges> changes) throws TransactionFailure {
        if (changes != null) {
            for (AttributeChanges attributeChanges : changes) {
                ConfigModel.Property prop = target.getProperty(attributeChanges.name);
                if (prop == null) {
                    throw new TransactionFailure("Unknown property name " + attributeChanges.name + " on " + target.getProxyType());
                }
                if (prop.isCollection()) {
                    try {
                        List list = (List)target.getter(prop, ConfigSupport.class.getDeclaredMethod("defaultPropertyValue", null).getGenericReturnType());
                        for (String value : attributeChanges.values()) {
                            list.add(value);
                        }
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        throw new TransactionFailure(e.getMessage(), e);
                    }
                }
                target.setter(prop, attributeChanges.values()[0], (Type)((Object)String.class));
            }
        }
    }

    public static ConfigBean createAndSet(ConfigBean parent, Class<? extends ConfigBeanProxy> childType, Map<String, String> attributes) throws TransactionFailure {
        return ConfigSupport.createAndSet(parent, childType, attributes, null);
    }

    public ConfigBean createAndSet(ConfigBean parent, Class<? extends ConfigBeanProxy> childType, List<AttributeChanges> attributes) throws TransactionFailure {
        return ConfigSupport.createAndSet(parent, childType, attributes, null);
    }

    public static void deleteChild(final ConfigBean parent, final ConfigBean child) throws TransactionFailure {
        Object readableView = parent.getProxy(parent.getProxyType());
        ConfigSupport.apply(new SingleConfigCode<ConfigBeanProxy>(){

            @Override
            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                WriteableView writeableParent = (WriteableView)Proxy.getInvocationHandler(param);
                ConfigSupport._deleteChild(parent, writeableParent, child);
                return child;
            }
        }, readableView);
    }

    public static void _deleteChild(ConfigBean parent, WriteableView writeableParent, ConfigBean child) throws TransactionFailure {
        Class childType = child.getProxyType();
        Object childProxy = child.getProxy(childType);
        Class parentProxyType = parent.getProxyType();
        ConfigModel.Property element = null;
        for (ConfigModel.Property e : parent.model.elements.values()) {
            if (!(e instanceof ConfigModel.Node)) continue;
            ConfigModel elementModel = ((ConfigModel.Node)e).model;
            try {
                Class targetClass = ((ClassLoader)parent.model.classLoaderHolder.get()).loadClass(elementModel.targetTypeName);
                if (!targetClass.isAssignableFrom(childType)) continue;
                element = e;
                break;
            }
            catch (Exception ex) {
            }
        }
        if (element != null) {
            if (element.isCollection()) {
                for (Method m : parentProxyType.getMethods()) {
                    Class<?> returnType = m.getReturnType();
                    if (!Collection.class.isAssignableFrom(returnType) || m.getParameterTypes().length != 0) continue;
                    if (!(m.getGenericReturnType() instanceof ParameterizedType)) {
                        throw new IllegalArgumentException("List needs to be parameterized");
                    }
                    Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)m.getGenericReturnType(), (int)0));
                    if (!itemType.isAssignableFrom(childType)) continue;
                    List list = null;
                    try {
                        list = (List)m.invoke(writeableParent.getProxy(writeableParent.getProxyType()), null);
                    }
                    catch (IllegalAccessException e) {
                        throw new TransactionFailure("Exception while adding to the parent", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new TransactionFailure("Exception while adding to the parent", e);
                    }
                    if (list == null) continue;
                    list.remove(childProxy);
                    break;
                }
            } else {
                writeableParent.setter(element, null, childType);
            }
        } else {
            throw new TransactionFailure("Parent " + parent.getProxyType() + " does not have a child of type " + childType);
        }
    }

    public static Class<? extends ConfigBeanProxy> getElementTypeByName(ConfigBeanProxy parent, String elementName) throws ClassNotFoundException {
        Dom parentDom = Dom.unwrap(parent);
        DomDocument document = parentDom.document;
        ConfigModel.Property a = parentDom.model.elements.get(elementName);
        if (a != null) {
            if (a.isLeaf()) {
                return null;
            }
            ConfigModel childModel = ((ConfigModel.Node)a).model;
            return ((ClassLoader)childModel.classLoaderHolder.get()).loadClass(childModel.targetTypeName);
        }
        ConfigModel model = document.getModelByElementName(elementName);
        if (model != null) {
            return ((ClassLoader)model.classLoaderHolder.get()).loadClass(model.targetTypeName);
        }
        return null;
    }

    public static abstract class AttributeChanges {
        final String name;

        AttributeChanges(String name) {
            this.name = name;
        }

        abstract String[] values();

        static List<AttributeChanges> from(Map<String, String> values) {
            if (values == null) {
                return null;
            }
            ArrayList<AttributeChanges> changes = new ArrayList<AttributeChanges>();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                changes.add(new SingleAttributeChange(entry.getKey(), entry.getValue()));
            }
            return changes;
        }
    }

    public static class MultipleAttributeChanges
    extends AttributeChanges {
        final String[] values;

        public MultipleAttributeChanges(String name, String[] values) {
            super(name);
            this.values = values;
        }

        @Override
        String[] values() {
            return this.values;
        }
    }

    public static class SingleAttributeChange
    extends AttributeChanges {
        final String[] values = new String[1];

        public SingleAttributeChange(String name, String value) {
            super(name);
            this.values[0] = value;
        }

        @Override
        String[] values() {
            return this.values;
        }
    }

    public static interface TransactionCallBack<T> {
        public void performOn(T var1) throws TransactionFailure;
    }
}

