/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.osgi;

import com.sun.enterprise.glassfish.bootstrap.osgi.EmbeddedOSGiGlassFishRuntimeBuilder;
import com.sun.enterprise.glassfish.bootstrap.osgi.OSGiGlassFishRuntime;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;

public class GlassFishMainActivator
implements BundleActivator {
    private BundleContext context;
    private String installRoot;
    private static volatile GlassFishRuntime gfr;
    private GlassFish gf;
    private static final String[] DEFAULT_INSTALLATION_LOCATIONS_RELATIVE;
    private static final String[] DEFAULT_START_LOCATIONS_RELATIVE;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (this.nonEmbedded()) {
            Framework framework = (Framework)context.getBundle(0L);
            gfr = new OSGiGlassFishRuntime(framework);
            context.registerService(GlassFishRuntime.class.getName(), (Object)gfr, null);
        } else {
            Properties properties = this.prepareStartupContext(context);
            BootstrapProperties bsProperties = new BootstrapProperties(properties);
            if (gfr == null) {
                gfr = GlassFishRuntime.bootstrap(bsProperties, this.getClass().getClassLoader());
            }
            this.gf = gfr.newGlassFish(new GlassFishProperties(properties));
            this.gf.start();
        }
    }

    private boolean nonEmbedded() {
        return this.context.getProperty("GlassFish.BUILDER_NAME") != null;
    }

    private Properties prepareStartupContext(BundleContext context) {
        Properties properties = new Properties();
        this.installRoot = context.getProperty("com.sun.aas.installRoot");
        if (this.installRoot == null) {
            this.installRoot = this.guessInstallRoot(context);
            if (this.installRoot == null) {
                throw new RuntimeException("Property named com.sun.aas.installRoot is not set.");
            }
            System.out.println("Deduced install root as : " + this.installRoot + " from location of bundle. " + "If this is not correct, set correct value in a property called " + "com.sun.aas.installRoot");
        }
        if (!new File(this.installRoot).exists()) {
            throw new RuntimeException("No such directory: [" + this.installRoot + "]");
        }
        properties.setProperty("com.sun.aas.installRoot", this.installRoot);
        String instanceRoot = context.getProperty("com.sun.aas.instanceRoot");
        if (instanceRoot == null) {
            instanceRoot = new File(this.installRoot, "domains/domain1/").getAbsolutePath();
        }
        properties.setProperty("com.sun.aas.instanceRoot", instanceRoot);
        properties.putAll((Map<?, ?>)this.makeProvisioningOptions());
        properties.setProperty("GlassFish.BUILDER_NAME", EmbeddedOSGiGlassFishRuntimeBuilder.class.getName());
        return properties;
    }

    private String guessInstallRoot(BundleContext context) {
        String location = context.getBundle().getLocation();
        try {
            URI uri = URI.create(location);
            File f = new File(uri);
            if (f.exists() && f.isFile() && f.getParentFile().getCanonicalPath().endsWith("modules") && f.getParentFile().getParentFile().getCanonicalPath().endsWith("glassfish")) {
                return f.getParentFile().getParentFile().getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Properties makeProvisioningOptions() {
        Properties provisioningOptions = new Properties();
        URI installURI = new File(this.installRoot).toURI();
        String installLocations = this.getBundleContext().getProperty("glassfish.osgi.auto.install");
        if (installLocations == null) {
            StringBuilder defaultInstallLocations = new StringBuilder();
            for (String entry : DEFAULT_INSTALLATION_LOCATIONS_RELATIVE) {
                defaultInstallLocations.append(installURI.resolve(entry).toString()).append(" ");
            }
            installLocations = defaultInstallLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.install", installLocations);
        String startLocations = this.getBundleContext().getProperty("glassfish.osgi.auto.start");
        if (startLocations == null) {
            StringBuilder deafultStartLocations = new StringBuilder();
            for (String entry : DEFAULT_START_LOCATIONS_RELATIVE) {
                deafultStartLocations.append(installURI.resolve(entry).toString()).append(" ");
            }
            startLocations = deafultStartLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.start", startLocations);
        System.out.println("Provisioning options are " + provisioningOptions);
        return provisioningOptions;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.gf != null) {
            this.gf.stop();
            this.gf.dispose();
            this.gf = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    static {
        DEFAULT_INSTALLATION_LOCATIONS_RELATIVE = new String[]{"modules/endorsed/", "modules/", "modules/autostart/"};
        DEFAULT_START_LOCATIONS_RELATIVE = new String[]{"modules/endorsed/", "modules/osgi-adapter.jar", "modules/osgi-resource-locator.jar", "modules/org.apache.felix.configadmin.jar", "modules/org.apache.felix.fileinstall.jar", "modules/autostart/"};
    }
}

