/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.services.impl.GrizzlyListener;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicConfigListener
implements ConfigListener {
    private static final String ADMIN_LISTENER = "admin-listener";
    private GrizzlyService grizzlyService;
    private Config config;
    private Logger logger;
    private static final int RECONFIG_LOCK_TIMEOUT_SEC = 30;
    private static final ReentrantLock reconfigLock = new ReentrantLock();
    private static final Map<Integer, GrizzlyProxy.GrizzlyFuture> reconfigByPortLock = new HashMap<Integer, GrizzlyProxy.GrizzlyFuture>();

    public DynamicConfigListener(Config parent) {
        this.config = parent;
    }

    public synchronized UnprocessedChangeEvents changed(final PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (DynamicConfigListener.this.logger.isLoggable(Level.FINE)) {
                    DynamicConfigListener.this.logger.log(Level.FINE, "NetworkConfig changed {0} {1} {2}", new Object[]{type, tClass, t});
                }
                if (tClass == NetworkListener.class) {
                    return DynamicConfigListener.this.processNetworkListener(type, (NetworkListener)t, events);
                }
                if (tClass == Http.class) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t.getParent(), events);
                }
                if (tClass == FileCache.class) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t.getParent().getParent(), null);
                }
                if (tClass == Ssl.class) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t.getParent(), null);
                }
                if (tClass == Protocol.class) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t, null);
                }
                if (tClass == ThreadPool.class) {
                    NotProcessed notProcessed = null;
                    for (NetworkListener listener : ((ThreadPool)t).findNetworkListeners()) {
                        notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener, null);
                    }
                    return notProcessed;
                }
                if (tClass == Transport.class) {
                    NotProcessed notProcessed = null;
                    for (NetworkListener listener : ((Transport)t).findNetworkListeners()) {
                        notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener, null);
                    }
                    return notProcessed;
                }
                if (tClass == VirtualServer.class && !DynamicConfigListener.this.grizzlyService.hasMapperUpdateListener()) {
                    return DynamicConfigListener.this.processVirtualServer(type, (VirtualServer)t);
                }
                if (tClass == SystemProperty.class) {
                    NetworkConfig networkConfig = DynamicConfigListener.this.config.getNetworkConfig();
                    if (networkConfig != null && ((SystemProperty)t).getName().endsWith("LISTENER_PORT")) {
                        for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
                            if (!listener.getPort().equals(((SystemProperty)t).getValue())) continue;
                            return DynamicConfigListener.this.processNetworkListener(Changed.TYPE.CHANGE, listener, events);
                        }
                    }
                    return null;
                }
                return null;
            }
        }, (Logger)this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigBeanProxy> NotProcessed processNetworkListener(Changed.TYPE type, NetworkListener listener, PropertyChangeEvent[] changedProperties) {
        if (this.findConfigName((ConfigBeanProxy)listener).equals(this.findConfigName((ConfigBeanProxy)this.config))) {
            boolean isAdminListener = ADMIN_LISTENER.equals(listener.getName());
            Lock portLock = null;
            try {
                portLock = this.acquirePortLock(listener);
                if (type == Changed.TYPE.ADD) {
                    int[] ports = portLock.getPorts();
                    if (isAdminListener && ports[ports.length - 1] == -1) {
                        NotProcessed notProcessed = null;
                        return notProcessed;
                    }
                    Future<Result<Thread>> future = this.grizzlyService.createNetworkProxy(listener);
                    if (future != null) {
                        future.get(30L, TimeUnit.SECONDS);
                        this.grizzlyService.registerNetworkProxy();
                    } else {
                        this.logger.log(Level.FINE, "Skipping proxy registration for the listener {0}", listener.getName());
                    }
                } else if (type == Changed.TYPE.REMOVE) {
                    if (!isAdminListener) {
                        this.grizzlyService.removeNetworkProxy(listener);
                    }
                } else if (type == Changed.TYPE.CHANGE) {
                    Future<Result<Thread>> future;
                    if (isAdminListener) {
                        GrizzlyProxy proxy;
                        boolean dynamic = this.isAdminDynamic(changedProperties);
                        if (dynamic && (proxy = (GrizzlyProxy)this.grizzlyService.lookupNetworkProxy(listener)) != null) {
                            GrizzlyListener netListener = proxy.getUnderlyingListener();
                            netListener.processDynamicConfigurationChange(this.grizzlyService.getHabitat(), changedProperties);
                            NotProcessed notProcessed = null;
                            return notProcessed;
                        }
                        NotProcessed notProcessed = null;
                        return notProcessed;
                    }
                    if (!this.grizzlyService.removeNetworkProxy(listener)) {
                        this.grizzlyService.removeNetworkProxy(listener.getName());
                    }
                    if ((future = this.grizzlyService.createNetworkProxy(listener)) != null) {
                        future.get(30L, TimeUnit.SECONDS);
                        this.grizzlyService.registerNetworkProxy();
                    } else {
                        this.logger.log(Level.FINE, "Skipping proxy registration for the listener {0}", listener.getName());
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Network listener configuration error. Type: " + type, e);
            }
            finally {
                if (portLock != null) {
                    this.releaseListenerLock(portLock);
                }
            }
        }
        return null;
    }

    private String findConfigName(ConfigBeanProxy child) {
        ConfigBeanProxy bean;
        for (bean = child; bean != null && !(bean instanceof Config); bean = bean.getParent()) {
        }
        return bean instanceof Config ? ((Config)bean).getName() : "";
    }

    private boolean isAdminDynamic(PropertyChangeEvent[] events) {
        if (events == null || events.length == 0) {
            return false;
        }
        for (PropertyChangeEvent e : events) {
            if (!"comet-support-enabled".equals(e.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    private NotProcessed processProtocol(Changed.TYPE type, Protocol protocol, PropertyChangeEvent[] events) {
        NotProcessed notProcessed = null;
        for (NetworkListener listener : protocol.findNetworkListeners()) {
            notProcessed = this.processNetworkListener(type, listener, events);
        }
        return notProcessed;
    }

    private NotProcessed processVirtualServer(Changed.TYPE type, VirtualServer vs) {
        NotProcessed notProcessed = null;
        String list = vs.getNetworkListeners();
        if (list != null) {
            for (String s : GrizzlyProxy.toArray(list, ",")) {
                for (NetworkListener n : vs.findNetworkListeners()) {
                    if (!s.equals(n.getName())) continue;
                    notProcessed = this.processNetworkListener(type, n, null);
                }
            }
        }
        return notProcessed;
    }

    public void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private Lock acquirePortLock(NetworkListener listener) throws InterruptedException, TimeoutException {
        boolean isLoggingFinest = this.logger.isLoggable(Level.FINEST);
        int port = this.getPort(listener);
        try {
            while (true) {
                NetworkProxy runningProxy;
                this.logger.finest("Aquire reconfig lock");
                if (!reconfigLock.tryLock(30L, TimeUnit.SECONDS)) break;
                Future lock = reconfigByPortLock.get(port);
                if (isLoggingFinest) {
                    this.logger.log(Level.FINEST, "Reconfig lock for port: {0} is {1}", new Object[]{port, lock});
                }
                int proxyPort = -1;
                if (lock == null && (runningProxy = this.grizzlyService.lookupNetworkProxy(listener)) != null) {
                    proxyPort = runningProxy.getPort();
                    if (port != proxyPort) {
                        lock = reconfigByPortLock.get(proxyPort);
                        if (isLoggingFinest) {
                            this.logger.log(Level.FINEST, "Reconfig lock for proxyport: {0} is {1}", new Object[]{proxyPort, lock});
                        }
                    } else {
                        proxyPort = -1;
                    }
                }
                if (lock != null) {
                    reconfigLock.unlock();
                    try {
                        this.logger.finest("Waiting on reconfig lock");
                        lock.get(30L, TimeUnit.SECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    GrizzlyProxy.GrizzlyFuture future = new GrizzlyProxy.GrizzlyFuture();
                    if (isLoggingFinest) {
                        this.logger.log(Level.FINEST, "Set reconfig lock for ports: {0} and {1}: {2}", new Object[]{port, proxyPort, future});
                    }
                    reconfigByPortLock.put(port, future);
                    if (proxyPort != -1) {
                        reconfigByPortLock.put(proxyPort, future);
                    }
                    Lock lock2 = new Lock(port, proxyPort);
                    return lock2;
                }
            }
            throw new TimeoutException("Lock timeout");
        }
        finally {
            if (reconfigLock.isHeldByCurrentThread()) {
                reconfigLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseListenerLock(Lock lock) {
        boolean isLoggingFinest = this.logger.isLoggable(Level.FINEST);
        reconfigLock.lock();
        try {
            int[] ports = lock.getPorts();
            if (isLoggingFinest) {
                this.logger.log(Level.FINEST, "Release reconfig lock for ports: {0}", Arrays.toString(ports));
            }
            GrizzlyProxy.GrizzlyFuture future = null;
            for (int port : ports) {
                if (port == -1) continue;
                future = reconfigByPortLock.remove(port);
            }
            if (future != null) {
                if (isLoggingFinest) {
                    this.logger.log(Level.FINEST, "Release reconfig lock, set result: {0}", future);
                }
                future.setResult((Result<Thread>)new Result((Object)Thread.currentThread()));
            }
        }
        finally {
            reconfigLock.unlock();
        }
    }

    private int getPort(NetworkListener listener) {
        int listenerPort;
        block2: {
            listenerPort = -1;
            try {
                listenerPort = Integer.parseInt(listener.getPort());
            }
            catch (NumberFormatException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block2;
                this.logger.log(Level.WARNING, "Can not parse network-listener port number: {0}", listener.getPort());
            }
        }
        return listenerPort;
    }

    private static final class Lock {
        private final int[] ports;

        public Lock(int ... ports) {
            this.ports = ports;
        }

        public int[] getPorts() {
            return this.ports;
        }
    }
}

