/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.custom.factory;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanFactory
implements Serializable,
ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference reference = (Reference)obj;
        try {
            Class<?> beanClass;
            try {
                beanClass = Thread.currentThread().getContextClassLoader().loadClass(reference.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new NamingException("Unable to load class : " + reference.getClassName());
            }
            Object bean = beanClass.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            Enumeration<RefAddr> enumeration = reference.getAll();
            block4: while (enumeration.hasMoreElements()) {
                RefAddr ra = enumeration.nextElement();
                String propertyName = ra.getType();
                String value = (String)ra.getContent();
                for (PropertyDescriptor desc : properties) {
                    if (!desc.getName().equals(propertyName)) continue;
                    String type = desc.getPropertyType().getName();
                    Object result = null;
                    if (type != null) {
                        if ((type = type.toUpperCase(Locale.getDefault())).endsWith("INT") || type.endsWith("INTEGER")) {
                            result = Integer.valueOf(value);
                        } else if (type.endsWith("LONG")) {
                            result = Long.valueOf(value);
                        } else if (type.endsWith("DOUBLE")) {
                            result = Double.valueOf(value);
                        } else if (type.endsWith("FLOAT")) {
                            result = Float.valueOf(value);
                        } else if (type.endsWith("CHAR") || type.endsWith("CHARACTER")) {
                            result = Character.valueOf(value.charAt(0));
                        } else if (type.endsWith("SHORT")) {
                            result = Short.valueOf(value);
                        } else if (type.endsWith("BYTE")) {
                            result = Byte.valueOf(value);
                        } else if (type.endsWith("BOOLEAN")) {
                            result = Boolean.valueOf(value);
                        } else if (type.endsWith("STRING")) {
                            result = value;
                        }
                    } else {
                        throw new NamingException("Unable to find the type of property : " + propertyName);
                    }
                    Method setter = desc.getWriteMethod();
                    if (setter != null) {
                        setter.invoke(bean, result);
                        continue block4;
                    }
                    throw new NamingException("Unable to find the setter method for property : " + propertyName);
                }
            }
            return bean;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Unable to instantiate JavaBean");
            ne.setRootCause(e);
            throw ne;
        }
    }
}

