/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.Set;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class TransactionAttributeHandler
extends AbstractAttributeHandler
implements PostProcessor<EjbContext> {
    public Class<? extends Annotation> getAnnotationType() {
        return TransactionAttribute.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        TransactionAttribute taAn = (TransactionAttribute)ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            ContainerTransaction containerTransaction = this.getContainerTransaction(taAn.value());
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, (PostProcessor)this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            Set txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
            for (Object next : txBusMethods) {
                MethodDescriptor nextDesc = (MethodDescriptor)next;
                Method m = nextDesc.getMethod(ejbDesc);
                if (!TypeUtil.sameMethodSignature((Method)m, (Method)annMethod) || ejbDesc.getContainerTransactionFor(nextDesc) != null) continue;
                ejbDesc.setContainerTransactionFor(nextDesc, containerTransaction);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private ContainerTransaction getContainerTransaction(TransactionAttributeType taType) {
        switch (taType) {
            case MANDATORY: {
                return new ContainerTransaction("Mandatory", "Mandatory");
            }
            case REQUIRED: {
                return new ContainerTransaction("Required", "Required");
            }
            case REQUIRES_NEW: {
                return new ContainerTransaction("RequiresNew", "RequiresNew");
            }
            case SUPPORTS: {
                return new ContainerTransaction("Supports", "Supports");
            }
            case NOT_SUPPORTED: {
                return new ContainerTransaction("NotSupported", "NotSupported");
            }
        }
        return new ContainerTransaction("Never", "Never");
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[]{MessageDriven.class, Stateful.class, Stateless.class, Singleton.class, Timeout.class, TransactionManagement.class};
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    public void postProcessAnnotation(AnnotationInfo ainfo, EjbContext ejbContext) throws AnnotationProcessorException {
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        TransactionAttribute taAn = (TransactionAttribute)ainfo.getAnnotation();
        ContainerTransaction containerTransaction = this.getContainerTransaction(taAn.value());
        Class classAn = (Class)ainfo.getAnnotatedElement();
        Set txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
        for (Object mdObj : txBusMethods) {
            MethodDescriptor md = (MethodDescriptor)mdObj;
            if (!classAn.equals(ejbContext.getDeclaringClass(md)) || ejbDesc.getContainerTransactionFor(md) != null) continue;
            ejbDesc.setContainerTransactionFor(md, containerTransaction);
        }
    }
}

