/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.glassfish.osgiweb.ContextPathCollisionException;
import org.glassfish.osgiweb.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.BundleReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextPathCollisionDetector
implements BundleListener {
    private static ContextPathCollisionDetector _me = new ContextPathCollisionDetector();
    private static Logger logger = Logger.getLogger(ContextPathCollisionDetector.class.getPackage().getName());
    private Map<String, Long> contextPath2WabMap = new HashMap<String, Long>();
    private Map<String, List<Long>> contextPath2CollidingWabsMap = new HashMap<String, List<Long>>();
    private ServiceTracker osgiContainerTracker = new ServiceTracker(this.getBundle().getBundleContext(), OSGiContainer.class.getName(), null);
    private boolean stopped;

    private ContextPathCollisionDetector() {
        this.osgiContainerTracker.open();
        this.getBundle().getBundleContext().addBundleListener((BundleListener)this);
    }

    public static ContextPathCollisionDetector get() {
        return _me;
    }

    synchronized void stop() {
        this.getBundle().getBundleContext().removeBundleListener((BundleListener)this);
        this.osgiContainerTracker.close();
        this.stopped = true;
    }

    public synchronized void preDeploy(Bundle bundle) throws ContextPathCollisionException {
        if (this.stopped) {
            return;
        }
        String contextPath = Util.getContextPath(bundle);
        Long deployedBundle = this.getCurrentlyDeployedBundle(contextPath);
        Long bundleId = bundle.getBundleId();
        if (deployedBundle == null) {
            assert (this.getCollidingWabs(contextPath).isEmpty());
        } else {
            if (deployedBundle.equals(bundleId)) {
                return;
            }
            this.addCollidingWab(contextPath, bundleId);
            throw new ContextPathCollisionException(contextPath, this.getAllWabs(contextPath).toArray(new Long[0]));
        }
        this.setCurrentlyDeployedBundle(contextPath, bundleId);
    }

    public synchronized void postUndeploy(Bundle bundle) {
        if (this.stopped) {
            return;
        }
        Long bundleId = bundle.getBundleId();
        String contextPath = Util.getContextPath(bundle);
        Long deployedBundle = this.getCurrentlyDeployedBundle(contextPath);
        assert (bundleId.equals(deployedBundle));
        this.unsetCurrentlyDeployedBundle(contextPath);
        List<Long> collidingWabs = this.getCollidingWabs(contextPath);
        Collections.sort(collidingWabs);
        ListIterator<Long> li = collidingWabs.listIterator();
        while (li.hasNext()) {
            Long nextBundleInList = li.next();
            logger.logp(Level.INFO, "CollisionDetector", "postUndeploy", "Collision detector is attempting to deploy bundle {0} with context path {1} ", new Object[]{nextBundleInList, contextPath});
            try {
                Bundle nextBundle = this.getBundle(nextBundleInList);
                li.remove();
                if (nextBundle == null) {
                    logger.logp(Level.INFO, "ContextPathCollisionDetector", "postUndeploy", "Collision detector is skipping bundle [{0}], for it has been uninstalled.", new Object[]{nextBundle});
                    continue;
                }
                this.setCurrentlyDeployedBundle(contextPath, nextBundleInList);
                OSGiApplicationInfo osgiApplicationInfo = this.getOSGiContainer().deploy(nextBundle);
                if (osgiApplicationInfo == null) continue;
                break;
            }
            catch (Exception e) {
                this.unsetCurrentlyDeployedBundle(contextPath);
                logger.logp(Level.WARNING, "CollisionDetector", "postUndeploy", "Collision detector got exception while trying to deploy the bundle with lowest id", e);
            }
        }
    }

    public synchronized void cleanUp(Bundle bundle) {
        String contextPath = Util.getContextPath(bundle);
        Long bundleId = bundle.getBundleId();
        Long deployedBundle = this.getCurrentlyDeployedBundle(contextPath);
        assert (bundleId.equals(deployedBundle));
        this.unsetCurrentlyDeployedBundle(contextPath);
        logger.logp(Level.INFO, "CollisionDetector", "cleanUp", "Removed bundle {0} against context path {1} ", new Object[]{bundleId, contextPath});
    }

    private synchronized Long getCurrentlyDeployedBundle(String contextPath) {
        return this.contextPath2WabMap.get(contextPath);
    }

    private synchronized void setCurrentlyDeployedBundle(String contextPath, Long bundleId) {
        assert (bundleId != null);
        this.contextPath2WabMap.put(contextPath, bundleId);
    }

    private synchronized void unsetCurrentlyDeployedBundle(String contextPath) {
        this.contextPath2WabMap.put(contextPath, null);
    }

    private synchronized List<Long> getCollidingWabs(String contextPath) {
        List<Long> bundleIds = this.contextPath2CollidingWabsMap.get(contextPath);
        if (bundleIds == null) {
            bundleIds = new ArrayList<Long>();
            this.contextPath2CollidingWabsMap.put(contextPath, bundleIds);
        }
        return bundleIds;
    }

    private synchronized List<Long> addCollidingWab(String contextPath, Long bundleId) {
        List<Long> bundleIds = this.getCollidingWabs(contextPath);
        bundleIds.add(bundleId);
        return bundleIds;
    }

    private synchronized boolean removeCollingWab(String contextPath, long bundleId) {
        return this.getCollidingWabs(contextPath).remove(bundleId);
    }

    private synchronized List<Long> getAllWabs(String contextPath) {
        ArrayList<Long> result = new ArrayList<Long>(this.getCollidingWabs(contextPath));
        Long deployedBundle = this.getCurrentlyDeployedBundle(contextPath);
        if (deployedBundle != null) {
            result.add(0, deployedBundle);
        }
        return result;
    }

    private Bundle getBundle(Long bundleId) {
        return this.getBundle().getBundleContext().getBundle(bundleId.longValue());
    }

    private OSGiContainer getOSGiContainer() {
        return (OSGiContainer)this.osgiContainerTracker.getService();
    }

    private Bundle getBundle() {
        return ((BundleReference)BundleReference.class.cast(this.getClass().getClassLoader())).getBundle();
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle;
        String contextPath;
        if (4 == event.getType() && (contextPath = Util.getContextPath(bundle = event.getBundle())) != null && this.removeCollingWab(contextPath, bundle.getBundleId())) {
            logger.logp(Level.INFO, "CollisionDetector", "bundleChanged", "Removed bundle [{0}] from colliding bundles list for contextPath {1}", new Object[]{bundle.getBundleId(), contextPath});
        }
    }
}

