/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.pipe;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.Cancelable;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.ComponentRegistry;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.pipe.Tube;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Fiber
implements Runnable,
Cancelable,
ComponentRegistry {
    private List<Listener> _listeners = new ArrayList<Listener>();
    private Tube[] conts = new Tube[16];
    private int contsSize;
    private Tube next;
    private Packet packet;
    private Throwable throwable;
    public final Engine owner;
    private volatile int suspendedCount = 0;
    private volatile boolean isInsideSuspendCallbacks = false;
    private volatile boolean completed;
    private boolean synchronous;
    private boolean interrupted;
    private final int id;
    private List<FiberContextSwitchInterceptor> interceptors;
    private InterceptorHandler interceptorHandler;
    private boolean needsToReenter;
    @Nullable
    private ClassLoader contextClassLoader;
    @Nullable
    private CompletionCallback completionCallback;
    private Thread currentThread;
    private volatile boolean isCanceled;
    private boolean started;
    private boolean startedSync;
    private String currentThreadMonitor = "CurrentThreadMonitor";
    private static final ThreadLocal<Fiber> CURRENT_FIBER = new ThreadLocal();
    private static final AtomicInteger iotaGen = new AtomicInteger();
    private static final Logger LOGGER = Logger.getLogger(Fiber.class.getName());
    private static final ReentrantLock serializedExecutionLock = new ReentrantLock();
    public static volatile boolean serializeExecution = Boolean.getBoolean(Fiber.class.getName() + ".serialize");
    private final Set<Component> components = new CopyOnWriteArraySet<Component>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this._listeners;
        synchronized (list) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        List<Listener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Listener> getCurrentListeners() {
        List<Listener> list = this._listeners;
        synchronized (list) {
            return new ArrayList<Listener>(this._listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        List<Listener> list = this._listeners;
        synchronized (list) {
            this._listeners.clear();
        }
    }

    Fiber(Engine engine) {
        this.owner = engine;
        if (Fiber.isTraceEnabled()) {
            this.id = iotaGen.incrementAndGet();
            LOGGER.fine(this.getName() + " created");
        } else {
            this.id = -1;
        }
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void start(@NotNull Tube tubeline, @NotNull Packet request, @Nullable CompletionCallback completionCallback) {
        this.start(tubeline, request, completionCallback, false);
    }

    private void dumpFiberContext(String desc) {
        if (Fiber.isTraceEnabled()) {
            String action = null;
            String msgId = null;
            if (this.packet != null) {
                for (SOAPVersion sv : SOAPVersion.values()) {
                    for (AddressingVersion av : AddressingVersion.values()) {
                        action = this.packet.getMessage() != null ? this.packet.getMessage().getHeaders().getAction(av, sv) : null;
                        String string2 = msgId = this.packet.getMessage() != null ? this.packet.getMessage().getHeaders().getMessageID(av, sv) : null;
                        if (action != null || msgId != null) break;
                    }
                    if (action != null || msgId != null) break;
                }
            }
            String actionAndMsgDesc = action == null && msgId == null ? "NO ACTION or MSG ID" : "'" + action + "' and msgId '" + msgId + "'";
            String tubeDesc = this.next != null ? this.next.toString() + ".processRequest()" : this.peekCont() + ".processResponse()";
            LOGGER.fine(this.getName() + " " + desc + " with " + actionAndMsgDesc + " and 'current' tube " + tubeDesc + " from thread " + Thread.currentThread().getName() + " with Packet: " + (this.packet != null ? this.packet.toShortString() : null));
        }
    }

    public void start(@NotNull Tube tubeline, @NotNull Packet request, @Nullable CompletionCallback completionCallback, boolean forceSync) {
        this.next = tubeline;
        this.packet = request;
        this.completionCallback = completionCallback;
        if (forceSync) {
            this.startedSync = true;
            this.dumpFiberContext("starting (sync)");
            this.run();
        } else {
            this.started = true;
            this.dumpFiberContext("starting (async)");
            this.owner.addRunnable(this);
        }
    }

    public void resume(@NotNull Packet resumePacket) {
        this.resume(resumePacket, false);
    }

    public synchronized void resume(@NotNull Packet resumePacket, boolean forceSync) {
        this.resume(resumePacket, forceSync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(@NotNull Packet resumePacket, boolean forceSync, CompletionCallback callback) {
        Fiber fiber = this;
        synchronized (fiber) {
            if (callback != null) {
                this.setCompletionCallback(callback);
            }
            if (Fiber.isTraceEnabled()) {
                LOGGER.fine(this.getName() + " resuming. Will have suspendedCount=" + (this.suspendedCount - 1));
            }
            this.packet = resumePacket;
            if (--this.suspendedCount == 0) {
                if (!this.isInsideSuspendCallbacks) {
                    List<Listener> listeners = this.getCurrentListeners();
                    for (Listener listener : listeners) {
                        try {
                            listener.fiberResumed(this);
                        }
                        catch (Throwable e) {
                            if (!Fiber.isTraceEnabled()) continue;
                            LOGGER.fine("Listener " + listener + " threw exception: " + e.getMessage());
                        }
                    }
                    if (this.synchronous) {
                        this.notifyAll();
                    } else if (forceSync || this.startedSync) {
                        this.run();
                    } else {
                        this.dumpFiberContext("resuming (async)");
                        this.owner.addRunnable(this);
                    }
                }
            } else if (Fiber.isTraceEnabled()) {
                LOGGER.fine(this.getName() + " taking no action on resume because suspendedCount != 0: " + this.suspendedCount);
            }
        }
    }

    public synchronized void resumeAndReturn(@NotNull Packet resumePacket, boolean forceSync) {
        if (Fiber.isTraceEnabled()) {
            LOGGER.fine(this.getName() + " resumed with Return Packet");
        }
        this.next = null;
        this.resume(resumePacket, forceSync);
    }

    public synchronized void resume(@NotNull Throwable throwable) {
        this.resume(throwable, false);
    }

    public synchronized void resume(@NotNull Throwable error, boolean forceSync) {
        if (Fiber.isTraceEnabled()) {
            LOGGER.fine(this.getName() + " resumed with Return Throwable");
        }
        this.next = null;
        this.throwable = error;
        this.resume(this.packet, forceSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(boolean mayInterrupt) {
        this.isCanceled = true;
        if (mayInterrupt) {
            Fiber fiber = this;
            synchronized (fiber) {
                if (this.currentThread != null) {
                    this.currentThread.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean suspend() {
        Fiber fiber = this;
        synchronized (fiber) {
            if (Fiber.isTraceEnabled()) {
                LOGGER.fine(this.getName() + " suspending. Will have suspendedCount=" + (this.suspendedCount + 1));
                if (this.suspendedCount > 0) {
                    LOGGER.fine("WARNING - " + this.getName() + " suspended more than resumed. Will require more than one resume to actually resume this fiber.");
                }
            }
            List<Listener> listeners = this.getCurrentListeners();
            if (++this.suspendedCount == 1) {
                this.isInsideSuspendCallbacks = true;
                try {
                    for (Listener listener : listeners) {
                        try {
                            listener.fiberSuspended(this);
                        }
                        catch (Throwable e) {
                            if (!Fiber.isTraceEnabled()) continue;
                            LOGGER.fine("Listener " + listener + " threw exception: " + e.getMessage());
                        }
                    }
                }
                finally {
                    this.isInsideSuspendCallbacks = false;
                }
            }
            if (this.suspendedCount <= 0) {
                for (Listener listener : listeners) {
                    try {
                        listener.fiberResumed(this);
                    }
                    catch (Throwable e) {
                        if (!Fiber.isTraceEnabled()) continue;
                        LOGGER.fine("Listener " + listener + " threw exception: " + e.getMessage());
                    }
                }
                return false;
            }
            return true;
        }
    }

    public void addInterceptor(@NotNull FiberContextSwitchInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<FiberContextSwitchInterceptor>();
            this.interceptorHandler = new InterceptorHandler();
        }
        this.interceptors.add(interceptor);
        this.needsToReenter = true;
    }

    public boolean removeInterceptor(@NotNull FiberContextSwitchInterceptor interceptor) {
        if (this.interceptors != null && this.interceptors.remove(interceptor)) {
            this.needsToReenter = true;
            return true;
        }
        return false;
    }

    @Nullable
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public ClassLoader setContextClassLoader(@Nullable ClassLoader contextClassLoader) {
        ClassLoader r = this.contextClassLoader;
        this.contextClassLoader = contextClassLoader;
        return r;
    }

    @Override
    @Deprecated
    public void run() {
        assert (!this.synchronous);
        this.doRun();
        if (this.startedSync && this.suspendedCount == 0 && (this.next != null || this.contsSize > 0)) {
            this.startedSync = false;
            this.dumpFiberContext("restarting (async) after startSync");
            this.owner.addRunnable(this);
        } else {
            this.completionCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized Packet runSync(@NotNull Tube tubeline, @NotNull Packet request) {
        Tube[] oldCont = this.conts;
        int oldContSize = this.contsSize;
        boolean oldSynchronous = this.synchronous;
        Tube oldNext = this.next;
        if (oldContSize > 0) {
            this.conts = new Tube[16];
            this.contsSize = 0;
        }
        try {
            this.synchronous = true;
            this.packet = request;
            this.next = tubeline;
            this.doRun();
            if (this.throwable != null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                if (this.throwable instanceof Error) {
                    throw (Error)this.throwable;
                }
                throw new AssertionError((Object)this.throwable);
            }
            Packet packet = this.packet;
            return packet;
        }
        finally {
            this.conts = oldCont;
            this.contsSize = oldContSize;
            this.synchronous = oldSynchronous;
            this.next = oldNext;
            if (this.interrupted) {
                Thread.currentThread().interrupt();
                this.interrupted = false;
            }
            if (!this.started && !this.startedSync) {
                this.completionCheck();
            }
        }
    }

    private synchronized void completionCheck() {
        if (!this.isCanceled && this.contsSize == 0 && this.suspendedCount == 0) {
            if (Fiber.isTraceEnabled()) {
                LOGGER.fine(this.getName() + " completed");
            }
            this.completed = true;
            this.clearListeners();
            this.notifyAll();
            if (this.completionCallback != null) {
                if (this.throwable != null) {
                    this.completionCallback.onCompletion(this.throwable);
                } else {
                    this.completionCallback.onCompletion(this.packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        this.dumpFiberContext("running");
        if (serializeExecution) {
            serializedExecutionLock.lock();
            try {
                this._doRun(this.next);
            }
            finally {
                serializedExecutionLock.unlock();
            }
        } else {
            this._doRun(this.next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doRun(Tube next) {
        Thread thread;
        String string2 = this.currentThreadMonitor;
        synchronized (string2) {
            if (this.currentThread != null && !this.synchronous) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Attempt to run Fiber ['" + this + "'] in more than one thread. Current Thread: " + this.currentThread + " Attempted Thread: " + Thread.currentThread());
                }
                while (this.currentThread != null) {
                    try {
                        this.currentThreadMonitor.wait();
                    }
                    catch (Exception e) {}
                }
            }
            thread = this.currentThread = Thread.currentThread();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Thread entering _doRun(): " + thread);
            }
        }
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(this.contextClassLoader);
        try {
            do {
                this.needsToReenter = false;
                if (this.interceptorHandler == null) {
                    this.next = next;
                    this.__doRun();
                    continue;
                }
                next = this.interceptorHandler.invoke(next);
            } while (this.needsToReenter);
        }
        finally {
            thread.setContextClassLoader(old);
            String string3 = this.currentThreadMonitor;
            synchronized (string3) {
                this.currentThread = null;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Thread leaving _doRun(): " + thread);
                }
                this.currentThreadMonitor.notify();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void __doRun() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void pushCont(Tube tube) {
        this.conts[this.contsSize++] = tube;
        int len = this.conts.length;
        if (this.contsSize == len) {
            Tube[] newBuf = new Tube[len * 2];
            System.arraycopy(this.conts, 0, newBuf, 0, len);
            this.conts = newBuf;
        }
    }

    private Tube popCont() {
        return this.conts[--this.contsSize];
    }

    private Tube peekCont() {
        int index = this.contsSize - 1;
        if (index >= 0 && index < this.conts.length) {
            return this.conts[index];
        }
        return null;
    }

    public void resetCont(Tube[] conts, int contsSize) {
        this.conts = conts;
        this.contsSize = contsSize;
    }

    private boolean isBlocking(boolean justSuspended) {
        if (this.synchronous) {
            while (this.suspendedCount == 1) {
                try {
                    if (Fiber.isTraceEnabled()) {
                        LOGGER.fine(this.getName() + " is blocking thread " + Thread.currentThread().getName());
                    }
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.interrupted = true;
                }
            }
            return false;
        }
        return justSuspended || this.suspendedCount == 1;
    }

    private String getName() {
        return "engine-" + this.owner.id + "fiber-" + this.id;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public Packet getPacket() {
        return this.packet;
    }

    public CompletionCallback getCompletionCallback() {
        return this.completionCallback;
    }

    public void setCompletionCallback(CompletionCallback completionCallback) {
        this.completionCallback = completionCallback;
    }

    public static boolean isSynchronous() {
        return Fiber.current().synchronous;
    }

    public boolean isStartedSync() {
        return this.startedSync;
    }

    @NotNull
    public static Fiber current() {
        Fiber fiber = CURRENT_FIBER.get();
        if (fiber == null) {
            throw new IllegalStateException("Can be only used from fibers");
        }
        return fiber;
    }

    public static Fiber getCurrentIfSet() {
        return CURRENT_FIBER.get();
    }

    private static boolean isTraceEnabled() {
        return LOGGER.isLoggable(Level.FINE);
    }

    @Override
    public <S> S getSPI(Class<S> spiType) {
        for (Component c : this.components) {
            S spi = c.getSPI(spiType);
            if (spi == null) continue;
            return spi;
        }
        return null;
    }

    @Override
    public Set<Component> getComponents() {
        return this.components;
    }

    public static interface CompletionCallback {
        public void onCompletion(@NotNull Packet var1);

        public void onCompletion(@NotNull Throwable var1);
    }

    private class InterceptorHandler
    implements FiberContextSwitchInterceptor.Work<Tube, Tube> {
        private int idx;

        private InterceptorHandler() {
        }

        Tube invoke(Tube next) {
            this.idx = 0;
            return this.execute(next);
        }

        @Override
        public Tube execute(Tube next) {
            if (this.idx != Fiber.this.interceptors.size()) {
                FiberContextSwitchInterceptor interceptor = (FiberContextSwitchInterceptor)Fiber.this.interceptors.get(this.idx++);
                return interceptor.execute(Fiber.this, next, this);
            }
            Fiber.this.next = next;
            Fiber.this.__doRun();
            return Fiber.this.next;
        }
    }

    public static interface Listener {
        public void fiberSuspended(Fiber var1);

        public void fiberResumed(Fiber var1);
    }
}

