/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.recovery;

import com.sun.enterprise.transaction.jts.api.DelegatedTransactionRecoveryFence;
import com.sun.enterprise.transaction.jts.api.TransactionRecoveryFence;
import com.sun.enterprise.transaction.jts.recovery.GMSCallBack;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoveryLockFile
implements TransactionRecoveryFence,
DelegatedTransactionRecoveryFence {
    static Logger _logger = LogDomains.getLogger(RecoveryLockFile.class, (String)"javax.enterprise.system.core.transaction");
    private static final String SEPARATOR = " ";
    private static final String OWN = "O";
    private static final String FOR = "F";
    private static final String BY = "B";
    private static final String END_LINE = "\n";
    private static final RecoveryLockFile instance = new RecoveryLockFile();
    private volatile boolean started = false;
    private String instance_name;
    private String log_path;
    private GMSCallBack gmsCallBack;

    private RecoveryLockFile() {
    }

    public static DelegatedTransactionRecoveryFence getDelegatedTransactionRecoveryFence(GMSCallBack gmsCallBack) {
        instance.init(gmsCallBack);
        return instance;
    }

    public void start() {
        if (!this.started) {
            this.gmsCallBack.finishDelegatedRecovery(this.log_path);
            this.started = true;
        }
    }

    private void init(GMSCallBack gmsCallBack) {
        this.gmsCallBack = gmsCallBack;
        try {
            this.instance_name = Configuration.getPropertyValue("com.sun.jts.instancename");
            this.log_path = LogControl.getLogPath();
            File recoveryLockFile = LogControl.recoveryLockFile(null, this.log_path);
            recoveryLockFile.createNewFile();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
        }
        RecoveryManager.registerTransactionRecoveryFence(this);
    }

    public void raiseFence() {
        while (this.isRecovering()) {
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {}
        }
        this.registerRecovery();
    }

    public void lowerFence() {
        _logger.log(Level.INFO, "Lower Fence request for instance " + this.instance_name);
        this.doneRecovering();
        _logger.log(Level.INFO, "Fence lowered for instance " + this.instance_name);
    }

    public boolean isFenceRaised(String logDir, String instance, long timestamp) {
        return this.isRecovering(logDir, instance, timestamp, BY);
    }

    public void raiseFence(String logPath, String instance) {
        this.raiseFence(logPath, instance, 0L);
    }

    public void raiseFence(String logPath, String instance, long timestamp) {
        _logger.log(Level.INFO, "Raise Fence request for instance " + instance);
        while (this.isRecovering(logPath, instance, timestamp, BY)) {
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {}
        }
        this.registerRecovery(logPath, instance);
        _logger.log(Level.INFO, "Fence raised for instance " + instance);
    }

    public void lowerFence(String logPath, String instance) {
        _logger.log(Level.INFO, "Lower Fence request for instance " + instance);
        this.doneRecovering(logPath, instance);
        _logger.log(Level.INFO, "Fence lowered for instance " + instance);
    }

    public String getInstanceRecoveredFor(String path, long timestamp) {
        if (!this.isRecovering(path, null, timestamp, FOR)) {
            return this.doneRecovering(path, null, FOR);
        }
        return null;
    }

    public void transferRecoveryTo(String logDir, String instance) {
        this.doneRecovering(logDir, null, BY);
        this.registerRecovery(logDir, instance);
    }

    private boolean isRecovering() {
        return this.isRecovering(this.log_path, this.instance_name, 0L, BY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRecovering(String logDir, String instance, long timestamp, String prefix) {
        block14: {
            reader = null;
            recoveryLockFile = LogControl.recoveryLockFile(".", logDir);
            if (!recoveryLockFile.exists()) {
                RecoveryLockFile._logger.log(Level.INFO, "Lock File not found " + recoveryLockFile);
                return false;
            }
            result = false;
            try {
                RecoveryLockFile._logger.log(Level.INFO, "Checking Lock File " + recoveryLockFile);
                raf = new RandomAccessFile(recoveryLockFile, "rw");
                lock = raf.getChannel().lock();
                try {
                    reader = new BufferedReader(new FileReader(recoveryLockFile));
                    line = null;
                    while ((line = reader.readLine()) != null) {
                        RecoveryLockFile._logger.log(Level.INFO, "Testing line: " + line);
                        parts = line.split(" ");
                        if (parts.length != 3) {
                            throw new IllegalStateException();
                        }
                        if ((!parts[0].equals("O") || !parts[1].equals(instance)) && (instance != null || !parts[0].equals(prefix))) continue;
                        result = Long.parseLong(parts[2]) > timestamp;
                        break;
                    }
                    var14_13 = null;
                }
                catch (Throwable var13_15) {
                    var14_14 = null;
                    lock.release();
                    throw var13_15;
                }
                lock.release();
                var16_16 = null;
                if (reader == null) break block14;
                ** GOTO lbl56
            }
            catch (Exception ex) {
                RecoveryLockFile._logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
                var16_17 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {
                        RecoveryLockFile._logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
                    }
                }
                break block14;
            }
            {
                catch (Throwable var15_22) {
                    var16_18 = null;
                    if (reader == null) throw var15_22;
                    ** try [egrp 3[TRYBLOCK] [6 : 316->324)] { 
lbl51:
                    // 1 sources

                    reader.close();
                    throw var15_22;
lbl53:
                    // 1 sources

                    catch (Exception ex) {
                        RecoveryLockFile._logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
                    }
                    throw var15_22;
                }
lbl56:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [6 : 316->324)] { 
lbl57:
                // 1 sources

                reader.close();
lbl59:
                // 1 sources

                catch (Exception ex) {}
                RecoveryLockFile._logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
            }
        }
        RecoveryLockFile._logger.log(Level.INFO, "Recovering? " + result);
        return result;
    }

    private void doneRecovering() {
        this.doneRecovering(this.log_path, this.instance_name, OWN);
    }

    private void doneRecovering(String logPath, String instance) {
        this.doneRecovering(this.log_path, instance, FOR);
        this.doneRecovering(logPath, this.instance_name, BY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String doneRecovering(String logPath, String instance, String prefix) {
        String result;
        block26: {
            Exception ex222;
            OutputStreamWriter writer;
            BufferedReader reader;
            block24: {
                reader = null;
                writer = null;
                result = null;
                File recoveryLockFile = LogControl.recoveryLockFile(".", logPath);
                if (!recoveryLockFile.exists()) {
                    _logger.log(Level.INFO, "Lock Fine not found: " + recoveryLockFile);
                    return null;
                }
                RandomAccessFile raf = new RandomAccessFile(recoveryLockFile, "rw");
                FileLock lock = raf.getChannel().lock();
                try {
                    reader = new BufferedReader(new FileReader(recoveryLockFile));
                    _logger.log(Level.INFO, "Updating File " + recoveryLockFile);
                    String line = null;
                    ArrayList<String> list_out = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        _logger.log(Level.INFO, "Processing line: " + line);
                        String[] parts = line.split(SEPARATOR);
                        if (parts.length != 3) {
                            _logger.log(Level.INFO, "...skipping bad line ...");
                            continue;
                        }
                        if (parts[0].equals(prefix) && (instance == null || parts[1].equals(instance))) {
                            _logger.log(Level.INFO, "...skipping found line ...");
                            result = parts[1];
                            continue;
                        }
                        list_out.add(line);
                    }
                    reader.close();
                    reader = null;
                    writer = new FileWriter(recoveryLockFile);
                    for (String out : list_out) {
                        _logger.log(Level.INFO, "Re-adding line: " + out);
                        writer.write(out);
                        writer.write(END_LINE);
                    }
                    Object var15_15 = null;
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    lock.release();
                    throw throwable;
                }
                lock.release();
                Object var17_18 = null;
                if (reader == null) break block24;
                try {
                    reader.close();
                }
                catch (Exception ex222) {
                    _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex222);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex222) {
                    _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex222);
                }
            }
            break block26;
            {
                catch (Exception ex3) {
                    Exception ex222;
                    _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex3);
                    Object var17_19 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception ex222) {
                            _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex222);
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception ex222) {
                            _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception ex222;
                Object var17_20 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex222) {
                        _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex222);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception ex222) {
                        _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex222);
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    private void registerRecovery() {
        this.doneRecovering(this.log_path, null, BY);
        this.registerRecovery(this.log_path, this.instance_name, OWN);
    }

    private void registerRecovery(String logPath, String instance) {
        this.doneRecovering(this.log_path, null, FOR);
        this.registerRecovery(logPath, this.instance_name, BY);
        this.registerRecovery(this.log_path, instance, FOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerRecovery(String logPath, String instance, String prefix) {
        OutputStreamWriter writer = null;
        File recoveryLockFile = LogControl.recoveryLockFile(".", logPath);
        if (!recoveryLockFile.exists()) {
            _logger.log(Level.INFO, "Lock File not found " + recoveryLockFile);
            return;
        }
        RandomAccessFile raf = new RandomAccessFile(recoveryLockFile, "rw");
        FileLock lock = raf.getChannel().lock();
        try {
            writer = new FileWriter(recoveryLockFile, true);
            _logger.log(Level.INFO, "Writing into file " + recoveryLockFile);
            StringBuffer b = new StringBuffer().append(prefix).append(SEPARATOR).append(instance).append(SEPARATOR).append(System.currentTimeMillis()).append(END_LINE);
            _logger.log(Level.INFO, "Storing " + b);
            writer.write(b.toString());
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            lock.release();
            throw throwable;
        }
        lock.release();
        Object var12_13 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (Exception ex2) {
            _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex2);
        }
        return;
        {
            catch (Exception ex) {
                _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
                Object var12_14 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (Exception ex2) {
                    _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception ex2) {
                _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex2);
            }
            throw throwable;
        }
    }
}

