/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.enterprise.transaction.api.TransactionImport;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Vote;

public class XATerminatorImpl
implements XATerminator {
    private static final TransactionImport tim = XATerminatorImpl.getTransactionImportManager();
    private static final String AS_TXN_MGR_JNDI_NAME = "java:appserver/TransactionManager";

    private static void check(Xid xid) throws XAException {
        if (xid == null || xid.getFormatId() == 0 || xid.getBranchQualifier() == null || xid.getGlobalTransactionId() == null) {
            throw new XAException(-4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        boolean exceptionFlag;
        GlobalTID tid;
        block23: {
            XATerminatorImpl.check(xid);
            tid = new GlobalTID(xid);
            if (onePhase) {
                try {
                    XATerminatorImpl.recreate(xid, 0);
                }
                catch (Throwable e) {
                    XAException xaExc = new XAException(-6);
                    xaExc.initCause(e);
                    throw xaExc;
                }
            } else if (!RecoveryManager.readAndUpdateTxMap(tid)) {
                throw new XAException(-6);
            }
            exceptionFlag = false;
            int errorCode = -6;
            try {
                block26: {
                    try {
                        RecoveryManager.waitForRecovery();
                        TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
                        if (coord == null) {
                            errorCode = -6;
                            throw new XAException(errorCode);
                        }
                        TopCoordinator topCoordinator = coord;
                        synchronized (topCoordinator) {
                            block24: {
                                block25: {
                                    if (!onePhase) break block24;
                                    coord.beforeCompletion();
                                    if (coord.getParticipantCount() != 1) break block25;
                                    coord.commitOnePhase();
                                    break block26;
                                }
                                Vote vote = Vote.VoteRollback;
                                try {
                                    vote = coord.prepare();
                                }
                                catch (HeuristicMixed exc) {
                                    errorCode = 8;
                                    throw new XAException(errorCode);
                                }
                                if (vote == Vote.VoteCommit) {
                                    coord.commit();
                                    break block26;
                                } else if (vote == Vote.VoteRollback) {
                                    coord.rollback(true);
                                }
                                break block26;
                            }
                            coord.commit();
                        }
                    }
                    catch (Throwable exc) {
                        exceptionFlag = true;
                        XAException xaExc = new XAException(errorCode);
                        xaExc.initCause(exc);
                        throw xaExc;
                    }
                }
                Object var12_14 = null;
                if (!onePhase) break block23;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (onePhase) {
                    try {
                        XATerminatorImpl.release(xid);
                        throw throwable;
                    }
                    catch (Throwable t) {
                        if (exceptionFlag) throw throwable;
                        XAException xaExc = new XAException(-6);
                        xaExc.initCause(t);
                        throw xaExc;
                    }
                }
                Thread thread = RecoveryManager.removeFromTxMap(tid);
                if (thread != null) {
                    if (thread == Thread.currentThread()) throw throwable;
                }
                if (exceptionFlag) throw throwable;
                throw new XAException(-3);
            }
            try {}
            catch (Throwable t) {
                if (exceptionFlag) return;
                XAException xaExc = new XAException(-6);
                xaExc.initCause(t);
                throw xaExc;
            }
            XATerminatorImpl.release(xid);
            return;
        }
        Thread thread = RecoveryManager.removeFromTxMap(tid);
        if (thread != null) {
            if (thread == Thread.currentThread()) return;
        }
        if (exceptionFlag) return;
        throw new XAException(-3);
    }

    public void forget(Xid xid) throws XAException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepare(Xid xid) throws XAException {
        int n;
        int errorCode;
        boolean exceptionFlag;
        block18: {
            int n2;
            block17: {
                XATerminatorImpl.check(xid);
                GlobalTID tid = new GlobalTID(xid);
                try {
                    XATerminatorImpl.recreate(xid, 0);
                }
                catch (Throwable e) {
                    XAException xaExc = new XAException(-6);
                    xaExc.initCause(e);
                    throw xaExc;
                }
                exceptionFlag = false;
                errorCode = -6;
                try {
                    try {
                        RecoveryManager.waitForRecovery();
                        TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
                        if (coord == null) {
                            errorCode = -6;
                            throw new XAException(errorCode);
                        }
                        TopCoordinator topCoordinator = coord;
                        synchronized (topCoordinator) {
                            coord.beforeCompletion();
                            Vote vote = coord.prepare();
                            if (vote == Vote.VoteRollback) {
                                errorCode = 100;
                                throw new XAException(errorCode);
                            }
                            if (vote == Vote.VoteCommit) {
                                n2 = 0;
                                // MONITOREXIT @DISABLED, blocks:[16, 1, 2, 7] lbl29 : MonitorExitStatement: MONITOREXIT : var6_9
                                Object var11_14 = null;
                                break block17;
                            }
                            if (vote != Vote.VoteReadOnly) throw new XAException(errorCode);
                            n = 3;
                        }
                        break block18;
                    }
                    catch (Throwable exc) {
                        exceptionFlag = true;
                        XAException xaExc = new XAException(errorCode);
                        xaExc.initCause(exc);
                        throw xaExc;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    try {
                        XATerminatorImpl.release(xid);
                        throw throwable;
                    }
                    catch (Throwable t) {
                        if (exceptionFlag) throw throwable;
                        errorCode = -6;
                        XAException xaExc = new XAException(errorCode);
                        xaExc.initCause(t);
                        throw xaExc;
                    }
                }
            }
            try {}
            catch (Throwable t) {
                if (exceptionFlag) return n2;
                errorCode = -6;
                XAException xaExc = new XAException(errorCode);
                xaExc.initCause(t);
                throw xaExc;
            }
            XATerminatorImpl.release(xid);
            return n2;
        }
        Object var11_15 = null;
        try {}
        catch (Throwable t) {
            if (exceptionFlag) return n;
            errorCode = -6;
            XAException xaExc = new XAException(errorCode);
            xaExc.initCause(t);
            throw xaExc;
        }
        XATerminatorImpl.release(xid);
        return n;
    }

    public Xid[] recover(int flag) throws XAException {
        RecoveryManager.waitForResync();
        return TimeoutManager.getInDoubtXids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(Xid xid) throws XAException {
        XATerminatorImpl.check(xid);
        GlobalTID tid = new GlobalTID(xid);
        if (!RecoveryManager.readAndUpdateTxMap(tid)) {
            throw new XAException(-6);
        }
        boolean exceptionFlag = false;
        int errorCode = -6;
        try {
            try {
                RecoveryManager.waitForRecovery();
                TopCoordinator coord = (TopCoordinator)RecoveryManager.getCoordinator(tid);
                if (coord == null) {
                    errorCode = -6;
                    throw new XAException(errorCode);
                }
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    coord.rollback(true);
                }
            }
            catch (Throwable exc) {
                exceptionFlag = true;
                XAException xaExc = new XAException(errorCode);
                xaExc.initCause(exc);
                throw xaExc;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Thread thread = RecoveryManager.removeFromTxMap(tid);
            if (!(thread != null && thread == Thread.currentThread() || exceptionFlag)) {
                throw new XAException(-3);
            }
            throw throwable;
        }
        Thread thread = RecoveryManager.removeFromTxMap(tid);
        if (!(thread != null && thread == Thread.currentThread() || exceptionFlag)) {
            throw new XAException(-3);
        }
    }

    private static Object jndiLookup(String jndiName) {
        Object result = null;
        try {
            InitialContext ctx = new InitialContext();
            result = ctx.lookup(jndiName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return result;
    }

    private static TransactionImport getTransactionImportManager() {
        return (TransactionImport)XATerminatorImpl.jndiLookup(AS_TXN_MGR_JNDI_NAME);
    }

    private static void recreate(Xid xid, int timeout) {
        if (tim != null) {
            tim.recreate(xid, (long)timeout);
        }
    }

    private static void release(Xid xid) {
        if (tim != null) {
            tim.release(xid);
        }
    }
}

