/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.config.GrizzlyServiceListener;
import com.sun.grizzly.config.Utils;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.util.FutureImpl;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyConfig {
    private static final Logger logger = LoggerUtils.getLogger();
    private final NetworkConfig config;
    private final Habitat habitat;
    private final List<GrizzlyServiceListener> listeners = new ArrayList<GrizzlyServiceListener>();

    public GrizzlyConfig(String file) {
        this.habitat = Utils.getHabitat(file);
        this.config = (NetworkConfig)this.habitat.getComponent(NetworkConfig.class);
    }

    public NetworkConfig getConfig() {
        return this.config;
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public List<GrizzlyServiceListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupNetwork() {
        GrizzlyConfig.validateConfig(this.config);
        List<GrizzlyServiceListener> list = this.listeners;
        synchronized (list) {
            List<NetworkListener> networkListeners = this.config.getNetworkListeners().getNetworkListener();
            final FutureImpl future = new FutureImpl();
            final AtomicInteger counter = new AtomicInteger(networkListeners.size());
            for (final NetworkListener listener : networkListeners) {
                Controller controller = new Controller(){

                    public void logVersion() {
                    }
                };
                controller.addStateListener((ControllerStateListener)new ControllerStateListenerAdapter(){

                    public void onReady() {
                        if (counter.decrementAndGet() == 0) {
                            future.setResult((Object)Boolean.TRUE);
                        }
                    }

                    public void onException(Throwable e) {
                        future.setException((Throwable)new IllegalStateException("Failed to start listener on port=" + listener.getPort(), e));
                    }
                });
                GrizzlyServiceListener grizzlyListener = new GrizzlyServiceListener(controller);
                grizzlyListener.configure(listener, this.habitat);
                this.listeners.add(grizzlyListener);
                WorkerThreadImpl thread = new WorkerThreadImpl((Runnable)new ListenerRunnable(grizzlyListener));
                thread.setDaemon(true);
                thread.start();
            }
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNetwork() {
        List<GrizzlyServiceListener> list = this.listeners;
        synchronized (list) {
            for (GrizzlyServiceListener listener : this.listeners) {
                try {
                    listener.stop();
                }
                catch (Exception e) {}
            }
            this.listeners.clear();
        }
    }

    private static void validateConfig(NetworkConfig config) {
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            listener.findHttpProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<GrizzlyServiceListener> copy;
        List<GrizzlyServiceListener> list = this.listeners;
        synchronized (list) {
            copy = new ArrayList<GrizzlyServiceListener>(this.listeners);
        }
        for (GrizzlyServiceListener listener : copy) {
            listener.stop();
        }
    }

    public static boolean toBoolean(String value) {
        String v = null != value ? value.trim() : value;
        return "true".equals(v) || "yes".equals(v) || "on".equals(v) || "1".equals(v);
    }

    private static class ListenerRunnable
    implements Runnable {
        private final GrizzlyServiceListener grizzlyListener;

        public ListenerRunnable(GrizzlyServiceListener grizzlyListener) {
            this.grizzlyListener = grizzlyListener;
        }

        public void run() {
            try {
                this.grizzlyListener.start();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

