/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.http.HttpSelectorHandler;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.KeepAliveThreadAttachment;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.algorithms.NoParsingAlgorithm;
import com.sun.grizzly.tcp.SuspendResponseUtils;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.StreamAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultProtocolFilter
implements ProtocolFilter {
    private static final PostProcessor POST_PROCESSOR = new PostProcessor();
    protected Class algorithmClass;
    protected int port;
    protected InetAddress address;
    protected static final Logger logger = SelectorThread.logger();
    private static final ByteBuffer NULL_BUFFER = ByteBuffer.allocate(0);

    @Deprecated
    public DefaultProtocolFilter(Class algorithmClass, int port) {
        this.algorithmClass = algorithmClass;
        this.port = port;
    }

    public DefaultProtocolFilter(Class algorithmClass, InetAddress address, int port) {
        this.algorithmClass = algorithmClass;
        this.address = address;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        StreamAlgorithm streamAlgorithm;
        if (Boolean.TRUE.equals(ctx.getAttribute("delayedClose"))) {
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
            return false;
        }
        HttpWorkerThread workerThread = (HttpWorkerThread)((Object)Thread.currentThread());
        SelectorThread selectorThread = ((HttpSelectorHandler)ctx.getSelectorHandler()).getSelectorThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        InputReader inputStream = workerThread.getInputStream();
        if (inputStream == null) {
            inputStream = new InputReader();
            workerThread.setInputStream(inputStream);
        }
        if ((streamAlgorithm = workerThread.getStreamAlgorithm()) == null) {
            try {
                streamAlgorithm = (StreamAlgorithm)this.algorithmClass.newInstance();
            }
            catch (InstantiationException ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(LogMessages.WARNING_GRIZZLY_HTTP_DPF_STREAM_ALGORITHM_INIT_ERROR((Object)this.algorithmClass.getName()));
                }
            }
            catch (IllegalAccessException ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(LogMessages.WARNING_GRIZZLY_HTTP_DPF_STREAM_ALGORITHM_INIT_ERROR((Object)this.algorithmClass.getName()));
                }
            }
            finally {
                if (streamAlgorithm == null) {
                    streamAlgorithm = new NoParsingAlgorithm();
                }
            }
            streamAlgorithm.setPort(this.port);
        } else {
            workerThread.setStreamAlgorithm(null);
        }
        SelectionKey key = ctx.getSelectionKey();
        this.configureInputBuffer(inputStream, ctx, workerThread);
        SocketChannel socketChannel = (SocketChannel)key.channel();
        streamAlgorithm.setChannel((Object)socketChannel);
        byteBuffer = streamAlgorithm.preParse(byteBuffer);
        boolean keepAlive = false;
        ProcessorTask processorTask = workerThread.getProcessorTask();
        if (streamAlgorithm.parse(byteBuffer)) {
            if (processorTask == null) {
                processorTask = selectorThread.getProcessorTask();
                workerThread.setProcessorTask(processorTask);
            }
            KeepAliveThreadAttachment k = (KeepAliveThreadAttachment)workerThread.getAttachment();
            k.setTimeout(System.currentTimeMillis());
            KeepAliveStats ks = selectorThread.getKeepAliveStats();
            k.setKeepAliveStats(ks);
            ctx.getSelectionKey().attach((Object)k);
            if (selectorThread.getKeepAliveTimeoutInSeconds() == 0) {
                processorTask.setDropConnection(true);
            } else if (selectorThread.getMaxKeepAliveRequests() != -1) {
                int count = k.getKeepAliveCount();
                if (count > 0 && count >= selectorThread.getMaxKeepAliveRequests()) {
                    if (ks.isEnabled()) {
                        ks.incrementCountRefusals();
                    }
                    processorTask.setDropConnection(true);
                } else {
                    processorTask.setDropConnection(false);
                }
            }
            this.configureProcessorTask(processorTask, ctx, streamAlgorithm);
            try {
                processorTask.setAsyncPostProcessor(POST_PROCESSOR);
                keepAlive = processorTask.process((InputStream)inputStream, null);
                boolean isSuspended = SuspendResponseUtils.removeSuspendedInCurrentThread();
                if (processorTask != null && !processorTask.isError() && isSuspended) {
                    workerThread.setInputStream(new InputReader());
                    workerThread.setByteBuffer(null);
                    workerThread.setProcessorTask(null);
                    workerThread.setInputBB(null);
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
                    return true;
                }
            }
            catch (Throwable ex) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, LogMessages.SEVERE_GRIZZLY_HTTP_DPF_PROCESSOR_TASK_ERROR(), ex);
                }
                keepAlive = false;
            }
        } else {
            if (ctx.getProtocol() == Controller.Protocol.TCP) {
                ctx.getSelectionKey().attach(null);
            } else {
                workerThread.getAttachment().setTimeout(Long.MIN_VALUE);
            }
            keepAlive = true;
        }
        streamAlgorithm.postParse(byteBuffer);
        inputStream.recycle();
        if (processorTask != null) {
            processorTask.recycle();
        }
        if (keepAlive) {
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
        } else if (selectorThread.isAsyncHttpWriteEnabled()) {
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
            DefaultProtocolFilter.flushAsyncWriteQueueAndClose(ctx.getSelectorHandler(), key);
        } else {
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
        }
        byteBuffer.clear();
        if (selectorThread.isRcmSupported()) {
            ctx.removeAttribute("bbInputStream");
            ctx.removeAttribute("byteBuffer");
            ctx.removeAttribute("invokeNextFilter");
        }
        if (processorTask != null && processorTask.isSkipPostExecute()) {
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        }
        return true;
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }

    protected void configureProcessorTask(ProcessorTask processorTask, Context context, StreamAlgorithm streamAlgorithm) {
        SelectionKey key = context.getSelectionKey();
        processorTask.setSelectorHandler(context.getSelectorHandler());
        processorTask.setSelectionKey(key);
        processorTask.setSocket(((SocketChannel)key.channel()).socket());
        if (processorTask.getStreamAlgorithm() == null) {
            processorTask.setStreamAlgorithm(streamAlgorithm);
        }
    }

    protected void configureInputBuffer(InputReader inputStream, Context context, HttpWorkerThread workerThread) {
        inputStream.recycle();
        inputStream.setSelectionKey(context.getSelectionKey());
        inputStream.setByteBuffer(workerThread.getByteBuffer());
        inputStream.setSecure(this.isSecure());
    }

    protected boolean isSecure() {
        return false;
    }

    protected static void flushAsyncWriteQueueAndClose(final SelectorHandler selectorHandler, final SelectionKey key) {
        try {
            selectorHandler.getAsyncQueueWriter().write(key, NULL_BUFFER, new AsyncWriteCallbackHandler(){

                public void onWriteCompleted(SelectionKey key2, AsyncQueueWriteUnit writtenRecord) {
                    this.close();
                }

                public void onException(Exception exception, SelectionKey key2, ByteBuffer buffer, Queue<AsyncQueueWriteUnit> remainingQueue) {
                    this.close();
                }

                private void close() {
                    selectorHandler.addPendingKeyCancel(key);
                }
            });
        }
        catch (Exception e) {
            selectorHandler.addPendingKeyCancel(key);
        }
    }

    private static final class PostProcessor
    implements ProcessorTask.PostProcessor {
        private PostProcessor() {
        }

        public boolean postProcess(ProcessorTask processorTask) {
            boolean keepAlive = processorTask.isKeepAlive();
            SelectorHandler selectorHandler = processorTask.getSelectorHandler();
            SelectionKey selectionKey = processorTask.getSelectionKey();
            SelectorThread selectorThread = processorTask.getSelectorThread();
            if (keepAlive) {
                selectorHandler.register(selectionKey, 1);
            } else if (selectorThread.isAsyncHttpWriteEnabled()) {
                DefaultProtocolFilter.flushAsyncWriteQueueAndClose(selectorHandler, selectionKey);
            } else {
                selectorHandler.addPendingKeyCancel(selectionKey);
            }
            ((InputReader)processorTask.getInputStream()).recycle();
            processorTask.recycle();
            selectorThread.returnTask(processorTask);
            return true;
        }
    }
}

